-- Set default_space for users who have null defaultSpace
-- For each user with null defaultSpace, set it to their first space (alphabetically by name)
UPDATE users u
SET default_space_id = (
    SELECT s.space_id
    FROM space s
    INNER JOIN space_users su ON su.space_id = s.space_id
    WHERE su.user_id = u.user_id
      AND s.deleted_dttm IS NULL
    ORDER BY s.name ASC
    LIMIT 1
)
WHERE u.default_space_id IS NULL
  AND EXISTS (
      SELECT 1
      FROM space_users su2
      WHERE su2.user_id = u.user_id
  );

-- Make default_space_id column NOT NULL
ALTER TABLE users ALTER COLUMN default_space_id SET NOT NULL;

