INSERT INTO inscada.role_permissions (role_permission_id, role_id, permission_id, insert_dttm, insert_user)
SELECT
    gen_random_uuid(),
    r.role_id,
    p.permission_id,
    CURRENT_TIMESTAMP,
    'system'
FROM
    inscada.roles r
        JOIN
    inscada.permissions p ON r.space_id = p.space_id
WHERE
    r.name = 'administrator'
  -- 1. ENFORCE NON-NULL SPACE_ID FOR THE ROLE:
  AND r.space_id IS NOT NULL
  -- 2. LIST OF REQUIRED PERMISSIONS:
  AND p.name IN (
                 'CREATE_SPACE_ROLE', 'UPDATE_SPACE_ROLE', 'DELETE_SPACE_ROLE',
                 'VIEW_SPACE_ROLES', 'EXPORT_SPACE_ROLES', 'IMPORT_SPACE_ROLES',
                 'VIEW_SPACE_MENUS', 'DELETE_SPACE_USER', 'CREATE_SPACE_USER',
                 'VIEW_SPACE_PERMISSIONS', 'VIEW_SPACE_USERS', 'UPDATE_SPACE_USER',
                 'UPDATE_IP_FILTER_SETTINGS'
    )
  -- 3. EXCLUDE PERMISSIONS THAT ALREADY EXIST FOR THE ROLE:
  AND NOT EXISTS (
        SELECT 1
        FROM inscada.role_permissions rp
        WHERE rp.role_id = r.role_id AND rp.permission_id = p.permission_id
    );