-- Remove VIEW_SYSTEM_STATS and VIEW_CLUSTER_STATUS permissions
-- Step 1: delete role-permission mappings referencing these permissions (avoids FK violations)
DELETE FROM inscada.role_permissions rp
USING inscada.permissions p
WHERE rp.permission_id = p.permission_id
  AND p.name IN ('VIEW_SYSTEM_STATS', 'VIEW_CLUSTER_STATUS');

-- Step 2: delete the permissions themselves (both global and per-space rows)
DELETE FROM inscada.permissions
WHERE name IN ('VIEW_SYSTEM_STATS', 'VIEW_CLUSTER_STATUS');

-- Steps 3-4: delete role-menu mappings, then menus for the following names
-- Combine in two statements using IN to cover global and per-space rows
WITH menus_to_remove AS (
  SELECT menu_id FROM inscada.menus WHERE name IN ('Cluster Status','Online Users','System Stats','System')
)
DELETE FROM inscada.role_menus rm
USING menus_to_remove mr
WHERE rm.menu_id = mr.menu_id;

DELETE FROM inscada.menus
WHERE name IN ('Cluster Status','Online Users','System Stats','System');
