CREATE
OR REPLACE FUNCTION insert_initial_space_data()
  RETURNS TRIGGER
  LANGUAGE PLPGSQL
  AS
$$
begin
insert into inscada.mail_settings(smtp_host, smtp_port, protocol, username, password, insert_user, insert_dttm,
                                  space_id)
select 'mail.inscada.com',
       25,
       'SMTP',
       'inscada',
       '',
       'inscada',
       now(),
       NEW.space_id;

insert into inscada.sms_settings(provider, default_flag, insert_user, insert_dttm, space_id)
select 'dataport', true, 'inscada', now(), NEW.space_id;

insert into inscada.sms_settings(provider, default_flag, insert_user, insert_dttm, space_id)
select 'twilio', false, 'inscada', now(), NEW.space_id;

insert into inscada.sms_settings(provider, default_flag, insert_user, insert_dttm, space_id)
select 'netgsm', false, 'inscada', now(), NEW.space_id;

insert into inscada.broadcast_settings(server_ip_addr, insert_user, insert_dttm, space_id)
select 'https://www.inscada.com', 'inscada', now(), NEW.space_id;

insert into inscada.map_settings(map_api_key, weather_api_key, insert_user, insert_dttm, space_id)
select 'pk.eyJ1IjoieXJ5c2t1bCIsImEiOiJjazc0ZDc0NmswMnlvM2ptdnRqaW4ya3IxIn0.9YN8pWOfuz19ILnJy311ww',
       'd1a6442a2d89164ee9cc3d3a9c9c7ed3',
       'inscada',
       now(),
       NEW.space_id;

insert into inscada.custom_table_settings(url, username, password, insert_user, insert_dttm, space_id)
select 'jdbc:postgresql://localhost:5432/mydb', 'postgres', '', 'inscada', now(), NEW.space_id;

insert into inscada.logo_settings(sidebar_logo_height, insert_user, insert_dttm, space_id)
select 70, 'inscada', now(), NEW.space_id;

RETURN NEW;
END;
$$;