create table project
(
    project_id    serial       not null
        constraint project_project_id_pk
        primary key,
    name          varchar(100) not null,
    dsc           varchar(255),
    start_dt      date         not null,
    end_dt        date         not null,
    address       varchar(255),
    latitude      numeric,
    longitude     numeric,
    contract_day  integer,
    contract_hour varchar(10),
    active_flag   boolean      not null,
    properties    text,
    insert_user   varchar(50)  not null,
    insert_dttm   timestamp with time zone not null,
    version_user  varchar(50),
    version_dttm  timestamp with time zone
);

create unique index project_name_uindex
    on project (name)
;

create table script
(
    script_id         serial       not null
        constraint script_script_id_pk
        primary key,
    project_id        integer      not null
        constraint script_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name              varchar(100) not null,
    dsc               varchar(255),
    code              text         not null,
    code_template     text,
    template_variable text,
    sch_type          varchar(50)  not null,
    period            integer,
    delay             integer,
    sch_time          time,
    cron_exp          varchar(50),
    log_flag          boolean      not null,
    insert_user       varchar(50)  not null,
    insert_dttm       timestamp with time zone not null,
    version_user      varchar(50),
    version_dttm      timestamp with time zone
)
;

create unique index script_project_id_name_uindex
    on script (project_id, name)
;

create table animation
(
    animation_id serial       not null
        constraint animation_animation_id_pk
        primary key,
    project_id   integer      not null
        constraint animation_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name         varchar(100) not null,
    dsc          varchar(255),
    svg_content  text         not null,
    is_template boolean,
    anim_join_id integer,
    color        varchar(7),
    duration     integer      not null,
    play_order   smallint     not null,
    main_flag    boolean      not null,
    pre_anim_code text,
    post_anim_code text,
    insert_user  varchar(50)  not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index animation_project_id_name_uindex
    on animation (project_id, name)
;

create table animation_element
(
    anim_element_id serial       not null
        constraint animation_element_anim_element_id_pk
        primary key,
    animation_id    integer      not null
        constraint animation_element_animation_animation_id_fk
        references animation
        on update cascade on delete cascade,
    name            varchar(100) not null,
    dsc             varchar(255),
    expression      text         not null,
    expression_type varchar(20) default 'EXPRESSION':: character varying not null,
    type            varchar(50)  not null,
    dom_id          varchar(100) not null,
    props           text         not null,
    status_flag     boolean      not null,
    insert_user     varchar(50)  not null,
    insert_dttm     timestamp with time zone not null,
    version_user    varchar(50),
    version_dttm    timestamp with time zone
)
;

create unique index animation_element_animation_id_name_uindex
    on animation_element (animation_id, name)
;

create table animation_script
(
	animation_script_id serial not null
		constraint animation_script_id_pk
			primary key,
	animation_id integer not null,
	type varchar(20) not null,
	script_id        integer not null
    constraint animation_script_script_id_fk
    references script
    on update cascade on delete cascade ,
	insert_user varchar(50) not null,
	insert_dttm timestamp with time zone not null,
	version_user varchar(50),
	version_dttm timestamp with time zone
)
;

create table smart_symbol
(
    smart_symbol_id serial not null
        constraint smart_symbol_id_pk
        primary key,
    name         varchar(100)  not null,
    category     varchar(255),
    svg_content  text not null,
    insert_user  varchar(50)   not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index smart_symbol_category_name
    on smart_symbol (category, name)
;

create table smart_symbol_expression
(
     smart_symbol_expression_id serial not null
        constraint smart_symbol_expression_id_pk
        primary key,
    name         varchar(100)  not null,
    dsc          varchar(255),
    code         text not null,
    insert_user  varchar(50)   not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index smart_symbol_expression_name
    on smart_symbol_expression (name)
;

create table trend
(
    trend_id     serial       not null
        constraint trend_trend_id_pk
        primary key,
    project_id   integer      not null
        constraint trend_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name         varchar(100) not null,
    dsc          varchar(255),
    period       integer      not null,
    insert_user  varchar(50)  not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index trend_project_id_name_uindex
    on trend (project_id, name)
;

create table trend_tag
(
    trend_tag_id serial         not null
        constraint trend_tag_trend_tag_id_pk
        primary key,
    trend_id     integer        not null
        constraint trend_tag_trend_trend_id_fk
        references trend
        on update cascade on delete cascade,
    name         varchar(100)   not null,
    dsc          varchar(255),
    variable_id  integer        not null,
    min_scale    numeric        not null,
    max_scale    numeric        not null,
    color        varchar(7),
    thickness    smallint,
    status_flag  boolean        not null,
    insert_user  varchar(50)    not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index trend_tag_trend_id_name_uindex
    on trend_tag (trend_id, name)
;

create table report
(
    report_id    serial       not null
        constraint report_report_id_pk
        primary key,
    project_id   integer      not null
        constraint report_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name         varchar(100) not null,
    dsc          varchar(255),
    no           varchar(50),
    period       varchar(50)  not null,
    report_day   smallint,
    report_time  time,
    print_flag   boolean      not null,
    print_day    smallint,
    print_time   time,
    insert_user  varchar(50)  not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index report_name_uindex
    on report (project_id, name)
;

create table report_group
(
    report_group_id serial       not null
        constraint report_group_report_group_id_pk
        primary key,
    name            varchar(100) not null,
    report_id       integer      not null
        constraint report_group_report_report_id_fk
        references report
        on update cascade on delete cascade,
    group_order     smallint     not null,
    insert_user     varchar(50)  not null,
    insert_dttm     timestamp with time zone not null,
    version_user    varchar(50),
    version_dttm    timestamp with time zone
)
;

create unique index report_group_report_id_name_uindex
    on report_group (report_id, name)
;

create table report_subgroup
(
    report_subgroup_id serial       not null
        constraint report_subgroup_report_subgroup_id_pk
        primary key,
    name               varchar(100) not null,
    report_group_id    integer      not null
        constraint report_subgroup_report_group_report_group_id_fk
        references report_group
        on update cascade on delete cascade,
    subgroup_order     smallint     not null,
    insert_user        varchar(50)  not null,
    insert_dttm        timestamp with time zone not null,
    version_user       varchar(50),
    version_dttm       timestamp with time zone
)
;

create unique index report_subgroup_report_group_id_name_uindex
    on report_subgroup (report_group_id, name)
;

create table report_variable
(
    report_variable_id    serial       not null
        constraint report_variable_report_variable_id_pk
        primary key,
    name                  varchar(100) not null,
    report_subgroup_id    integer      not null
        constraint report_variable_report_subgroup_report_subgroup_id_fk
        references report_subgroup
        on update cascade on delete cascade,
    calc_type             varchar(50)  not null,
    variable_order        smallint     not null,
    variable_id           integer      not null,
    total_variable_id     integer,
    deviation_variable_id integer,
    insert_user           varchar(50)  not null,
    insert_dttm           timestamp with time zone not null,
    version_user          varchar(50),
    version_dttm          timestamp with time zone
)
;

create unique index report_variable_report_subgroup_id_name_uindex
    on report_variable (report_subgroup_id, name)
;

create table expression
(
    expression_id serial       not null
        constraint expression_expression_id_pk
        primary key,
    name          varchar(100) not null,
    dsc           varchar(255),
    code          text         not null,
    insert_user   varchar(50)  not null,
    insert_dttm   timestamp with time zone not null,
    version_user  varchar(50),
    version_dttm  timestamp with time zone
)
;

create unique index expression_name_uindex
    on expression (name)
;

create table connection
(
    conn_id      serial       not null
        constraint connection_conn_id_pk
        primary key,
    project_id   integer      not null
        constraint connection_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name         varchar(100) not null,
    dsc          varchar(255),
    protocol     varchar(50)  not null,
    ip           varchar(15)  not null,
    port         smallint     not null,
    insert_user  varchar(50)  not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index connection_project_id_name_uindex
    on connection (project_id, name)
;

create table dnp3_connection
(
    conn_id         integer     not null
        primary key,
    adapter         varchar(20) not null,
    pool_size       integer     not null,
    min_retry_delay integer,
    max_retry_delay integer
)
;

create table modbus_connection
(
    conn_id   integer not null
        primary key,
    timeout   integer,
    pool_size integer
)
;

create table iec104_connection
(
    conn_id                         integer not null
        primary key,
    local_ip                        varchar(100),
    local_port                      smallint,
    cot_field_length                integer,
    ca_field_length                 integer,
    ioa_field_length                integer,
    originator_address              integer,
    msg_fragment_timeout            integer,
    max_time_no_ack_received        integer,
    max_time_no_ack_sent            integer,
    max_idle_time                   integer,
    max_unconfirmed_i_pdus_received integer,
    start_dt_timeout                integer,
    start_dt_retries                integer
)
;

create table s7_connection
(
    conn_id                         integer not null
        primary key,
    rack integer not null,
    slot integer not null,
    timeout integer
)
;

create table device
(
    device_id    serial       not null
        constraint device_device_id_pk
        primary key,
    conn_id      integer
        constraint device_connection_conn_id_fk
        references connection
        on update cascade on delete cascade,
    name         varchar(100) not null,
    dsc          varchar(255),
    insert_user  varchar(50)  not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index device_conn_id_name_uindex
    on device (conn_id, name)
;

create unique index device_name_uindex
    on device (name) where conn_id is null
;

create table dnp3_device
(
    device_id                            integer not null
        primary key,
    local_address                        integer not null,
    remote_address                       integer not null,
    response_timeout                     integer,
    integrity_scan_time                  integer,
    event_scan_time                      integer,
    disable_unsolicited_on_startup_flag  boolean,
    unsolicited_events_flag              boolean,
    startup_integrity_flag               boolean,
    integrity_on_event_overflow_iin_flag boolean,
    max_controls_per_request             smallint,
    select_timeout                       integer,
    solicited_confirm_timeout            integer,
    unsolicited_retry_timeout            integer
)
;

create table modbus_device
(
    device_id       integer not null
        primary key,
    station_address integer,
    scan_time       integer not null,
    retain_flag     boolean
)
;

create table iec104_device
(
    device_id                          integer not null
        primary key,
    common_address                     integer not null,
    control_point_offset               integer,
    general_interrogation_time         integer,
    general_counter_interrogation_time integer
)
;

create table s7_device
(
    device_id                          integer not null
        primary key,
    scan_time       integer not null
)
;

create table frame
(
    frame_id       serial       not null
        constraint frame_frame_id_pk
        primary key,
    device_id      integer      not null
        constraint frame_device_device_id_fk
        references device
        on update cascade on delete cascade,
    name           varchar(100) not null,
    dsc            varchar(255),
    start_address  integer      not null,
    quantity       integer      not null,
    minutes_offset integer,
    insert_user    varchar(50)  not null,
    insert_dttm    timestamp with time zone not null,
    version_user   varchar(50),
    version_dttm   timestamp with time zone
)
;

create unique index frame_device_id_name_uindex
    on frame (device_id, name)
;

create table dnp3_frame
(
    frame_id          integer not null
        primary key,
    type              varchar(50) not null,
    event_buffer_size integer,
    point_class       varchar(20),
    static_variation  varchar(50),
    event_variation   varchar(50),
    dead_band         numeric
)
;

create table modbus_frame
(
    frame_id         integer not null
        primary key,
    type             varchar(50) not null,
    scan_time_factor integer,
    readable_flag    boolean not null,
    writable_flag    boolean not null
)
;

create table iec104_frame
(
    frame_id integer      not null
        primary key,
    type     varchar(100) not null
)
;

create table s7_frame
(
  frame_id integer      not null
        primary key,
  type             varchar(50) not null,
  db_number integer,
  scan_time_factor integer
)
;

create table variable
(
    variable_id            serial       not null
        constraint variable_variable_id_pk
        primary key,
    frame_id               integer
        constraint variable_frame_frame_id_fk
        references frame
        on update cascade on delete set null,
    project_id             integer
        constraint variable_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name                   varchar(100) not null,
    dsc                    varchar(255),
    code                   varchar(20),
    start_address          integer      not null,
    value_expression       text,
    fractional_digit_count smallint,
    raw_zero_scale         numeric,
    raw_full_scale         numeric,
    eng_zero_scale         numeric,
    eng_full_scale         numeric,
    unit                   varchar(10),
    log_type               varchar(25),
    log_period             integer,
    log_threshold          numeric,
    log_expression         varchar(4000),
    log_expression_id      integer
        constraint variable_log_expression_fk
        references expression
        on update cascade on delete set null,
    value_expression_type  varchar(50),
    value_expression_id    integer
        constraint variable_expression_expression_id_fk
        references expression
        on update cascade on delete set null,
    active_flag            boolean      not null,
    insert_user            varchar(50)  not null,
    insert_dttm            timestamp with time zone not null,
    version_user           varchar(50),
    version_dttm           timestamp with time zone
)
;

create unique index variable_project_id_name_uindex
    on variable (project_id, name)
;

create unique index variable_name_frame_id_uindex
    on variable (name, frame_id) where project_id is null
;

alter table variable add constraint project_id_frame_id_check CHECK (
   project_id is not null OR frame_id is not null
);

create table dnp3_variable
(
    variable_id      integer not null
        primary key,
    point_class      varchar(20),
    static_variation varchar(50),
    event_variation  varchar(50),
    dead_band        numeric
)
;

create table modbus_variable
(
    variable_id    integer not null
        primary key,
    type           varchar(50) not  null,
    byte_swap_flag boolean,
    word_swap_flag boolean
)
;

create table iec104_variable
(
    variable_id integer not null
        primary key
)
;

create table s7_variable
(
    variable_id integer not null
        primary key,
    type           varchar(50) not  null,
    bit_offset integer
)
;

alter table trend_tag
    add constraint trend_tag_variable_variable_id_fk
        foreign key (variable_id) references variable
            on update cascade
;

alter table report_variable
    add constraint report_variable_variable_variable_id_fk
        foreign key (variable_id) references variable
            on update cascade
;

alter table report_variable
    add constraint report_variable_variable_total_variable_id_fk
        foreign key (total_variable_id) references variable
            on update cascade
;

alter table report_variable
    add constraint report_variable_variable_deviation_variable_id_fk
        foreign key (deviation_variable_id) references variable
            on update cascade
;

create table users
(
    user_id serial not null
        constraint users_user_id_pk
        primary key,
    username varchar(50)  not null,
    passwd       varchar(60)  not null,
    email        varchar(255) not null,
    phone        varchar(15),
    insert_user  varchar(50)  not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index users_name_uindex
    on users (username)
;

create table roles
(
    role_id serial not null
        constraint roles_role_id_pk
        primary key,
    name varchar(100) not null,
    insert_user  varchar(50) not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index roles_name_uindex
    on roles (name)
;

create table permissions
(
    permission_id integer not null
        constraint permissions_permission_id_pk
        primary key,
    name varchar(100) not null
)
;

create unique index permissions_name_uindex
    on permissions (name)
;

create table role_members
(
    role_id int not null,
    user_id int not null
)
;

alter table role_members
    add constraint role_members_pk
        primary key (role_id, user_id)
;

alter table role_members
    add constraint role_members_role_id_fk
        foreign key (role_id) references roles
            on update cascade on delete restrict
;

alter table role_members
    add constraint role_members_user_id_fk
        foreign key (user_id) references users
            on update cascade on delete restrict
;

create table role_permissions
(
    role_id int not null,
    permission_id int not null
)
;

alter table role_permissions
    add constraint role_permissions_pk
        primary key (role_id, permission_id)
;

alter table role_permissions
    add constraint role_permissions_role_id_fk
        foreign key (role_id) references roles
            on update cascade on delete restrict
;

alter table role_permissions
    add constraint role_permissions_permission_id_fk
        foreign key (permission_id) references permissions
            on update cascade on delete restrict
;

create table menus
(
    menu_id integer not null
        constraint menus_menu_id_pk
        primary key,
    name varchar(100) not null
)
;

create unique index menus_name_uindex
    on menus (name)
;

create table role_menus
(
    role_id int not null,
    menu_id int not null
)
;

alter table role_menus
    add constraint role_menus_pk
        primary key (role_id, menu_id)
;

alter table role_menus
    add constraint role_menus_role_id_fk
        foreign key (role_id) references roles
            on update cascade on delete restrict
;

alter table role_menus
    add constraint role_menus_menu_id_fk
        foreign key (menu_id) references menus
            on update cascade on delete restrict
;

create table license
(
    license_id   serial      not null
        constraint license_license_id_pk
        primary key,
    license_key  varchar     not null,
    insert_user  varchar(50) not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create table auth_attempt
(
    auth_attempt_id serial      not null
        constraint auth_attempt_pkey
        primary key,
    username        varchar(50) not null,
    ip              varchar(15) not null,
    dttm            timestamp with time zone not null,
    is_successful   boolean     not null,
    msg             varchar(200)
)
;

create index auth_attempt_username_index
    on auth_attempt (username)
;

create index auth_attempt_ip_index
    on auth_attempt (ip)
;

create index auth_attempt_dttm_index
    on auth_attempt (dttm)
;

create table auth_token
(
    auth_token_id varchar(36)   not null
        constraint auth_token_pkey
        primary key,
    user_id integer not null
        constraint auth_token_users_user_id_fk
        references users
        on update cascade on delete cascade,
    issue_dttm    timestamp with time zone not null,
    timeout_in_mins integer,
    user_generated_flag boolean not null
);

create table alarm
(
    alarm_id      serial        not null
        constraint alarm_alarm_id_pk
        primary key,
    project_id    integer       not null
        constraint alarm_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name          varchar(100)  not null,
    dsc           varchar(255),
    delay         integer,
    group_id      integer,
    insert_user   varchar(50)   not null,
    insert_dttm   timestamp with time zone not null,
    version_user  varchar(50),
    version_dttm  timestamp with time zone
)
;
create unique index alarm_project_id_name_uindex
    on alarm (project_id, name)
;

create table analog_alarm
(
    alarm_id                integer not null
        primary key,
    variable_id             integer not null
        constraint analog_alarm_variable_variable_id_fk
        references variable
        on update cascade on delete restrict,
    set_point_value         numeric,
    high_high_value         numeric,
    high_value              numeric,
    low_value               numeric,
    low_low_value           numeric,
    dead_band               numeric,
    deviation_percentage    numeric
)
;

create table digital_alarm
(
    alarm_id                  integer not null
        primary key,
    variable_A_id             integer not null
        constraint digital_alarm_variable_A_variable_A_id_fk
        references variable
        on update cascade on delete restrict,
    variable_B_id             integer
        constraint digital_alarm_variable_B_variable_B_id_fk
        references variable
        on update cascade on delete restrict,
    on_time_variable_id       integer
        constraint digital_alarm_variable_on_time_variable_id_fk
        references variable
        on update cascade on delete restrict,
    off_time_variable_id      integer
        constraint digital_alarm_variable_off_time_variable_id_fk
        references variable
        on update cascade on delete restrict
)
;

create table custom_alarm
(
    alarm_id    integer not null
        primary key,
    condition   varchar(4000) not null
)
;

create table alarm_group
(
    alarm_group_id    serial       not null
        constraint alarm_group_pkey
        primary key,
    project_id        integer      not null
        constraint alarm_group_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name              varchar(100) not null,
    dsc               varchar(255),
    scan_time         integer,
    priority          smallint     not null,
    on_script_id      integer
        constraint alarm_group_script_script_id_fk
        references script
        on update cascade on delete set null,
    off_script_id     integer
        constraint alarm_group_script_off_script_id_fk
        references script
        on update cascade on delete set null,
    ack_script_id     integer
        constraint alarm_group_script_ack_script_id_fk
        references script
        on update cascade on delete set null,
    on_no_ack_color   varchar(7),
    on_ack_color      varchar(7),
    off_no_ack_color  varchar(7),
    off_ack_color     varchar(7),
    printer_ip        varchar(15),
    printer_port      smallint,
    print_when_on     boolean,
    print_when_off    boolean,
    print_when_ack    boolean,
    insert_user       varchar(50)  not null,
    insert_dttm       time with time zone not null,
    version_user      varchar(50),
    version_dttm      time with time zone
)
;

create unique index alarm_group_project_id_name_uindex
    on alarm_group (project_id, name)
;

alter table alarm
    add constraint alarm_alarm_group_alarm_group_id_fk
        foreign key (group_id) references alarm_group
            on update cascade on delete set null
;

create table procedure
(
    procedure_id serial       not null
        constraint procedure_procedure_id_pk
        primary key,
    project_id   integer      not null
        constraint procedure_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name         varchar(100) not null,
    dsc          varchar(255),
    background   varchar(10),
    text_color   varchar(10),
    gojs_model   text,
    main_flag    boolean      not null,
    insert_user  varchar(50)  not null,
    insert_dttm  time with time zone not null,
    version_user varchar(50),
    version_dttm time with time zone
)
;

create unique index procedure_project_id_name_uindex
    on procedure (project_id, name)
;

create table procedure_icon
(
    icon_id         serial              not null
        constraint procedure_icon_icon_id_pk
        primary key,
    name            varchar(100)        not null,
    dsc             varchar(255),
    expression      text,
    image_name      varchar(50),
    input_number    smallint            not null,
    inputa_position varchar(10),
    inputb_position varchar(10),
    inputa_index    smallint,
    inputb_index    smallint,
    inputc_position varchar(10),
    inputc_index    smallint,
    category_id     smallint            not null,
    width           smallint default 50 not null,
    height          smallint default 50 not null,
    insert_user     varchar(50)         not null,
    insert_dttm     time with time zone not null,
    version_user    varchar(50),
    version_dttm    time with time zone
)
;

create unique index procedure_icon_name_categoryid_uindex
    on procedure_icon (name, category_id)
;

create table procedure_icon_state
(
    icon_state_id serial       not null
        constraint procedure_icon_state_icon_state_id_pk
        primary key,
    icon_id       integer      not null
        constraint procedure_icon_state_procedure_icon_icon_id_fk
        references procedure_icon
        on update cascade on delete cascade,
    name          varchar(100) not null,
    image_name    varchar(50)
)
;

create unique index procedure_icon_state_icon_id_name_uindex
    on procedure_icon_state (icon_id, name)
;

create table icon_category
(
    category_id  serial       not null
        constraint icon_category_category_id_pk
        primary key,
    name         varchar(100) not null,
    insert_user  varchar(50)  not null,
    insert_dttm  time with time zone not null,
    version_user varchar(50),
    version_dttm time with time zone
)
;

create unique index icon_category_name_uindex
    on icon_category (name)
;

alter table procedure_icon
    add constraint procedure_icon_icon_category_category_id_fk
        foreign key (category_id) references icon_category
            on update cascade
;

create table sent_mail
(
    sent_mail_id serial       not null
        constraint sent_mail_sent_mail_id_pk
        primary key,
    from_addr    varchar(320) not null,
    to_addr      text         not null,
    dttm         timestamp with time zone not null,
    subject      varchar(4000),
    body         text
)
;

create index sent_mail_from_addr_index
    on sent_mail (from_addr)
;

create index sent_mail_dttm_index
    on sent_mail (dttm)
;

create index sent_mail_subject_index
    on sent_mail (subject)
;

create table sent_sms
(
    sent_sms_id serial       not null
        constraint sent_sms_sent_sms_id_pk
        primary key,
    from_addr    varchar(15) not null,
    to_addr      varchar(15) not null,
    username     varchar(50) not null,
    dttm         timestamp with time zone not null,
    message      varchar(4000)
)
;

create index sent_sms_from_addr_index
    on sent_sms (from_addr)
;

create index sent_sms_to_addr_index
    on sent_sms (to_addr)
;

create index sent_sms_username_index
    on sent_sms (username)
;

create index sent_sms_dttm_index
    on sent_sms (dttm)
;

create table sms_settings
(
    sms_settings_id serial       not null
        constraint sms_settings_sms_settings_id_pk
        primary key,
    acc_sid       varchar(50) not null,
    auth_token    varchar(50) not null,
    twilio_number varchar(15) not null,
    insert_user   varchar(50)  not null,
    insert_dttm   time with time zone not null,
    version_user  varchar(50),
    version_dttm  time with time zone
)
;

create table data_transfer
(
    data_transfer_id serial       not null
        constraint data_transfer_id_pk
        primary key,
    project_id       integer      not null,
    name             varchar(100) not null,
    dsc              varchar(255),
    period           integer      not null,
    insert_user      varchar(50)  not null,
    insert_dttm      timestamp with time zone not null,
    version_user     varchar(50),
    version_dttm     timestamp with time zone
)
;

create unique index data_transfer_project_id_name_uindex
    on data_transfer (project_id, name)
;

create table data_transfer_detail
(
    data_transfer_detail_id serial not null
        constraint data_transfer_detail_id_pk
        primary key,
    data_transfer_id integer not null
        constraint data_transfer_detail_data_transfer_data_transfer_id_fk
        references data_transfer
        on update cascade on delete cascade,
    source_var_id  integer not null
        constraint data_transfer_detail_variable_source_var_id_fk
        references variable
        on update cascade on delete restrict,
    target_var_id  integer not null
        constraint data_transfer_detail_variable_target_var_id_fk
        references variable
        on update cascade on delete restrict,
    insert_user  varchar(50) not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index data_transfer_detail_data_transfer_id_source_var_id_target_var_id_uindex
    on data_transfer_detail (data_transfer_id, source_var_id, target_var_id);

create table keyword
(
	keyword_id serial not null
		constraint keyword_id_pk
			primary key,
	type integer not null,
	key varchar(100) not null,
	dsc varchar(255),
	active boolean,
	insert_user varchar(50) not null,
	insert_dttm timestamp with time zone not null,
	version_user varchar(50),
	version_dttm timestamp with time zone
)
;

create unique index keyword_key_type_uindex
	on keyword (type, key)
;

create table monitor_table
(
    monitor_table_id serial       not null
        constraint monitor_table_id_pk
        primary key,
    project_id   integer      not null
        constraint monitor_table_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name         varchar(100) not null,
    dsc          varchar(255),
    x_count      integer,
    insert_user  varchar(50)  not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index monitor_table_project_id_name_uindex
    on monitor_table (project_id, name)
;

create table monitor_variable
(
	monitor_variable_id serial not null
		constraint monitor_variable_id_pk
			primary key,
	monitor_table_id integer not null,
	type varchar(20) not null,
	sort_order      integer,
	variable_id        integer not null
    constraint monitor_variable_variable_id_fk
    references variable
    on update cascade on delete cascade ,
	insert_user varchar(50) not null,
	insert_dttm timestamp with time zone not null,
	version_user varchar(50),
	version_dttm timestamp with time zone
)
;