create table custom_table
(
    custom_table_id serial       not null
        constraint custom_table_custom_table_id_pk
        primary key,
    name          varchar(100) not null,
    insert_user   varchar(50)  not null,
    insert_dttm   timestamp with time zone not null,
    version_user  varchar(50),
    version_dttm  timestamp with time zone
)
;

create unique index custom_table_name_uindex
    on custom_table (name)
;

create table custom_table_field
(
    custom_table_field_id       serial       not null
        constraint custom_table_field_custom_table_field_id_pk
        primary key,
    custom_table_id      integer      not null
        constraint custom_table_field_custom_table_custom_table_id_fk
        references custom_table
        on update cascade on delete cascade,
    field_name          varchar(100) not null,
    field_type          varchar(30) not null,
    field_length        integer,
    required            boolean  not null
)
;

INSERT INTO inscada.menus (menu_id, name)
VALUES (53, 'Custom Table'), (54, 'Custom Table SQL');

INSERT INTO inscada.role_menus (role_id, menu_id)
VALUES (1, 53), (1, 54);

ALTER SEQUENCE custom_table_custom_table_id_seq INCREMENT 50;
ALTER SEQUENCE custom_table_field_custom_table_field_id_seq INCREMENT 50;