-- Dynamic script to add a version column for optimistic locking to all tables with audit fields
-- This script queries the information_schema to find tables with audit columns
-- and generates ALTER TABLE statements for adding the version column.

DO $$
DECLARE
    table_record RECORD;
    sql_statement TEXT;
BEGIN
    -- Find all tables in inscada schema that have both insert_user and insert_dttm columns
    FOR table_record IN
        SELECT DISTINCT t.table_name
        FROM information_schema.tables t
        WHERE t.table_schema = 'inscada'
          AND t.table_type = 'BASE TABLE'
          AND EXISTS (
              SELECT 1
              FROM information_schema.columns c1
              WHERE c1.table_schema = 'inscada'
                AND c1.table_name = t.table_name
                AND c1.column_name = 'insert_user'
          )
          AND EXISTS (
              SELECT 1
              FROM information_schema.columns c2
              WHERE c2.table_schema = 'inscada'
                AND c2.table_name = t.table_name
                AND c2.column_name = 'insert_dttm'
          )
          AND NOT EXISTS (
              SELECT 1
              FROM information_schema.columns c3
              WHERE c3.table_schema = 'inscada'
                AND c3.table_name = t.table_name
                AND c3.column_name = 'version'
          )
        ORDER BY t.table_name
    LOOP
        -- Add version column with a default value for existing rows and set it to NOT NULL
        sql_statement := 'ALTER TABLE inscada.' || table_record.table_name || ' ADD COLUMN version BIGINT NOT NULL DEFAULT 0;';
        EXECUTE sql_statement;
        RAISE NOTICE 'Added version column to table: %', table_record.table_name;
    END LOOP;

    RAISE NOTICE 'Version column added to all tables with audit fields in inscada schema';
END $$;