-- Step 1: Update any existing users that have a NULL eula_accepted status.
-- We default them to false, as they have not explicitly accepted.
UPDATE
    inscada."users"
SET
    eula_accepted = false
WHERE
    eula_accepted IS NULL;

-- Step 2: Apply the NOT NULL constraint to the eula_accepted column.
-- This will only succeed if Step 1 has successfully updated all NULL values.
ALTER TABLE inscada."users"
ALTER COLUMN eula_accepted SET NOT NULL;