-- Add space-aware roles support
-- Add space_id column to roles table
ALTER TABLE roles ADD COLUMN space_id VARCHAR(36);

-- Drop existing unique index on name only (if it exists)
DROP INDEX IF EXISTS roles_name_uindex;

-- Create new unique index on name and space_id combination
CREATE UNIQUE INDEX roles_name_space_uindex ON roles(name, space_id);

-- Create index for better performance
CREATE INDEX idx_roles_space_id ON roles(space_id);

-- Add foreign key constraint
ALTER TABLE roles ADD CONSTRAINT fk_roles_space
    FOREIGN KEY (space_id) REFERENCES space(space_id);
