create table jasper_report
(
    jasper_report_id serial    not null
        constraint jasper_report_jasper_report_id_pk
        primary key,
    project_id   integer      not null
        constraint jasper_report_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name         varchar(100) not null,
    dsc          varchar(255),
    template_file  text       not null,
    parameters  text,
    datasource  text,
    subreports text,

    space_id     integer      not null,
    insert_user  varchar(50)  not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index jasper_report_project_id_name_uindex
    on jasper_report(project_id, name)
;

ALTER SEQUENCE jasper_report_jasper_report_id_seq RENAME TO jasper_report_seq;

ALTER SEQUENCE jasper_report_seq INCREMENT 50;

insert into inscada.permissions(permission_id, name)
values  (217, 'CREATE_JASPER_REPORT'), (218, 'VIEW_JASPER_REPORT'),
        (219, 'UPDATE_JASPER_REPORT'), (220, 'DELETE_JASPER_REPORT'),
        (221, 'EXPORT_JASPER_REPORT'), (222, 'IMPORT_JASPER_REPORT');

insert into inscada.role_permissions (role_id, permission_id)
values (1, 217), (1, 218), (1, 219), (1, 220), (1, 221), (1, 222);

INSERT INTO inscada.menus (menu_id, name)
VALUES (78, 'Jasper Report Dev');

INSERT INTO inscada.role_menus (role_id, menu_id)
VALUES (1, 78);