create table faceplate
(
    faceplate_id serial       not null
        constraint faceplate_faceplate_id_pk
        primary key,
    project_id   integer      not null
        constraint faceplate_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name         varchar(100) not null,
    dsc          varchar(255),
    svg_content  text         not null,
    color        varchar(25),
    placeholders text,

    space_id     integer      not null,
    insert_user  varchar(50)  not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index faceplate_project_id_name_uindex
    on faceplate (project_id, name)
;

create table faceplate_element
(
    faceplate_element_id serial       not null
        constraint faceplate_element_faceplate_element_id_pk
        primary key,
    faceplate_id    integer      not null
        constraint faceplate_element_faceplate_faceplate_id_fk
        references faceplate
        on update cascade on delete cascade,
    name            varchar(100) not null,
    expression      text,
    expression_type varchar(20) default 'EXPRESSION':: character varying not null,
    type            varchar(50)  not null,
    dom_id          varchar(100) not null,
    props           text,

    space_id        integer      not null,
    insert_user     varchar(50)  not null,
    insert_dttm     timestamp with time zone not null,
    version_user    varchar(50),
    version_dttm    timestamp with time zone
)
;

create unique index faceplate_element_faceplate_id_name_uindex
    on faceplate_element (faceplate_id, name)
;

create table animation_faceplate_element
(
    animation_faceplate_element_id serial not null
            constraint animation_faceplate_element_animation_faceplate_element_id_pk
            primary key,
    animation_element_id  integer      not null
            constraint animation_faceplate_element_animation_element_animation_element_id_fk
            references animation_element
            on update cascade on delete cascade,
    faceplate_element_id  integer      not null
            constraint animation_faceplate_element_faceplate_element_faceplate_element_id_fk
            references faceplate_element
            on update cascade on delete cascade,
    type            varchar(50)  not null,
    values           text,

    space_id        integer      not null,
    insert_user     varchar(50)  not null,
    insert_dttm     timestamp with time zone not null,
    version_user    varchar(50),
    version_dttm    timestamp with time zone
)
;

create unique index animation_faceplate_element_animation_element_id_faceplate_element_id_uindex
    on animation_faceplate_element (animation_element_id, faceplate_element_id)
;

ALTER SEQUENCE faceplate_faceplate_id_seq RENAME TO faceplate_seq;
ALTER SEQUENCE faceplate_element_faceplate_element_id_seq RENAME TO faceplate_element_seq;
ALTER SEQUENCE animation_faceplate_element_animation_faceplate_element_id_seq RENAME TO animation_faceplate_element_seq;

ALTER SEQUENCE faceplate_seq INCREMENT 50;
ALTER SEQUENCE faceplate_element_seq INCREMENT 50;
ALTER SEQUENCE animation_faceplate_element_seq INCREMENT 50;

insert into inscada.permissions(permission_id, name)
values  (205, 'CREATE_FACEPLATE'), (206, 'VIEW_FACEPLATE'),
        (207, 'UPDATE_FACEPLATE'), (208, 'DELETE_FACEPLATE'),
        (209, 'EXPORT_FACEPLATE'), (210, 'IMPORT_FACEPLATE');

insert into inscada.role_permissions (role_id, permission_id)
values (1, 205), (1, 206), (1, 207), (1, 208), (1, 209), (1, 210);

INSERT INTO inscada.menus (menu_id, name)
VALUES (75, 'Animation Dev'), (76, 'Faceplate Dev');

INSERT INTO inscada.role_menus (role_id, menu_id)
VALUES (1, 75), (1, 76);