INSERT INTO permissions (permission_id, name, is_global, space_id, insert_user, insert_dttm)
SELECT uuid(md5(p.name || '::' || s.space_id::text))::text AS permission_id, p.name,
       FALSE    AS is_global,
       s.space_id,
       'system' AS insert_user,
       NOW()    AS insert_dttm
FROM space s
         CROSS JOIN (VALUES ('VIEW_APPLICATION_MAIL_SETTINGS'),
                            ('UPDATE_APPLICATION_MAIL_SETTINGS'),
                            ('VIEW_APPLICATION_SMS_SETTINGS'),
                            ('UPDATE_APPLICATION_SMS_SETTINGS')) AS p(name)
WHERE s.space_id IS NOT NULL;

INSERT INTO inscada.role_permissions (role_permission_id, role_id, permission_id, insert_dttm, insert_user)
SELECT
    uuid(md5(r.role_id || '::' || p.permission_id))::text as role_permission_id,
    r.role_id,
    p.permission_id,
    CURRENT_TIMESTAMP,
    'system'
FROM
    inscada.roles r
        JOIN
    inscada.permissions p ON r.space_id = p.space_id
WHERE
    r.name = 'administrator'
  -- 1. ENFORCE NON-NULL SPACE_ID FOR THE ROLE:
  AND r.space_id IS NOT NULL
  -- 2. LIST OF REQUIRED PERMISSIONS:
  AND p.name IN (
                 'VIEW_APPLICATION_MAIL_SETTINGS', 'UPDATE_APPLICATION_MAIL_SETTINGS',
                 'VIEW_APPLICATION_SMS_SETTINGS', 'UPDATE_APPLICATION_SMS_SETTINGS'
    )
  -- 3. EXCLUDE PERMISSIONS THAT ALREADY EXIST FOR THE ROLE:
  AND NOT EXISTS (
    SELECT 1
    FROM inscada.role_permissions rp
    WHERE rp.role_id = r.role_id AND rp.permission_id = p.permission_id
);