-- Migration to TABLE_PER_CLASS for ALL communication hierarchies
-- Phase 1: Create new complete tables for ALL 11 protocols
-- Protocols: DNP3, Modbus, S7, IEC104, IEC61850, MQTT, OPC_UA, Ethernet_IP, Fatek, Local, OPC_DA

-- =============================================================================
-- CONNECTION TABLES (Complete tables with all base + specific fields)
-- =============================================================================

-- 1. DNP3 Connection
CREATE TABLE dnp3_connection_new (
    conn_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base connection fields
    project_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    owner_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    protocol VARCHAR(50) NOT NULL,
    ip VARCHAR(50) NOT NULL,
    port INTEGER NOT NULL,
    -- DNP3 specific fields
    adapter VARCHAR(255),
    max_retry_delay INTEGER,
    min_retry_delay INTEGER,
    pool_size INTEGER
);

-- 2. Modbus Connection
CREATE TABLE modbus_connection_new (
    conn_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base connection fields
    project_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    owner_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    protocol VARCHAR(50) NOT NULL,
    ip VARCHAR(50) NOT NULL,
    port INTEGER NOT NULL,
    -- Modbus specific fields
    check_crc BOOLEAN,
    connect_timeout INTEGER,
    max_idle_timeout INTEGER,
    pool_size INTEGER,
    reconnect_on_error BOOLEAN,
    retries INTEGER,
    timeout INTEGER
);

-- 3. S7 Connection
CREATE TABLE s7_connection_new (
    conn_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base connection fields
    project_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    owner_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    protocol VARCHAR(50) NOT NULL,
    ip VARCHAR(50) NOT NULL,
    port INTEGER NOT NULL,
    -- S7 specific fields
    rack INTEGER,
    slot INTEGER,
    timeout INTEGER,
    type VARCHAR(50)
);

-- 4. IEC104 Connection
CREATE TABLE iec104_connection_new (
    conn_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base connection fields
    project_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    owner_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    protocol VARCHAR(50) NOT NULL,
    ip VARCHAR(50) NOT NULL,
    port INTEGER NOT NULL,
    -- IEC104 specific fields
    background_scan_period INTEGER,
    buffering_period INTEGER,
    ca_field_length INTEGER,
    cot_field_length INTEGER,
    ioa_field_length INTEGER,
    is_with_timestamps BOOLEAN,
    k INTEGER,
    originator_address INTEGER,
    spontaneous_duplicates INTEGER,
    t1 INTEGER,
    t2 INTEGER,
    t3 INTEGER,
    use_system_timezone BOOLEAN,
    w INTEGER
);

-- 5. IEC61850 Connection
CREATE TABLE iec61850_connection_new (
    conn_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base connection fields
    project_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    owner_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    protocol VARCHAR(50) NOT NULL,
    ip VARCHAR(50) NOT NULL,
    port INTEGER NOT NULL,
    -- IEC61850 specific fields
    authentication_parameter VARCHAR(255),
    local_ip VARCHAR(50),
    local_port INTEGER,
    message_fragment_timeout INTEGER,
    response_timeout INTEGER,
    scl_file_content TEXT,
    server_model_index INTEGER
);

-- 6. MQTT Connection
CREATE TABLE mqtt_connection_new (
    conn_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base connection fields
    project_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    owner_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    protocol VARCHAR(50) NOT NULL,
    ip VARCHAR(50) NOT NULL,
    port INTEGER NOT NULL,
    -- MQTT specific fields
    clean_session BOOLEAN,
    identifier VARCHAR(255),
    initial_delay INTEGER,
    keep_alive INTEGER,
    max_delay INTEGER,
    password VARCHAR(255),
    pool_size INTEGER,
    use_ssl BOOLEAN,
    username VARCHAR(255)
);

-- 7. OPC_UA Connection
CREATE TABLE opc_ua_connection_new (
    conn_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base connection fields
    project_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    owner_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    protocol VARCHAR(50) NOT NULL,
    ip VARCHAR(50) NOT NULL,
    port INTEGER NOT NULL,
    -- OPC_UA specific fields
    encoding_type VARCHAR(50),
    https_port INTEGER,
    is_anonymous_authentication BOOLEAN,
    is_https_enabled BOOLEAN,
    is_username_password_authentication BOOLEAN,
    password VARCHAR(255),
    security_mode VARCHAR(50),
    security_policy VARCHAR(100),
    server_name VARCHAR(255),
    timeout INTEGER,
    username VARCHAR(255)
);

-- 8. Ethernet_IP Connection
CREATE TABLE ethernet_ip_connection_new (
    conn_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base connection fields
    project_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    owner_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    protocol VARCHAR(50) NOT NULL,
    ip VARCHAR(50) NOT NULL,
    port INTEGER NOT NULL,
    -- Ethernet_IP specific fields
    retries INTEGER,
    timeout INTEGER
);

-- 9. Fatek Connection
CREATE TABLE fatek_connection_new (
    conn_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base connection fields
    project_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    owner_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    protocol VARCHAR(50) NOT NULL,
    ip VARCHAR(50) NOT NULL,
    port INTEGER NOT NULL,
    -- Fatek specific fields
    timeout INTEGER
);

-- 10. Local Connection
CREATE TABLE local_connection_new (
    conn_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base connection fields
    project_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    owner_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    protocol VARCHAR(50) NOT NULL,
    ip VARCHAR(50) NOT NULL,
    port INTEGER NOT NULL
    -- Local has no additional specific fields
);

-- 11. OPC_DA Connection
CREATE TABLE opc_da_connection_new (
    conn_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base connection fields
    project_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    owner_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    protocol VARCHAR(50) NOT NULL,
    ip VARCHAR(50) NOT NULL,
    port INTEGER NOT NULL
    -- OPC_DA has no additional specific fields in connection
);

-- =============================================================================
-- DEVICE TABLES (Complete tables with all base + specific fields)
-- =============================================================================

-- 1. DNP3 Device
CREATE TABLE dnp3_device_new (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    conn_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    -- DNP3 specific fields
    disable_unsolicited_on_startup_flag BOOLEAN,
    event_scan_time INTEGER,
    integrity_on_event_overflow_iin_flag BOOLEAN,
    integrity_scan_time INTEGER,
    local_address INTEGER,
    max_controls_per_request INTEGER,
    remote_address INTEGER,
    response_timeout INTEGER,
    scan_type VARCHAR(50),
    select_timeout INTEGER,
    solicited_confirm_timeout INTEGER,
    startup_integrity_flag BOOLEAN,
    unsolicited_retry_timeout INTEGER,
    unsolicited_events_flag BOOLEAN
);

-- 2. Modbus Device
CREATE TABLE modbus_device_new (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    conn_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    -- Modbus specific fields
    retain_flag BOOLEAN,
    scan_time INTEGER,
    scan_type VARCHAR(50),
    station_address INTEGER
);

-- 3. S7 Device
CREATE TABLE s7_device_new (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    conn_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    -- S7 specific fields
    scan_time INTEGER,
    scan_type VARCHAR(50)
);

-- 4. IEC104 Device
CREATE TABLE iec104_device_new (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    conn_id VARCHAR(36) NOT NULL, 
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    -- IEC104 specific fields
    common_address INTEGER,
    control_point_offset INTEGER,
    scan_time INTEGER,
    scan_type VARCHAR(50)
);

-- 5. IEC61850 Device
CREATE TABLE iec61850_device_new (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    conn_id VARCHAR(36) NOT NULL, 
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    -- IEC61850 specific fields
    object_reference VARCHAR(255),
    scan_time INTEGER,
    scan_type VARCHAR(50)
);

-- 6. MQTT Device
CREATE TABLE mqtt_device_new (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    conn_id VARCHAR(36) NOT NULL, 
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    -- MQTT specific fields
    base_topic VARCHAR(255)
);

-- 7. OPC_UA Device
CREATE TABLE opc_ua_device_new (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    conn_id VARCHAR(36) NOT NULL, 
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    -- OPC_UA specific fields
    base_path VARCHAR(500),
    scan_time INTEGER,
    scan_type VARCHAR(50)
);

-- 8. Ethernet_IP Device
CREATE TABLE ethernet_ip_device_new (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    conn_id VARCHAR(36) NOT NULL, 
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    -- Ethernet_IP specific fields
    scan_time INTEGER,
    scan_type VARCHAR(50),
    slot INTEGER
);

-- 9. Fatek Device
CREATE TABLE fatek_device_new (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    conn_id VARCHAR(36) NOT NULL, 
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    -- Fatek specific fields
    scan_time INTEGER,
    scan_type VARCHAR(50),
    station_address INTEGER
);

-- 10. Local Device
CREATE TABLE local_device_new (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    conn_id VARCHAR(36) NOT NULL, 
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    -- Local specific fields
    scan_time INTEGER,
    scan_type VARCHAR(50)
);

-- 11. OPC_DA Device
CREATE TABLE opc_da_device_new (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    conn_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    -- OPC_DA specific fields
    com_prog_id VARCHAR(255),
    scan_time INTEGER,
    scan_type VARCHAR(50),
    server_status_check_time INTEGER
);

-- =============================================================================
-- FRAME TABLES (Complete tables with all base + specific fields)
-- =============================================================================

-- 1. DNP3 Frame
CREATE TABLE dnp3_frame_new (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- DNP3 specific fields
    dead_band DOUBLE PRECISION,
    event_buffer_size INTEGER,
    event_variation VARCHAR(50),
    point_class VARCHAR(50),
    quantity INTEGER,
    start_address INTEGER,
    static_variation VARCHAR(50),
    type VARCHAR(50)
);

-- 2. Modbus Frame
CREATE TABLE modbus_frame_new (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- Modbus specific fields
    inter_frame_delay INTEGER,
    quantity INTEGER,
    start_address INTEGER,
    type VARCHAR(50)
);

-- 3. S7 Frame
CREATE TABLE s7_frame_new (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- S7 specific fields
    db_number INTEGER,
    quantity INTEGER,
    start_address INTEGER,
    type VARCHAR(50)
);

-- 4. IEC104 Frame
CREATE TABLE iec104_frame_new (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- IEC104 specific fields
    type VARCHAR(50)
);

-- 5. IEC61850 Frame
CREATE TABLE iec61850_frame_new (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- IEC61850 specific fields
    object_reference VARCHAR(255)
);

-- 6. MQTT Frame
CREATE TABLE mqtt_frame_new (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- MQTT specific fields
    publish_expression TEXT,
    publish_expression_id VARCHAR(36),
    publish_expression_type VARCHAR(50),
    qos INTEGER,
    subscribe_expression TEXT,
    subscribe_expression_id VARCHAR(36),
    subscribe_expression_type VARCHAR(50),
    topic VARCHAR(255)
);

-- 7. OPC_UA Frame
CREATE TABLE opc_ua_frame_new (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- OPC_UA specific fields
    path VARCHAR(500)
);

-- 8. Ethernet_IP Frame
CREATE TABLE ethernet_ip_frame_new (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL
    -- Ethernet_IP has no additional specific fields beyond what's in the base frame
);

-- 9. Fatek Frame
CREATE TABLE fatek_frame_new (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- Fatek specific fields
    quantity INTEGER,
    start_address INTEGER,
    type VARCHAR(50)
);

-- 10. Local Frame
CREATE TABLE local_frame_new (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL
    -- Local frame has no specific fields
);

-- 11. OPC_DA Frame
CREATE TABLE opc_da_frame_new (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- OPC_DA specific fields
    percent_deadband DOUBLE PRECISION
);

-- =============================================================================
-- VARIABLE TABLES (Complete tables with all base + specific fields)
-- =============================================================================

-- 1. DNP3 Variable
CREATE TABLE dnp3_variable_new (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    project_id VARCHAR(36) NOT NULL,
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- DNP3 specific fields
    dead_band DOUBLE PRECISION,
    event_variation VARCHAR(50),
    point_class VARCHAR(50),
    start_address INTEGER,
    static_variation VARCHAR(50)
);

-- 2. Modbus Variable
CREATE TABLE modbus_variable_new (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields (same extensive list as above)
    project_id VARCHAR(36) NOT NULL,
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- Modbus specific fields
    bit_offset INTEGER,
    byte_swap_flag BOOLEAN,
    length INTEGER,
    start_address INTEGER,
    type VARCHAR(50),
    word_swap_flag BOOLEAN
);

-- 3. S7 Variable
CREATE TABLE s7_variable_new (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    project_id VARCHAR(36) NOT NULL,
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- S7 specific fields
    bit_offset INTEGER,
    max_len INTEGER,
    start_address INTEGER,
    type VARCHAR(50)
);

-- 4. IEC104 Variable
CREATE TABLE iec104_variable_new (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    project_id VARCHAR(36) NOT NULL,
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- IEC104 specific fields
    read_address INTEGER,
    read_ioa_address_1 INTEGER,
    read_ioa_address_2 INTEGER,
    read_ioa_address_3 INTEGER,
    use_ioa_addresses BOOLEAN,
    write_address INTEGER,
    write_ioa_address_1 INTEGER,
    write_ioa_address_2 INTEGER,
    write_ioa_address_3 INTEGER
);

-- 5. IEC61850 Variable
CREATE TABLE iec61850_variable_new (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    project_id VARCHAR(36) NOT NULL,
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- IEC61850 specific fields
    fc VARCHAR(50),
    object_reference VARCHAR(255),
    type VARCHAR(50)
);

-- 6. MQTT Variable
CREATE TABLE mqtt_variable_new (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    project_id VARCHAR(36) NOT NULL,
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- MQTT specific fields
    type VARCHAR(50)
);

-- 7. OPC_UA Variable
CREATE TABLE opc_ua_variable_new (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    project_id VARCHAR(36) NOT NULL,
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- OPC_UA specific fields
    first_dimension_index INTEGER,
    identifier VARCHAR(255),
    identifier_type VARCHAR(50),
    is_array BOOLEAN,
    namespace_index INTEGER,
    second_dimension_index INTEGER,
    type VARCHAR(50)
);

-- 8. Ethernet_IP Variable
CREATE TABLE ethernet_ip_variable_new (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    project_id VARCHAR(36) NOT NULL,
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- Ethernet_IP specific fields
    bit_parent_type VARCHAR(50),
    type VARCHAR(50)
);

-- 9. Fatek Variable
CREATE TABLE fatek_variable_new (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    project_id VARCHAR(36) NOT NULL,
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- Fatek specific fields
    start_address INTEGER,
    type VARCHAR(50)
);

-- 10. Local Variable
CREATE TABLE local_variable_new (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    project_id VARCHAR(36) NOT NULL,
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- Local specific fields
    type VARCHAR(50)
);

-- 11. OPC_DA Variable
CREATE TABLE opc_da_variable_new (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    project_id VARCHAR(36) NOT NULL,
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- OPC_DA specific fields
    type VARCHAR(50)
);



-- =============================================================================
-- ADD FOREIGN KEY CONSTRAINTS FOR ALL NEW TABLES
-- =============================================================================

-- Connection foreign keys
ALTER TABLE dnp3_connection_new ADD CONSTRAINT fk_dnp3_connection_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE dnp3_connection_new ADD CONSTRAINT fk_dnp3_connection_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE dnp3_connection_new ADD CONSTRAINT fk_dnp3_connection_owner FOREIGN KEY (owner_id) REFERENCES users(user_id);

ALTER TABLE modbus_connection_new ADD CONSTRAINT fk_modbus_connection_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE modbus_connection_new ADD CONSTRAINT fk_modbus_connection_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE modbus_connection_new ADD CONSTRAINT fk_modbus_connection_owner FOREIGN KEY (owner_id) REFERENCES users(user_id);

ALTER TABLE s7_connection_new ADD CONSTRAINT fk_s7_connection_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE s7_connection_new ADD CONSTRAINT fk_s7_connection_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE s7_connection_new ADD CONSTRAINT fk_s7_connection_owner FOREIGN KEY (owner_id) REFERENCES users(user_id);

ALTER TABLE iec104_connection_new ADD CONSTRAINT fk_iec104_connection_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE iec104_connection_new ADD CONSTRAINT fk_iec104_connection_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE iec104_connection_new ADD CONSTRAINT fk_iec104_connection_owner FOREIGN KEY (owner_id) REFERENCES users(user_id);

ALTER TABLE iec61850_connection_new ADD CONSTRAINT fk_iec61850_connection_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE iec61850_connection_new ADD CONSTRAINT fk_iec61850_connection_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE iec61850_connection_new ADD CONSTRAINT fk_iec61850_connection_owner FOREIGN KEY (owner_id) REFERENCES users(user_id);

ALTER TABLE mqtt_connection_new ADD CONSTRAINT fk_mqtt_connection_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE mqtt_connection_new ADD CONSTRAINT fk_mqtt_connection_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE mqtt_connection_new ADD CONSTRAINT fk_mqtt_connection_owner FOREIGN KEY (owner_id) REFERENCES users(user_id);

ALTER TABLE opc_ua_connection_new ADD CONSTRAINT fk_opc_ua_connection_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE opc_ua_connection_new ADD CONSTRAINT fk_opc_ua_connection_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE opc_ua_connection_new ADD CONSTRAINT fk_opc_ua_connection_owner FOREIGN KEY (owner_id) REFERENCES users(user_id);

ALTER TABLE ethernet_ip_connection_new ADD CONSTRAINT fk_ethernet_ip_connection_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE ethernet_ip_connection_new ADD CONSTRAINT fk_ethernet_ip_connection_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE ethernet_ip_connection_new ADD CONSTRAINT fk_ethernet_ip_connection_owner FOREIGN KEY (owner_id) REFERENCES users(user_id);

ALTER TABLE fatek_connection_new ADD CONSTRAINT fk_fatek_connection_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE fatek_connection_new ADD CONSTRAINT fk_fatek_connection_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE fatek_connection_new ADD CONSTRAINT fk_fatek_connection_owner FOREIGN KEY (owner_id) REFERENCES users(user_id);

ALTER TABLE local_connection_new ADD CONSTRAINT fk_local_connection_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE local_connection_new ADD CONSTRAINT fk_local_connection_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE local_connection_new ADD CONSTRAINT fk_local_connection_owner FOREIGN KEY (owner_id) REFERENCES users(user_id);

ALTER TABLE opc_da_connection_new ADD CONSTRAINT fk_opc_da_connection_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE opc_da_connection_new ADD CONSTRAINT fk_opc_da_connection_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE opc_da_connection_new ADD CONSTRAINT fk_opc_da_connection_owner FOREIGN KEY (owner_id) REFERENCES users(user_id);

-- Device foreign keys
ALTER TABLE dnp3_device_new ADD CONSTRAINT fk_dnp3_device_connection FOREIGN KEY (conn_id) REFERENCES dnp3_connection_new(conn_id);
ALTER TABLE dnp3_device_new ADD CONSTRAINT fk_dnp3_device_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE modbus_device_new ADD CONSTRAINT fk_modbus_device_connection FOREIGN KEY (conn_id) REFERENCES modbus_connection_new(conn_id);
ALTER TABLE modbus_device_new ADD CONSTRAINT fk_modbus_device_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE s7_device_new ADD CONSTRAINT fk_s7_device_connection FOREIGN KEY (conn_id) REFERENCES s7_connection_new(conn_id);
ALTER TABLE s7_device_new ADD CONSTRAINT fk_s7_device_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE iec104_device_new ADD CONSTRAINT fk_iec104_device_connection FOREIGN KEY (conn_id) REFERENCES iec104_connection_new(conn_id);
ALTER TABLE iec104_device_new ADD CONSTRAINT fk_iec104_device_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE iec61850_device_new ADD CONSTRAINT fk_iec61850_device_connection FOREIGN KEY (conn_id) REFERENCES iec61850_connection_new(conn_id);
ALTER TABLE iec61850_device_new ADD CONSTRAINT fk_iec61850_device_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE mqtt_device_new ADD CONSTRAINT fk_mqtt_device_connection FOREIGN KEY (conn_id) REFERENCES mqtt_connection_new(conn_id);
ALTER TABLE mqtt_device_new ADD CONSTRAINT fk_mqtt_device_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE opc_ua_device_new ADD CONSTRAINT fk_opc_ua_device_connection FOREIGN KEY (conn_id) REFERENCES opc_ua_connection_new(conn_id);
ALTER TABLE opc_ua_device_new ADD CONSTRAINT fk_opc_ua_device_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE ethernet_ip_device_new ADD CONSTRAINT fk_ethernet_ip_device_connection FOREIGN KEY (conn_id) REFERENCES ethernet_ip_connection_new(conn_id);
ALTER TABLE ethernet_ip_device_new ADD CONSTRAINT fk_ethernet_ip_device_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE fatek_device_new ADD CONSTRAINT fk_fatek_device_connection FOREIGN KEY (conn_id) REFERENCES fatek_connection_new(conn_id);
ALTER TABLE fatek_device_new ADD CONSTRAINT fk_fatek_device_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE local_device_new ADD CONSTRAINT fk_local_device_connection FOREIGN KEY (conn_id) REFERENCES local_connection_new(conn_id);
ALTER TABLE local_device_new ADD CONSTRAINT fk_local_device_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE opc_da_device_new ADD CONSTRAINT fk_opc_da_device_connection FOREIGN KEY (conn_id) REFERENCES opc_da_connection_new(conn_id);
ALTER TABLE opc_da_device_new ADD CONSTRAINT fk_opc_da_device_space FOREIGN KEY (space_id) REFERENCES space(space_id);

-- Frame foreign keys
ALTER TABLE dnp3_frame_new ADD CONSTRAINT fk_dnp3_frame_device FOREIGN KEY (device_id) REFERENCES dnp3_device_new(device_id);
ALTER TABLE dnp3_frame_new ADD CONSTRAINT fk_dnp3_frame_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE modbus_frame_new ADD CONSTRAINT fk_modbus_frame_device FOREIGN KEY (device_id) REFERENCES modbus_device_new(device_id);
ALTER TABLE modbus_frame_new ADD CONSTRAINT fk_modbus_frame_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE s7_frame_new ADD CONSTRAINT fk_s7_frame_device FOREIGN KEY (device_id) REFERENCES s7_device_new(device_id);
ALTER TABLE s7_frame_new ADD CONSTRAINT fk_s7_frame_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE iec104_frame_new ADD CONSTRAINT fk_iec104_frame_device FOREIGN KEY (device_id) REFERENCES iec104_device_new(device_id);
ALTER TABLE iec104_frame_new ADD CONSTRAINT fk_iec104_frame_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE iec61850_frame_new ADD CONSTRAINT fk_iec61850_frame_device FOREIGN KEY (device_id) REFERENCES iec61850_device_new(device_id);
ALTER TABLE iec61850_frame_new ADD CONSTRAINT fk_iec61850_frame_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE mqtt_frame_new ADD CONSTRAINT fk_mqtt_frame_device FOREIGN KEY (device_id) REFERENCES mqtt_device_new(device_id);
ALTER TABLE mqtt_frame_new ADD CONSTRAINT fk_mqtt_frame_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE opc_ua_frame_new ADD CONSTRAINT fk_opc_ua_frame_device FOREIGN KEY (device_id) REFERENCES opc_ua_device_new(device_id);
ALTER TABLE opc_ua_frame_new ADD CONSTRAINT fk_opc_ua_frame_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE ethernet_ip_frame_new ADD CONSTRAINT fk_ethernet_ip_frame_device FOREIGN KEY (device_id) REFERENCES ethernet_ip_device_new(device_id);
ALTER TABLE ethernet_ip_frame_new ADD CONSTRAINT fk_ethernet_ip_frame_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE fatek_frame_new ADD CONSTRAINT fk_fatek_frame_device FOREIGN KEY (device_id) REFERENCES fatek_device_new(device_id);
ALTER TABLE fatek_frame_new ADD CONSTRAINT fk_fatek_frame_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE local_frame_new ADD CONSTRAINT fk_local_frame_device FOREIGN KEY (device_id) REFERENCES local_device_new(device_id);
ALTER TABLE local_frame_new ADD CONSTRAINT fk_local_frame_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE opc_da_frame_new ADD CONSTRAINT fk_opc_da_frame_device FOREIGN KEY (device_id) REFERENCES opc_da_device_new(device_id);
ALTER TABLE opc_da_frame_new ADD CONSTRAINT fk_opc_da_frame_space FOREIGN KEY (space_id) REFERENCES space(space_id);

-- Variable foreign keys
ALTER TABLE dnp3_variable_new ADD CONSTRAINT fk_dnp3_variable_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE dnp3_variable_new ADD CONSTRAINT fk_dnp3_variable_frame FOREIGN KEY (frame_id) REFERENCES dnp3_frame_new(frame_id);
ALTER TABLE dnp3_variable_new ADD CONSTRAINT fk_dnp3_variable_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE dnp3_variable_new ADD CONSTRAINT fk_dnp3_variable_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE dnp3_variable_new ADD CONSTRAINT fk_dnp3_variable_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE modbus_variable_new ADD CONSTRAINT fk_modbus_variable_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE modbus_variable_new ADD CONSTRAINT fk_modbus_variable_frame FOREIGN KEY (frame_id) REFERENCES modbus_frame_new(frame_id);
ALTER TABLE modbus_variable_new ADD CONSTRAINT fk_modbus_variable_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE modbus_variable_new ADD CONSTRAINT fk_modbus_variable_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE modbus_variable_new ADD CONSTRAINT fk_modbus_variable_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE s7_variable_new ADD CONSTRAINT fk_s7_variable_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE s7_variable_new ADD CONSTRAINT fk_s7_variable_frame FOREIGN KEY (frame_id) REFERENCES s7_frame_new(frame_id);
ALTER TABLE s7_variable_new ADD CONSTRAINT fk_s7_variable_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE s7_variable_new ADD CONSTRAINT fk_s7_variable_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE s7_variable_new ADD CONSTRAINT fk_s7_variable_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE iec104_variable_new ADD CONSTRAINT fk_iec104_variable_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE iec104_variable_new ADD CONSTRAINT fk_iec104_variable_frame FOREIGN KEY (frame_id) REFERENCES iec104_frame_new(frame_id);
ALTER TABLE iec104_variable_new ADD CONSTRAINT fk_iec104_variable_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE iec104_variable_new ADD CONSTRAINT fk_iec104_variable_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE iec104_variable_new ADD CONSTRAINT fk_iec104_variable_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE iec61850_variable_new ADD CONSTRAINT fk_iec61850_variable_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE iec61850_variable_new ADD CONSTRAINT fk_iec61850_variable_frame FOREIGN KEY (frame_id) REFERENCES iec61850_frame_new(frame_id);
ALTER TABLE iec61850_variable_new ADD CONSTRAINT fk_iec61850_variable_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE iec61850_variable_new ADD CONSTRAINT fk_iec61850_variable_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE iec61850_variable_new ADD CONSTRAINT fk_iec61850_variable_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE mqtt_variable_new ADD CONSTRAINT fk_mqtt_variable_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE mqtt_variable_new ADD CONSTRAINT fk_mqtt_variable_frame FOREIGN KEY (frame_id) REFERENCES mqtt_frame_new(frame_id);
ALTER TABLE mqtt_variable_new ADD CONSTRAINT fk_mqtt_variable_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE mqtt_variable_new ADD CONSTRAINT fk_mqtt_variable_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE mqtt_variable_new ADD CONSTRAINT fk_mqtt_variable_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE opc_ua_variable_new ADD CONSTRAINT fk_opc_ua_variable_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE opc_ua_variable_new ADD CONSTRAINT fk_opc_ua_variable_frame FOREIGN KEY (frame_id) REFERENCES opc_ua_frame_new(frame_id);
ALTER TABLE opc_ua_variable_new ADD CONSTRAINT fk_opc_ua_variable_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE opc_ua_variable_new ADD CONSTRAINT fk_opc_ua_variable_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE opc_ua_variable_new ADD CONSTRAINT fk_opc_ua_variable_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE ethernet_ip_variable_new ADD CONSTRAINT fk_ethernet_ip_variable_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE ethernet_ip_variable_new ADD CONSTRAINT fk_ethernet_ip_variable_frame FOREIGN KEY (frame_id) REFERENCES ethernet_ip_frame_new(frame_id);
ALTER TABLE ethernet_ip_variable_new ADD CONSTRAINT fk_ethernet_ip_variable_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE ethernet_ip_variable_new ADD CONSTRAINT fk_ethernet_ip_variable_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE ethernet_ip_variable_new ADD CONSTRAINT fk_ethernet_ip_variable_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE fatek_variable_new ADD CONSTRAINT fk_fatek_variable_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE fatek_variable_new ADD CONSTRAINT fk_fatek_variable_frame FOREIGN KEY (frame_id) REFERENCES fatek_frame_new(frame_id);
ALTER TABLE fatek_variable_new ADD CONSTRAINT fk_fatek_variable_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE fatek_variable_new ADD CONSTRAINT fk_fatek_variable_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE fatek_variable_new ADD CONSTRAINT fk_fatek_variable_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE local_variable_new ADD CONSTRAINT fk_local_variable_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE local_variable_new ADD CONSTRAINT fk_local_variable_frame FOREIGN KEY (frame_id) REFERENCES local_frame_new(frame_id);
ALTER TABLE local_variable_new ADD CONSTRAINT fk_local_variable_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE local_variable_new ADD CONSTRAINT fk_local_variable_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE local_variable_new ADD CONSTRAINT fk_local_variable_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE opc_da_variable_new ADD CONSTRAINT fk_opc_da_variable_project FOREIGN KEY (project_id) REFERENCES project(project_id);
ALTER TABLE opc_da_variable_new ADD CONSTRAINT fk_opc_da_variable_frame FOREIGN KEY (frame_id) REFERENCES opc_da_frame_new(frame_id);
ALTER TABLE opc_da_variable_new ADD CONSTRAINT fk_opc_da_variable_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE opc_da_variable_new ADD CONSTRAINT fk_opc_da_variable_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE opc_da_variable_new ADD CONSTRAINT fk_opc_da_variable_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);


-- =============================================================================
-- DEVICE TEMPLATE TABLES (Complete tables with all base + specific fields)
-- =============================================================================

-- 1. DNP3 Device
CREATE TABLE dnp3_device_template (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    properties TEXT,
    -- DNP3 specific fields
    disable_unsolicited_on_startup_flag BOOLEAN,
    event_scan_time INTEGER,
    integrity_on_event_overflow_iin_flag BOOLEAN,
    integrity_scan_time INTEGER,
    local_address INTEGER,
    max_controls_per_request INTEGER,
    remote_address INTEGER,
    response_timeout INTEGER,
    scan_type VARCHAR(50),
    select_timeout INTEGER,
    solicited_confirm_timeout INTEGER,
    startup_integrity_flag BOOLEAN,
    unsolicited_retry_timeout INTEGER,
    unsolicited_events_flag BOOLEAN
);

-- 2. Modbus Device
CREATE TABLE modbus_device_template (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    properties TEXT,
    -- Modbus specific fields
    retain_flag BOOLEAN,
    scan_time INTEGER,
    scan_type VARCHAR(50),
    station_address INTEGER
);

-- 3. S7 Device
CREATE TABLE s7_device_template (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    properties TEXT,
    -- S7 specific fields
    scan_time INTEGER,
    scan_type VARCHAR(50)
);

-- 4. IEC104 Device
CREATE TABLE iec104_device_template (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    properties TEXT,
    -- IEC104 specific fields
    common_address INTEGER,
    control_point_offset INTEGER,
    scan_time INTEGER,
    scan_type VARCHAR(50)
);

-- 5. IEC61850 Device
CREATE TABLE iec61850_device_template (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    properties TEXT,
    -- IEC61850 specific fields
    object_reference VARCHAR(255),
    scan_time INTEGER,
    scan_type VARCHAR(50)
);

-- 6. MQTT Device
CREATE TABLE mqtt_device_template (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    properties TEXT,
    -- MQTT specific fields
    base_topic VARCHAR(255)
);

-- 7. OPC_UA Device
CREATE TABLE opc_ua_device_template (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    properties TEXT,
    -- OPC_UA specific fields
    base_path VARCHAR(500),
    scan_time INTEGER,
    scan_type VARCHAR(50)
);

-- 8. Ethernet_IP Device
CREATE TABLE ethernet_ip_device_template (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    properties TEXT,
    -- Ethernet_IP specific fields
    scan_time INTEGER,
    scan_type VARCHAR(50),
    slot INTEGER
);

-- 9. Fatek Device
CREATE TABLE fatek_device_template (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    properties TEXT,
    -- Fatek specific fields
    scan_time INTEGER,
    scan_type VARCHAR(50),
    station_address INTEGER
);

-- 10. Local Device
CREATE TABLE local_device_template (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    properties TEXT,
    -- Local specific fields
    scan_time INTEGER,
    scan_type VARCHAR(50)
);

-- 11. OPC_DA Device
CREATE TABLE opc_da_device_template (
    device_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base device fields
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    properties TEXT,
    -- OPC_DA specific fields
    com_prog_id VARCHAR(255),
    scan_time INTEGER,
    scan_type VARCHAR(50),
    server_status_check_time INTEGER
);

-- =============================================================================
-- FRAME TEMPLATE TABLES (Complete tables with all base + specific fields)
-- =============================================================================

-- 1. DNP3 Frame
CREATE TABLE dnp3_frame_template (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- DNP3 specific fields
    dead_band DOUBLE PRECISION,
    event_buffer_size INTEGER,
    event_variation VARCHAR(50),
    point_class VARCHAR(50),
    quantity INTEGER,
    start_address INTEGER,
    static_variation VARCHAR(50),
    type VARCHAR(50)
);

-- 2. Modbus Frame
CREATE TABLE modbus_frame_template (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- Modbus specific fields
    inter_frame_delay INTEGER,
    quantity INTEGER,
    start_address INTEGER,
    type VARCHAR(50)
);

-- 3. S7 Frame
CREATE TABLE s7_frame_template (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- S7 specific fields
    db_number INTEGER,
    quantity INTEGER,
    start_address INTEGER,
    type VARCHAR(50)
);

-- 4. IEC104 Frame
CREATE TABLE iec104_frame_template (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- IEC104 specific fields
    type VARCHAR(50)
);

-- 5. IEC61850 Frame
CREATE TABLE iec61850_frame_template (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- IEC61850 specific fields
    object_reference VARCHAR(255)
);

-- 6. MQTT Frame
CREATE TABLE mqtt_frame_template (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- MQTT specific fields
    publish_expression TEXT,
    publish_expression_id VARCHAR(36),
    publish_expression_type VARCHAR(50),
    qos INTEGER,
    subscribe_expression TEXT,
    subscribe_expression_id VARCHAR(36),
    subscribe_expression_type VARCHAR(50),
    topic VARCHAR(255)
);

-- 7. OPC_UA Frame
CREATE TABLE opc_ua_frame_template (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- OPC_UA specific fields
    path VARCHAR(500)
);

-- 8. Ethernet_IP Frame
CREATE TABLE ethernet_ip_frame_template (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL
    -- Ethernet_IP has no additional specific fields beyond what's in the base frame
);

-- 9. Fatek Frame
CREATE TABLE fatek_frame_template (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- Fatek specific fields
    quantity INTEGER,
    start_address INTEGER,
    type VARCHAR(50)
);

-- 10. Local Frame
CREATE TABLE local_frame_template (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL
    -- Local frame has no specific fields
);

-- 11. OPC_DA Frame
CREATE TABLE opc_da_frame_template (
    frame_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base frame fields
    device_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    minutes_offset INTEGER,
    scan_time_factor INTEGER,
    readable_flag BOOLEAN NOT NULL,
    writable_flag BOOLEAN NOT NULL,
    -- OPC_DA specific fields
    percent_deadband DOUBLE PRECISION
);

-- =============================================================================
-- VARIABLE TEMPLATE TABLES (Complete tables with all base + specific fields)
-- =============================================================================

-- 1. DNP3 Variable
CREATE TABLE dnp3_variable_template (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- DNP3 specific fields
    dead_band DOUBLE PRECISION,
    event_variation VARCHAR(50),
    point_class VARCHAR(50),
    start_address INTEGER,
    static_variation VARCHAR(50)
);

-- 2. Modbus Variable
CREATE TABLE modbus_variable_template (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields (same extensive list as above)
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- Modbus specific fields
    bit_offset INTEGER,
    byte_swap_flag BOOLEAN,
    length INTEGER,
    start_address INTEGER,
    type VARCHAR(50),
    word_swap_flag BOOLEAN
);

-- 3. S7 Variable
CREATE TABLE s7_variable_template (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- S7 specific fields
    bit_offset INTEGER,
    max_len INTEGER,
    start_address INTEGER,
    type VARCHAR(50)
);

-- 4. IEC104 Variable
CREATE TABLE iec104_variable_template (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- IEC104 specific fields
    read_address INTEGER,
    read_ioa_address_1 INTEGER,
    read_ioa_address_2 INTEGER,
    read_ioa_address_3 INTEGER,
    use_ioa_addresses BOOLEAN,
    write_address INTEGER,
    write_ioa_address_1 INTEGER,
    write_ioa_address_2 INTEGER,
    write_ioa_address_3 INTEGER
);

-- 5. IEC61850 Variable
CREATE TABLE iec61850_variable_template (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- IEC61850 specific fields
    fc VARCHAR(50),
    object_reference VARCHAR(255),
    type VARCHAR(50)
);

-- 6. MQTT Variable
CREATE TABLE mqtt_variable_template (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- MQTT specific fields
    type VARCHAR(50)
);

-- 7. OPC_UA Variable
CREATE TABLE opc_ua_variable_template (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- OPC_UA specific fields
    first_dimension_index INTEGER,
    identifier VARCHAR(255),
    identifier_type VARCHAR(50),
    is_array BOOLEAN,
    namespace_index INTEGER,
    second_dimension_index INTEGER,
    type VARCHAR(50)
);

-- 8. Ethernet_IP Variable
CREATE TABLE ethernet_ip_variable_template (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- Ethernet_IP specific fields
    bit_parent_type VARCHAR(50),
    type VARCHAR(50)
);

-- 9. Fatek Variable
CREATE TABLE fatek_variable_template (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- Fatek specific fields
    start_address INTEGER,
    type VARCHAR(50)
);

-- 10. Local Variable
CREATE TABLE local_variable_template (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- Local specific fields
    type VARCHAR(50)
);

-- 11. OPC_DA Variable
CREATE TABLE opc_da_variable_template (
    variable_id VARCHAR(36) NOT NULL PRIMARY KEY,
    -- Base variable fields
    frame_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(100) NOT NULL,
    insert_dttm TIMESTAMP NOT NULL,
    version_user VARCHAR(100),
    version_dttm TIMESTAMP,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    code VARCHAR(20),
    value_expression_type VARCHAR(50),
    value_expression_id VARCHAR(36),
    value_expression VARCHAR(4000),
    raw_zero_scale DOUBLE PRECISION,
    raw_full_scale DOUBLE PRECISION,
    eng_zero_scale DOUBLE PRECISION,
    eng_full_scale DOUBLE PRECISION,
    fractional_digit_count SMALLINT,
    unit VARCHAR(255),
    log_type VARCHAR(50),
    log_expression_id VARCHAR(36),
    log_expression VARCHAR(4000),
    log_period INTEGER,
    log_threshold DOUBLE PRECISION,
    log_min_value DOUBLE PRECISION,
    log_max_value DOUBLE PRECISION,
    set_min_value DOUBLE PRECISION,
    set_max_value DOUBLE PRECISION,
    active_flag BOOLEAN NOT NULL,
    pulse_on_flag BOOLEAN NOT NULL,
    pulse_on_duration INTEGER,
    pulse_off_flag BOOLEAN NOT NULL,
    pulse_off_duration INTEGER,
    keep_last_values BOOLEAN NOT NULL,
    -- OPC_DA specific fields
    type VARCHAR(50)
);

-- =============================================================================
-- ADD FOREIGN KEY CONSTRAINTS FOR ALL NEW TEMPLATE TABLES
-- =============================================================================

-- Device foreign keys
ALTER TABLE dnp3_device_template ADD CONSTRAINT fk_dnp3_device_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE modbus_device_template ADD CONSTRAINT fk_modbus_device_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE s7_device_template ADD CONSTRAINT fk_s7_device_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE iec104_device_template ADD CONSTRAINT fk_iec104_device_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE iec61850_device_template ADD CONSTRAINT fk_iec61850_device_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE mqtt_device_template ADD CONSTRAINT fk_mqtt_device_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE opc_ua_device_template ADD CONSTRAINT fk_opc_ua_device_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE ethernet_ip_device_template ADD CONSTRAINT fk_ethernet_ip_device_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE fatek_device_template ADD CONSTRAINT fk_fatek_device_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE local_device_template ADD CONSTRAINT fk_local_device_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE opc_da_device_template ADD CONSTRAINT fk_opc_da_device_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

-- Frame foreign keys
ALTER TABLE dnp3_frame_template ADD CONSTRAINT fk_dnp3_frame_template_device FOREIGN KEY (device_id) REFERENCES dnp3_device_template(device_id);
ALTER TABLE dnp3_frame_template ADD CONSTRAINT fk_dnp3_frame_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE modbus_frame_template ADD CONSTRAINT fk_modbus_frame_template_device FOREIGN KEY (device_id) REFERENCES modbus_device_template(device_id);
ALTER TABLE modbus_frame_template ADD CONSTRAINT fk_modbus_frame_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE s7_frame_template ADD CONSTRAINT fk_s7_frame_template_device FOREIGN KEY (device_id) REFERENCES s7_device_template(device_id);
ALTER TABLE s7_frame_template ADD CONSTRAINT fk_s7_frame_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE iec104_frame_template ADD CONSTRAINT fk_iec104_frame_template_device FOREIGN KEY (device_id) REFERENCES iec104_device_template(device_id);
ALTER TABLE iec104_frame_template ADD CONSTRAINT fk_iec104_frame_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE iec61850_frame_template ADD CONSTRAINT fk_iec61850_frame_template_device FOREIGN KEY (device_id) REFERENCES iec61850_device_template(device_id);
ALTER TABLE iec61850_frame_template ADD CONSTRAINT fk_iec61850_frame_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE mqtt_frame_template ADD CONSTRAINT fk_mqtt_frame_template_device FOREIGN KEY (device_id) REFERENCES mqtt_device_template(device_id);
ALTER TABLE mqtt_frame_template ADD CONSTRAINT fk_mqtt_frame_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE opc_ua_frame_template ADD CONSTRAINT fk_opc_ua_frame_template_device FOREIGN KEY (device_id) REFERENCES opc_ua_device_template(device_id);
ALTER TABLE opc_ua_frame_template ADD CONSTRAINT fk_opc_ua_frame_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE ethernet_ip_frame_template ADD CONSTRAINT fk_ethernet_ip_frame_template_device FOREIGN KEY (device_id) REFERENCES ethernet_ip_device_template(device_id);
ALTER TABLE ethernet_ip_frame_template ADD CONSTRAINT fk_ethernet_ip_frame_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE fatek_frame_template ADD CONSTRAINT fk_fatek_frame_template_device FOREIGN KEY (device_id) REFERENCES fatek_device_template(device_id);
ALTER TABLE fatek_frame_template ADD CONSTRAINT fk_fatek_frame_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE local_frame_template ADD CONSTRAINT fk_local_frame_template_device FOREIGN KEY (device_id) REFERENCES local_device_template(device_id);
ALTER TABLE local_frame_template ADD CONSTRAINT fk_local_frame_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

ALTER TABLE opc_da_frame_template ADD CONSTRAINT fk_opc_da_frame_template_device FOREIGN KEY (device_id) REFERENCES opc_da_device_template(device_id);
ALTER TABLE opc_da_frame_template ADD CONSTRAINT fk_opc_da_frame_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);

-- Variable foreign keys
ALTER TABLE dnp3_variable_template ADD CONSTRAINT fk_dnp3_variable_template_frame FOREIGN KEY (frame_id) REFERENCES dnp3_frame_template(frame_id);
ALTER TABLE dnp3_variable_template ADD CONSTRAINT fk_dnp3_variable_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE dnp3_variable_template ADD CONSTRAINT fk_dnp3_variable_template_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE dnp3_variable_template ADD CONSTRAINT fk_dnp3_variable_template_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE modbus_variable_template ADD CONSTRAINT fk_modbus_variable_template_frame FOREIGN KEY (frame_id) REFERENCES modbus_frame_template(frame_id);
ALTER TABLE modbus_variable_template ADD CONSTRAINT fk_modbus_variable_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE modbus_variable_template ADD CONSTRAINT fk_modbus_variable_template_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE modbus_variable_template ADD CONSTRAINT fk_modbus_variable_template_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE s7_variable_template ADD CONSTRAINT fk_s7_variable_template_frame FOREIGN KEY (frame_id) REFERENCES s7_frame_template(frame_id);
ALTER TABLE s7_variable_template ADD CONSTRAINT fk_s7_variable_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE s7_variable_template ADD CONSTRAINT fk_s7_variable_template_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE s7_variable_template ADD CONSTRAINT fk_s7_variable_template_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE iec104_variable_template ADD CONSTRAINT fk_iec104_variable_template_frame FOREIGN KEY (frame_id) REFERENCES iec104_frame_template(frame_id);
ALTER TABLE iec104_variable_template ADD CONSTRAINT fk_iec104_variable_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE iec104_variable_template ADD CONSTRAINT fk_iec104_variable_template_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE iec104_variable_template ADD CONSTRAINT fk_iec104_variable_template_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE iec61850_variable_template ADD CONSTRAINT fk_iec61850_variable_template_frame FOREIGN KEY (frame_id) REFERENCES iec61850_frame_template(frame_id);
ALTER TABLE iec61850_variable_template ADD CONSTRAINT fk_iec61850_variable_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE iec61850_variable_template ADD CONSTRAINT fk_iec61850_variable_template_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE iec61850_variable_template ADD CONSTRAINT fk_iec61850_variable_template_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE mqtt_variable_template ADD CONSTRAINT fk_mqtt_variable_template_frame FOREIGN KEY (frame_id) REFERENCES mqtt_frame_template(frame_id);
ALTER TABLE mqtt_variable_template ADD CONSTRAINT fk_mqtt_variable_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE mqtt_variable_template ADD CONSTRAINT fk_mqtt_variable_template_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE mqtt_variable_template ADD CONSTRAINT fk_mqtt_variable_template_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE opc_ua_variable_template ADD CONSTRAINT fk_opc_ua_variable_template_frame FOREIGN KEY (frame_id) REFERENCES opc_ua_frame_template(frame_id);
ALTER TABLE opc_ua_variable_template ADD CONSTRAINT fk_opc_ua_variable_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE opc_ua_variable_template ADD CONSTRAINT fk_opc_ua_variable_template_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE opc_ua_variable_template ADD CONSTRAINT fk_opc_ua_variable_template_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE ethernet_ip_variable_template ADD CONSTRAINT fk_ethernet_ip_variable_template_frame FOREIGN KEY (frame_id) REFERENCES ethernet_ip_frame_template(frame_id);
ALTER TABLE ethernet_ip_variable_template ADD CONSTRAINT fk_ethernet_ip_variable_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE ethernet_ip_variable_template ADD CONSTRAINT fk_ethernet_ip_variable_template_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE ethernet_ip_variable_template ADD CONSTRAINT fk_ethernet_ip_variable_template_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE fatek_variable_template ADD CONSTRAINT fk_fatek_variable_template_frame FOREIGN KEY (frame_id) REFERENCES fatek_frame_template(frame_id);
ALTER TABLE fatek_variable_template ADD CONSTRAINT fk_fatek_variable_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE fatek_variable_template ADD CONSTRAINT fk_fatek_variable_template_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE fatek_variable_template ADD CONSTRAINT fk_fatek_variable_template_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE local_variable_template ADD CONSTRAINT fk_local_variable_template_frame FOREIGN KEY (frame_id) REFERENCES local_frame_template(frame_id);
ALTER TABLE local_variable_template ADD CONSTRAINT fk_local_variable_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE local_variable_template ADD CONSTRAINT fk_local_variable_template_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE local_variable_template ADD CONSTRAINT fk_local_variable_template_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);

ALTER TABLE opc_da_variable_template ADD CONSTRAINT fk_opc_da_variable_template_frame FOREIGN KEY (frame_id) REFERENCES opc_da_frame_template(frame_id);
ALTER TABLE opc_da_variable_template ADD CONSTRAINT fk_opc_da_variable_template_space FOREIGN KEY (space_id) REFERENCES space(space_id);
ALTER TABLE opc_da_variable_template ADD CONSTRAINT fk_opc_da_variable_template_value_expression FOREIGN KEY (value_expression_id) REFERENCES expression(expression_id);
ALTER TABLE opc_da_variable_template ADD CONSTRAINT fk_opc_da_variable_template_log_expression FOREIGN KEY (log_expression_id) REFERENCES expression(expression_id);