create table login_settings
(
    login_settings_id serial not null constraint login_settings_login_settings_id_pk primary key,
    alignment     varchar(50),
    image         bytea,

    insert_user     varchar(50),
    insert_dttm     timestamp with time zone,
    version_user    varchar(50),
    version_dttm    timestamp with time zone
);

insert into inscada.login_settings(alignment, insert_user, insert_dttm)
values ('Center', 'inscada', now());

insert into inscada.permissions(permission_id, name)
values (245, 'UPDATE_LOGIN_SETTINGS');

insert into inscada.menus (menu_id, name)
values (90, 'Login Settings'), (91, 'Login Background');

----------below, inserts login_settings permissions and menu into all roles ------------------
do
$$
declare
    r record;
begin
    for r in select role_id from roles
    loop
    insert into inscada.role_permissions (role_id, permission_id)
    values (r.role_id, 245) on conflict do nothing;

    insert into inscada.role_menus (role_id, menu_id)
    values (r.role_id, 90), (r.role_id, 91) on conflict do nothing;
    end loop;
end;
$$;
---------------------------end of loop-----------------------------
