-- Create table for application-wide mail settings (non-space-aware)
CREATE TABLE IF NOT EXISTS application_mail_settings (
    application_mail_settings_id text not null
            constraint app_mail_settings_app_mail_settings_id_pk
            primary key,
    smtp_host varchar(50) not null,
    smtp_port integer not null,
    username  varchar(50) not null,
    password  varchar(60) not null,
    protocol  varchar(10) not null,
    from_address varchar(255) not null,
    insert_user  varchar(50) not null,
    insert_dttm  timestamp with time zone not null,
    version  bigint not null default 0    ,
    version_dttm timestamp with time zone,
    version_user varchar(50),
    deleted_user varchar(50),
    deleted_dttm timestamp with time zone
);

-- Create table for application-wide sms settings (non-space-aware)
CREATE TABLE IF NOT EXISTS application_sms_settings (
    application_sms_settings_id text not null
            constraint app_sms_settings_app_sms_settings_id_pk
            primary key,
    provider varchar(50) not null,
    dp_username character varying(255),
    dp_password character varying(255),
    dp_short_number character varying(255),
    dp_account_number character varying(255),
    dp_originator character varying(255),
    dp_operator character varying(255),
    tw_account_sid character varying(255),
    tw_auth_token character varying(255),
    tw_twilio_number character varying(255),
    nt_username character varying(255),
    nt_password character varying(255),
    nt_header character varying(255),
    nt_bayi_code character varying(255),
    default_flag boolean,
    insert_user varchar(50) not null,
    insert_dttm timestamp with time zone not null,
    version bigint not null default 0,
    version_dttm timestamp with time zone,
    version_user varchar(50),
    deleted_user varchar(50),
    deleted_dttm timestamp with time zone
);
