-- Step 1: Update any existing users that have a NULL password.
-- We set it to a known, secure, but unusable placeholder value.
-- The application logic (requirePasswordReset=true) already prevents these users
-- from logging in, so this is a safe data integrity fix.
UPDATE
    inscada."users"
SET
    passwd = 'unusable-password-placeholder-for-migration'
WHERE
    passwd IS NULL;

-- Step 2: Apply the NOT NULL constraint to the password column.
-- This will only succeed if Step 1 has successfully updated all NULL values.
ALTER TABLE inscada."users"
ALTER COLUMN passwd SET NOT NULL;