-- =============================================================================
-- CONNECTION DATA MIGRATION - ALL 11 PROTOCOLS
-- =============================================================================

-- 1. Migrate DNP3 connections
INSERT INTO dnp3_connection_new (
    conn_id, project_id, space_id, owner_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, protocol, ip, port,
    adapter, max_retry_delay, min_retry_delay, pool_size
)
SELECT
    c.conn_id, c.project_id, c.space_id, c.owner_id, c.insert_user, c.insert_dttm,
    c.version_user, c.version_dttm, c.name, c.dsc, c.protocol, c.ip, c.port,
    dnp3.adapter, dnp3.max_retry_delay, dnp3.min_retry_delay, dnp3.pool_size
FROM connection c
INNER JOIN dnp3_connection dnp3 ON c.conn_id = dnp3.conn_id;

-- 2. Migrate Modbus connections
INSERT INTO modbus_connection_new (
    conn_id, project_id, space_id, owner_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, protocol, ip, port,
    check_crc, connect_timeout, max_idle_timeout, pool_size, reconnect_on_error, retries, timeout
)
SELECT
    c.conn_id, c.project_id, c.space_id, c.owner_id, c.insert_user, c.insert_dttm,
    c.version_user, c.version_dttm, c.name, c.dsc, c.protocol, c.ip, c.port,
    mb.check_crc, mb.connect_timeout, mb.max_idle_timeout, mb.pool_size, mb.reconnect_on_error, mb.retries, mb.timeout
FROM connection c
INNER JOIN modbus_connection mb ON c.conn_id = mb.conn_id;

-- 3. Migrate S7 connections
INSERT INTO s7_connection_new (
    conn_id, project_id, space_id, owner_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, protocol, ip, port,
    rack, slot, timeout, type
)
SELECT
    c.conn_id, c.project_id, c.space_id, c.owner_id, c.insert_user, c.insert_dttm,
    c.version_user, c.version_dttm, c.name, c.dsc, c.protocol, c.ip, c.port,
    s7.rack, s7.slot, s7.timeout, s7.type
FROM connection c
INNER JOIN s7_connection s7 ON c.conn_id = s7.conn_id;

-- 4. Migrate IEC104 connections
INSERT INTO iec104_connection_new (
    conn_id, project_id, space_id, owner_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, protocol, ip, port,
    background_scan_period, buffering_period, ca_field_length, cot_field_length,
    ioa_field_length, is_with_timestamps, k, originator_address,
    spontaneous_duplicates, t1, t2, t3, use_system_timezone, w
)
SELECT
    c.conn_id, c.project_id, c.space_id, c.owner_id, c.insert_user, c.insert_dttm,
    c.version_user, c.version_dttm, c.name, c.dsc, c.protocol, c.ip, c.port,
    iec.background_scan_period, iec.buffering_period, iec.ca_field_length, iec.cot_field_length,
    iec.ioa_field_length, iec.is_with_timestamps, iec.k, iec.originator_address,
    iec.spontaneous_duplicates, iec.t1, iec.t2, iec.t3, iec.use_system_timezone, iec.w
FROM connection c
INNER JOIN iec104_connection iec ON c.conn_id = iec.conn_id;

-- 5. Migrate IEC61850 connections
INSERT INTO iec61850_connection_new (
    conn_id, project_id, space_id, owner_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, protocol, ip, port,
    authentication_parameter, local_ip, local_port, message_fragment_timeout,
    response_timeout, scl_file_content, server_model_index
)
SELECT
    c.conn_id, c.project_id, c.space_id, c.owner_id, c.insert_user, c.insert_dttm,
    c.version_user, c.version_dttm, c.name, c.dsc, c.protocol, c.ip, c.port,
    iec61850.authentication_parameter, iec61850.local_ip, iec61850.local_port, iec61850.message_fragment_timeout,
    iec61850.response_timeout, iec61850.scl_file_content, iec61850.server_model_index
FROM connection c
INNER JOIN iec61850_connection iec61850 ON c.conn_id = iec61850.conn_id;

-- 6. Migrate MQTT connections
INSERT INTO mqtt_connection_new (
    conn_id, project_id, space_id, owner_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, protocol, ip, port,
    clean_session, identifier, initial_delay, keep_alive, max_delay,
    password, pool_size, use_ssl, username
)
SELECT
    c.conn_id, c.project_id, c.space_id, c.owner_id, c.insert_user, c.insert_dttm,
    c.version_user, c.version_dttm, c.name, c.dsc, c.protocol, c.ip, c.port,
    mqtt.clean_session, mqtt.identifier, mqtt.initial_delay, mqtt.keep_alive, mqtt.max_delay,
    mqtt.password, mqtt.pool_size, mqtt.use_ssl, mqtt.username
FROM connection c
INNER JOIN mqtt_connection mqtt ON c.conn_id = mqtt.conn_id;

-- 7. Migrate OPC_UA connections
INSERT INTO opc_ua_connection_new (
    conn_id, project_id, space_id, owner_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, protocol, ip, port,
    encoding_type, https_port, is_anonymous_authentication, is_https_enabled,
    is_username_password_authentication, password, security_mode, security_policy,
    server_name, timeout, username
)
SELECT
    c.conn_id, c.project_id, c.space_id, c.owner_id, c.insert_user, c.insert_dttm,
    c.version_user, c.version_dttm, c.name, c.dsc, c.protocol, c.ip, c.port,
    opc_ua.encoding_type, opc_ua.https_port, opc_ua.is_anonymous_authentication, opc_ua.is_https_enabled,
    opc_ua.is_username_password_authentication, opc_ua.password, opc_ua.security_mode, opc_ua.security_policy,
    opc_ua.server_name, opc_ua.timeout, opc_ua.username
FROM connection c
INNER JOIN opc_ua_connection opc_ua ON c.conn_id = opc_ua.conn_id;

-- 8. Migrate Ethernet_IP connections
INSERT INTO ethernet_ip_connection_new (
    conn_id, project_id, space_id, owner_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, protocol, ip, port,
    retries, timeout
)
SELECT
    c.conn_id, c.project_id, c.space_id, c.owner_id, c.insert_user, c.insert_dttm,
    c.version_user, c.version_dttm, c.name, c.dsc, c.protocol, c.ip, c.port,
    eip.retries, eip.timeout
FROM connection c
INNER JOIN ethernet_ip_connection eip ON c.conn_id = eip.conn_id;

-- 9. Migrate Fatek connections
INSERT INTO fatek_connection_new (
    conn_id, project_id, space_id, owner_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, protocol, ip, port,
    timeout
)
SELECT
    c.conn_id, c.project_id, c.space_id, c.owner_id, c.insert_user, c.insert_dttm,
    c.version_user, c.version_dttm, c.name, c.dsc, c.protocol, c.ip, c.port,
    fatek.timeout
FROM connection c
INNER JOIN fatek_connection fatek ON c.conn_id = fatek.conn_id;

-- 10. Migrate Local connections
INSERT INTO local_connection_new (
    conn_id, project_id, space_id, owner_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, protocol, ip, port
)
SELECT
    c.conn_id, c.project_id, c.space_id, c.owner_id, c.insert_user, c.insert_dttm,
    c.version_user, c.version_dttm, c.name, c.dsc, c.protocol, c.ip, c.port
FROM connection c
INNER JOIN local_connection local ON c.conn_id = local.conn_id;

-- 11. Migrate OPC_DA connections
INSERT INTO opc_da_connection_new (
    conn_id, project_id, space_id, owner_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, protocol, ip, port
)
SELECT
    c.conn_id, c.project_id, c.space_id, c.owner_id, c.insert_user, c.insert_dttm,
    c.version_user, c.version_dttm, c.name, c.dsc, c.protocol, c.ip, c.port
FROM connection c
INNER JOIN opc_da_connection opc_da ON c.conn_id = opc_da.conn_id;

-- =============================================================================
-- DEVICE DATA MIGRATION - ALL 11 PROTOCOLS
-- =============================================================================

-- 1. Migrate DNP3 devices
-- Insert into template table when conn_id is null
INSERT INTO dnp3_device_template (
    device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, properties,
    disable_unsolicited_on_startup_flag, event_scan_time, integrity_on_event_overflow_iin_flag,
    integrity_scan_time, local_address, max_controls_per_request, remote_address, response_timeout,
    scan_type, select_timeout, solicited_confirm_timeout, startup_integrity_flag,
    unsolicited_retry_timeout, unsolicited_events_flag
)
SELECT
    d.device_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc, d.properties,
    dnp3.disable_unsolicited_on_startup_flag, dnp3.event_scan_time, dnp3.integrity_on_event_overflow_iin_flag,
    dnp3.integrity_scan_time, dnp3.local_address, dnp3.max_controls_per_request, dnp3.remote_address, dnp3.response_timeout,
    dnp3.scan_type, dnp3.select_timeout, dnp3.solicited_confirm_timeout, dnp3.startup_integrity_flag,
    dnp3.unsolicited_retry_timeout, dnp3.unsolicited_events_flag
FROM device d
INNER JOIN dnp3_device dnp3 ON d.device_id = dnp3.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when conn_id is not null
INSERT INTO dnp3_device_new (
    device_id, conn_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc,
    disable_unsolicited_on_startup_flag, event_scan_time, integrity_on_event_overflow_iin_flag,
    integrity_scan_time, local_address, max_controls_per_request, remote_address, response_timeout,
    scan_type, select_timeout, solicited_confirm_timeout, startup_integrity_flag,
    unsolicited_retry_timeout, unsolicited_events_flag
)
SELECT
    d.device_id, d.conn_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc,
    dnp3.disable_unsolicited_on_startup_flag, dnp3.event_scan_time, dnp3.integrity_on_event_overflow_iin_flag,
    dnp3.integrity_scan_time, dnp3.local_address, dnp3.max_controls_per_request, dnp3.remote_address, dnp3.response_timeout,
    dnp3.scan_type, dnp3.select_timeout, dnp3.solicited_confirm_timeout, dnp3.startup_integrity_flag,
    dnp3.unsolicited_retry_timeout, dnp3.unsolicited_events_flag
FROM device d
INNER JOIN dnp3_device dnp3 ON d.device_id = dnp3.device_id
WHERE d.conn_id IS NOT NULL;

-- 2. Migrate Modbus devices
-- Insert into template table when conn_id is null
INSERT INTO modbus_device_template (
    device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, properties,
    retain_flag, scan_time, scan_type, station_address
)
SELECT
    d.device_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc, d.properties,
    mb.retain_flag, mb.scan_time, mb.scan_type, mb.station_address
FROM device d
INNER JOIN modbus_device mb ON d.device_id = mb.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when conn_id is not null
INSERT INTO modbus_device_new (
    device_id, conn_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc,
    retain_flag, scan_time, scan_type, station_address
)
SELECT
    d.device_id, d.conn_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc,
    mb.retain_flag, mb.scan_time, mb.scan_type, mb.station_address
FROM device d
INNER JOIN modbus_device mb ON d.device_id = mb.device_id
WHERE d.conn_id IS NOT NULL;

-- 3. Migrate S7 devices
-- Insert into template table when conn_id is null
INSERT INTO s7_device_template (
    device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, properties,
    scan_time, scan_type
)
SELECT
    d.device_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc, d.properties,
    s7.scan_time, s7.scan_type
FROM device d
INNER JOIN s7_device s7 ON d.device_id = s7.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when conn_id is not null
INSERT INTO s7_device_new (
    device_id, conn_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc,
    scan_time, scan_type
)
SELECT
    d.device_id, d.conn_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc,
    s7.scan_time, s7.scan_type
FROM device d
INNER JOIN s7_device s7 ON d.device_id = s7.device_id
WHERE d.conn_id IS NOT NULL;

-- 4. Migrate IEC104 devices
-- Insert into template table when conn_id is null
INSERT INTO iec104_device_template (
    device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, properties,
    common_address, control_point_offset, scan_time, scan_type
)
SELECT
    d.device_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc, d.properties,
    iec.common_address, iec.control_point_offset, iec.scan_time, iec.scan_type
FROM device d
INNER JOIN iec104_device iec ON d.device_id = iec.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when conn_id is not null
INSERT INTO iec104_device_new (
    device_id, conn_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc,
    common_address, control_point_offset, scan_time, scan_type
)
SELECT
    d.device_id, d.conn_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc,
    iec.common_address, iec.control_point_offset, iec.scan_time, iec.scan_type
FROM device d
INNER JOIN iec104_device iec ON d.device_id = iec.device_id
WHERE d.conn_id IS NOT NULL;

-- 5. Migrate IEC61850 devices
-- Insert into template table when conn_id is null
INSERT INTO iec61850_device_template (
    device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, properties,
    object_reference, scan_time, scan_type
)
SELECT
    d.device_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc, d.properties,
    iec61850.object_reference, iec61850.scan_time, iec61850.scan_type
FROM device d
INNER JOIN iec61850_device iec61850 ON d.device_id = iec61850.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when conn_id is not null
INSERT INTO iec61850_device_new (
    device_id, conn_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc,
    object_reference, scan_time, scan_type
)
SELECT
    d.device_id, d.conn_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc,
    iec61850.object_reference, iec61850.scan_time, iec61850.scan_type
FROM device d
INNER JOIN iec61850_device iec61850 ON d.device_id = iec61850.device_id
WHERE d.conn_id IS NOT NULL;

-- 6. Migrate MQTT devices
-- Insert into template table when conn_id is null
INSERT INTO mqtt_device_template (
    device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, properties,
    base_topic
)
SELECT
    d.device_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc, d.properties,
    mqtt.base_topic
FROM device d
INNER JOIN mqtt_device mqtt ON d.device_id = mqtt.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when conn_id is not null
INSERT INTO mqtt_device_new (
    device_id, conn_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc,
    base_topic
)
SELECT
    d.device_id, d.conn_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc,
    mqtt.base_topic
FROM device d
INNER JOIN mqtt_device mqtt ON d.device_id = mqtt.device_id
WHERE d.conn_id IS NOT NULL;

-- 7. Migrate OPC_UA devices
-- Insert into template table when conn_id is null
INSERT INTO opc_ua_device_template (
    device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, properties,
    base_path, scan_time, scan_type
)
SELECT
    d.device_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc, d.properties,
    opc_ua.base_path, opc_ua.scan_time, opc_ua.scan_type
FROM device d
INNER JOIN opc_ua_device opc_ua ON d.device_id = opc_ua.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when conn_id is not null
INSERT INTO opc_ua_device_new (
    device_id, conn_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc,
    base_path, scan_time, scan_type
)
SELECT
    d.device_id, d.conn_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc,
    opc_ua.base_path, opc_ua.scan_time, opc_ua.scan_type
FROM device d
INNER JOIN opc_ua_device opc_ua ON d.device_id = opc_ua.device_id
WHERE d.conn_id IS NOT NULL;

-- 8. Migrate Ethernet_IP devices
-- Insert into template table when conn_id is null
INSERT INTO ethernet_ip_device_template (
    device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, properties,
    scan_time, scan_type, slot
)
SELECT
    d.device_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc, d.properties,
    eip.scan_time, eip.scan_type, eip.slot
FROM device d
INNER JOIN ethernet_ip_device eip ON d.device_id = eip.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when conn_id is not null
INSERT INTO ethernet_ip_device_new (
    device_id, conn_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc,
    scan_time, scan_type, slot
)
SELECT
    d.device_id, d.conn_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc,
    eip.scan_time, eip.scan_type, eip.slot
FROM device d
INNER JOIN ethernet_ip_device eip ON d.device_id = eip.device_id
WHERE d.conn_id IS NOT NULL;

-- 9. Migrate Fatek devices
-- Insert into template table when conn_id is null
INSERT INTO fatek_device_template (
    device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, properties,
    station_address, scan_time, scan_type
)
SELECT
    d.device_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc, d.properties,
    fatek.station_address, fatek.scan_time, fatek.scan_type
FROM device d
INNER JOIN fatek_device fatek ON d.device_id = fatek.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when conn_id is not null
INSERT INTO fatek_device_new (
    device_id, conn_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc,
    scan_time, scan_type, station_address
)
SELECT
    d.device_id, d.conn_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc,
    fatek.scan_time, fatek.scan_type, fatek.station_address
FROM device d
INNER JOIN fatek_device fatek ON d.device_id = fatek.device_id
WHERE d.conn_id IS NOT NULL;

-- 10. Migrate Local devices
-- Insert into template table when conn_id is null
INSERT INTO local_device_template (
    device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, properties,
    scan_time, scan_type
)
SELECT
    d.device_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc, d.properties,
    local.scan_time, local.scan_type
FROM device d
INNER JOIN local_device local ON d.device_id = local.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when conn_id is not null
INSERT INTO local_device_new (
    device_id, conn_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc,
    scan_time, scan_type
)
SELECT
    d.device_id, d.conn_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc,
    local.scan_time, local.scan_type
FROM device d
INNER JOIN local_device local ON d.device_id = local.device_id
WHERE d.conn_id IS NOT NULL;

-- 11. Migrate OPC_DA devices
-- Insert into template table when conn_id is null
INSERT INTO opc_da_device_template (
    device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, properties,
    com_prog_id, scan_time, scan_type, server_status_check_time
)
SELECT
    d.device_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc, d.properties,
    opc_da.com_prog_id, opc_da.scan_time, opc_da.scan_type, opc_da.server_status_check_time
FROM device d
INNER JOIN opc_da_device opc_da ON d.device_id = opc_da.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when conn_id is not null
INSERT INTO opc_da_device_new (
    device_id, conn_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc,
    com_prog_id, scan_time, scan_type, server_status_check_time
)
SELECT
    d.device_id, d.conn_id, d.space_id, d.insert_user, d.insert_dttm,
    d.version_user, d.version_dttm, d.name, d.dsc,
    opc_da.com_prog_id, opc_da.scan_time, opc_da.scan_type, opc_da.server_status_check_time
FROM device d
INNER JOIN opc_da_device opc_da ON d.device_id = opc_da.device_id
WHERE d.conn_id IS NOT NULL;

-- =============================================================================
-- FRAME DATA MIGRATION - ALL 11 PROTOCOLS
-- =============================================================================

-- 1. Migrate DNP3 frames
-- Insert into template table when device is template (conn_id is null)
INSERT INTO dnp3_frame_template (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    dead_band, event_buffer_size, event_variation, point_class,
    quantity, start_address, static_variation, type
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    dnp3.dead_band, dnp3.event_buffer_size, dnp3.event_variation, dnp3.point_class,
    dnp3.quantity, dnp3.start_address, dnp3.static_variation, dnp3.type
FROM frame f
INNER JOIN dnp3_frame dnp3 ON f.frame_id = dnp3.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when device is not template (conn_id is not null)
INSERT INTO dnp3_frame_new (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    dead_band, event_buffer_size, event_variation, point_class,
    quantity, start_address, static_variation, type
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    dnp3.dead_band, dnp3.event_buffer_size, dnp3.event_variation, dnp3.point_class,
    dnp3.quantity, dnp3.start_address, dnp3.static_variation, dnp3.type
FROM frame f
INNER JOIN dnp3_frame dnp3 ON f.frame_id = dnp3.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NOT NULL;

-- 2. Migrate Modbus frames
-- Insert into template table when device is template (conn_id is null)
INSERT INTO modbus_frame_template (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    inter_frame_delay, quantity, start_address, type
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    mb.inter_frame_delay, mb.quantity, mb.start_address, mb.type
FROM frame f
INNER JOIN modbus_frame mb ON f.frame_id = mb.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when device is not template (conn_id is not null)
INSERT INTO modbus_frame_new (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    inter_frame_delay, quantity, start_address, type
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    mb.inter_frame_delay, mb.quantity, mb.start_address, mb.type
FROM frame f
INNER JOIN modbus_frame mb ON f.frame_id = mb.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NOT NULL;

-- 3. Migrate S7 frames
-- Insert into template table when device is template (conn_id is null)
INSERT INTO s7_frame_template (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    db_number, quantity, start_address, type
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    s7.db_number, s7.quantity, s7.start_address, s7.type
FROM frame f
INNER JOIN s7_frame s7 ON f.frame_id = s7.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when device is not template (conn_id is not null)
INSERT INTO s7_frame_new (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    db_number, quantity, start_address, type
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    s7.db_number, s7.quantity, s7.start_address, s7.type
FROM frame f
INNER JOIN s7_frame s7 ON f.frame_id = s7.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NOT NULL;

-- 4. Migrate IEC104 frames
-- Insert into template table when device is template (conn_id is null)
INSERT INTO iec104_frame_template (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    type
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    iec.type
FROM frame f
INNER JOIN iec104_frame iec ON f.frame_id = iec.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when device is not template (conn_id is not null)
INSERT INTO iec104_frame_new (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    type
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    iec.type
FROM frame f
INNER JOIN iec104_frame iec ON f.frame_id = iec.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NOT NULL;

-- 5. Migrate IEC61850 frames
-- Insert into template table when device is template (conn_id is null)
INSERT INTO iec61850_frame_template (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    object_reference
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    iec61850.object_reference
FROM frame f
INNER JOIN iec61850_frame iec61850 ON f.frame_id = iec61850.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when device is not template (conn_id is not null)
INSERT INTO iec61850_frame_new (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    object_reference
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    iec61850.object_reference
FROM frame f
INNER JOIN iec61850_frame iec61850 ON f.frame_id = iec61850.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NOT NULL;

-- 6. Migrate MQTT frames
-- Insert into template table when device is template (conn_id is null)
INSERT INTO mqtt_frame_template (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    publish_expression, publish_expression_id, publish_expression_type, qos,
    subscribe_expression, subscribe_expression_id, subscribe_expression_type, topic
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    mqtt.publish_expression, mqtt.publish_expression_id, mqtt.publish_expression_type, mqtt.qos,
    mqtt.subscribe_expression, mqtt.subscribe_expression_id, mqtt.subscribe_expression_type, mqtt.topic
FROM frame f
INNER JOIN mqtt_frame mqtt ON f.frame_id = mqtt.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when device is not template (conn_id is not null)
INSERT INTO mqtt_frame_new (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    publish_expression, publish_expression_id, publish_expression_type, qos,
    subscribe_expression, subscribe_expression_id, subscribe_expression_type, topic
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    mqtt.publish_expression, mqtt.publish_expression_id, mqtt.publish_expression_type, mqtt.qos,
    mqtt.subscribe_expression, mqtt.subscribe_expression_id, mqtt.subscribe_expression_type, mqtt.topic
FROM frame f
INNER JOIN mqtt_frame mqtt ON f.frame_id = mqtt.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NOT NULL;

-- 7. Migrate OPC_UA frames
-- Insert into template table when device is template (conn_id is null)
INSERT INTO opc_ua_frame_template (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    path
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    opc_ua.path
FROM frame f
INNER JOIN opc_ua_frame opc_ua ON f.frame_id = opc_ua.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when device is not template (conn_id is not null)
INSERT INTO opc_ua_frame_new (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    path
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    opc_ua.path
FROM frame f
INNER JOIN opc_ua_frame opc_ua ON f.frame_id = opc_ua.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NOT NULL;

-- 8. Migrate Ethernet_IP frames
-- Insert into template table when device is template (conn_id is null)
INSERT INTO ethernet_ip_frame_template (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag
FROM frame f
INNER JOIN ethernet_ip_frame eip ON f.frame_id = eip.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when device is not template (conn_id is not null)
INSERT INTO ethernet_ip_frame_new (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag
FROM frame f
INNER JOIN ethernet_ip_frame eip ON f.frame_id = eip.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NOT NULL;

-- 9. Migrate Fatek frames
-- Insert into template table when device is template (conn_id is null)
INSERT INTO fatek_frame_template (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    quantity, start_address, type
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    fatek.quantity, fatek.start_address, fatek.type
FROM frame f
INNER JOIN fatek_frame fatek ON f.frame_id = fatek.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when device is not template (conn_id is not null)
INSERT INTO fatek_frame_new (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    quantity, start_address, type
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    fatek.quantity, fatek.start_address, fatek.type
FROM frame f
INNER JOIN fatek_frame fatek ON f.frame_id = fatek.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NOT NULL;

-- 10. Migrate Local frames
-- Insert into template table when device is template (conn_id is null)
INSERT INTO local_frame_template (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag
FROM frame f
INNER JOIN local_frame local ON f.frame_id = local.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when device is not template (conn_id is not null)
INSERT INTO local_frame_new (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag
FROM frame f
INNER JOIN local_frame local ON f.frame_id = local.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NOT NULL;

-- 11. Migrate OPC_DA frames
-- Insert into template table when device is template (conn_id is null)
INSERT INTO opc_da_frame_template (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    percent_deadband
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    opc_da.percent_deadband
FROM frame f
INNER JOIN opc_da_frame opc_da ON f.frame_id = opc_da.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NULL;

-- Insert into new table when device is not template (conn_id is not null)
INSERT INTO opc_da_frame_new (
    frame_id, device_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, minutes_offset, scan_time_factor,
    readable_flag, writable_flag,
    percent_deadband
)
SELECT
    f.frame_id, f.device_id, f.space_id, f.insert_user, f.insert_dttm,
    f.version_user, f.version_dttm, f.name, f.dsc, f.minutes_offset, f.scan_time_factor,
    f.readable_flag, f.writable_flag,
    opc_da.percent_deadband
FROM frame f
INNER JOIN opc_da_frame opc_da ON f.frame_id = opc_da.frame_id
INNER JOIN device d ON f.device_id = d.device_id
WHERE d.conn_id IS NOT NULL;

-- =============================================================================
-- VARIABLE DATA MIGRATION - ALL 11 PROTOCOLS
-- =============================================================================

-- 1. Migrate DNP3 variables
-- Insert into template table when project_id is null
INSERT INTO dnp3_variable_template (
    variable_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    dead_band, event_variation, point_class, start_address, static_variation
)
SELECT
    v.variable_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    dnp3.dead_band, dnp3.event_variation, dnp3.point_class, dnp3.start_address, dnp3.static_variation
FROM variable v
INNER JOIN dnp3_variable dnp3 ON v.variable_id = dnp3.variable_id
WHERE v.project_id IS NULL;

-- Insert into new table when project_id is not null
INSERT INTO dnp3_variable_new (
    variable_id, project_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    dead_band, event_variation, point_class, start_address, static_variation
)
SELECT
    v.variable_id, v.project_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    dead_band, event_variation, point_class, start_address, static_variation
FROM variable v
INNER JOIN dnp3_variable dnp3 ON v.variable_id = dnp3.variable_id
WHERE v.project_id IS NOT NULL;

-- 2. Migrate Modbus variables
-- Insert into template table when project_id is null
INSERT INTO modbus_variable_template (
    variable_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    bit_offset, byte_swap_flag, length, start_address, type, word_swap_flag
)
SELECT
    v.variable_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    mb.bit_offset, mb.byte_swap_flag, mb.length, mb.start_address, mb.type, mb.word_swap_flag
FROM variable v
INNER JOIN modbus_variable mb ON v.variable_id = mb.variable_id
WHERE v.project_id IS NULL;

-- Insert into new table when project_id is not null
INSERT INTO modbus_variable_new (
    variable_id, project_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    bit_offset, byte_swap_flag, length, start_address, type, word_swap_flag
)
SELECT
    v.variable_id, v.project_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    mb.bit_offset, mb.byte_swap_flag, mb.length, mb.start_address, mb.type, mb.word_swap_flag
FROM variable v
INNER JOIN modbus_variable mb ON v.variable_id = mb.variable_id
WHERE v.project_id IS NOT NULL;

-- 3. Migrate S7 variables
-- Insert into template table when project_id is null
INSERT INTO s7_variable_template (
    variable_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    bit_offset, max_len, start_address, type
)
SELECT
    v.variable_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    s7.bit_offset, s7.max_len, s7.start_address, s7.type
FROM variable v
INNER JOIN s7_variable s7 ON v.variable_id = s7.variable_id
WHERE v.project_id IS NULL;

-- Insert into new table when project_id is not null
INSERT INTO s7_variable_new (
    variable_id, project_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    bit_offset, max_len, start_address, type
)
SELECT
    v.variable_id, v.project_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    bit_offset, max_len, start_address, type
FROM variable v
INNER JOIN s7_variable s7 ON v.variable_id = s7.variable_id
WHERE v.project_id IS NOT NULL;

-- 4. Migrate IEC104 variables
-- Insert into template table when project_id is null
INSERT INTO iec104_variable_template (
    variable_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    read_address, read_ioa_address_1, read_ioa_address_2, read_ioa_address_3,
    use_ioa_addresses, write_address, write_ioa_address_1, write_ioa_address_2, write_ioa_address_3
)
SELECT
    v.variable_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    iec.read_address, iec.read_ioa_address_1, iec.read_ioa_address_2, iec.read_ioa_address_3,
    iec.use_ioa_addresses, iec.write_address, iec.write_ioa_address_1, iec.write_ioa_address_2, iec.write_ioa_address_3
FROM variable v
INNER JOIN iec104_variable iec ON v.variable_id = iec.variable_id
WHERE v.project_id IS NULL;

-- Insert into new table when project_id is not null
INSERT INTO iec104_variable_new (
    variable_id, project_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    read_address, read_ioa_address_1, read_ioa_address_2, read_ioa_address_3,
    use_ioa_addresses, write_address, write_ioa_address_1, write_ioa_address_2, write_ioa_address_3
)
SELECT
    v.variable_id, v.project_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    iec.read_address, iec.read_ioa_address_1, iec.read_ioa_address_2, iec.read_ioa_address_3,
    iec.use_ioa_addresses, iec.write_address, iec.write_ioa_address_1, iec.write_ioa_address_2, iec.write_ioa_address_3
FROM variable v
INNER JOIN iec104_variable iec ON v.variable_id = iec.variable_id
WHERE v.project_id IS NOT NULL;

-- 5. Migrate IEC61850 variables
-- Insert into template table when project_id is null
INSERT INTO iec61850_variable_template (
    variable_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    fc, object_reference, type
)
SELECT
    v.variable_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    iec61850.fc, iec61850.object_reference, iec61850.type
FROM variable v
INNER JOIN iec61850_variable iec61850 ON v.variable_id = iec61850.variable_id
WHERE v.project_id IS NULL;

-- Insert into new table when project_id is not null
INSERT INTO iec61850_variable_new (
    variable_id, project_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    fc, object_reference, type
)
SELECT
    v.variable_id, v.project_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    fc, object_reference, type
FROM variable v
INNER JOIN iec61850_variable iec61850 ON v.variable_id = iec61850.variable_id
WHERE v.project_id IS NOT NULL;

-- 6. Migrate MQTT variables
-- Insert into template table when project_id is null
INSERT INTO mqtt_variable_template (
    variable_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    type
)
SELECT
    v.variable_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    mqtt.type
FROM variable v
INNER JOIN mqtt_variable mqtt ON v.variable_id = mqtt.variable_id
WHERE v.project_id IS NULL;

-- Insert into new table when project_id is not null
INSERT INTO mqtt_variable_new (
    variable_id, project_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    type
)
SELECT
    v.variable_id, v.project_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    type
FROM variable v
INNER JOIN mqtt_variable mqtt ON v.variable_id = mqtt.variable_id
WHERE v.project_id IS NOT NULL;

-- 7. Migrate OPC_UA variables
-- Insert into template table when project_id is null
INSERT INTO opc_ua_variable_template (
    variable_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    first_dimension_index, identifier, identifier_type, is_array,
    namespace_index, second_dimension_index, type
)
SELECT
    v.variable_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    opc_ua.first_dimension_index, opc_ua.identifier, opc_ua.identifier_type, opc_ua.is_array,
    opc_ua.namespace_index, opc_ua.second_dimension_index, opc_ua.type
FROM variable v
INNER JOIN opc_ua_variable opc_ua ON v.variable_id = opc_ua.variable_id
WHERE v.project_id IS NULL;

-- Insert into new table when project_id is not null
INSERT INTO opc_ua_variable_new (
    variable_id, project_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    first_dimension_index, identifier, identifier_type, is_array,
    namespace_index, second_dimension_index, type
)
SELECT
    v.variable_id, v.project_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    first_dimension_index, identifier, identifier_type, is_array,
    namespace_index, second_dimension_index, type
FROM variable v
INNER JOIN opc_ua_variable opc_ua ON v.variable_id = opc_ua.variable_id
WHERE v.project_id IS NOT NULL;

-- 8. Migrate Ethernet_IP variables
-- Insert into template table when project_id is null
INSERT INTO ethernet_ip_variable_template (
    variable_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    bit_parent_type, type
)
SELECT
    v.variable_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    eip.bit_parent_type, eip.type
FROM variable v
INNER JOIN ethernet_ip_variable eip ON v.variable_id = eip.variable_id
WHERE v.project_id IS NULL;

-- Insert into new table when project_id is not null
INSERT INTO ethernet_ip_variable_new (
    variable_id, project_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    bit_parent_type, type
)
SELECT
    v.variable_id, v.project_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    bit_parent_type, type
FROM variable v
INNER JOIN ethernet_ip_variable eip ON v.variable_id = eip.variable_id
WHERE v.project_id IS NOT NULL;

-- 9. Migrate Fatek variables
-- Insert into template table when project_id is null
INSERT INTO fatek_variable_template (
    variable_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    start_address, type
)
SELECT
    v.variable_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    fatek.start_address, fatek.type
FROM variable v
INNER JOIN fatek_variable fatek ON v.variable_id = fatek.variable_id
WHERE v.project_id IS NULL;

-- Insert into new table when project_id is not null
INSERT INTO fatek_variable_new (
    variable_id, project_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    start_address, type
)
SELECT
    v.variable_id, v.project_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    start_address, type
FROM variable v
INNER JOIN fatek_variable fatek ON v.variable_id = fatek.variable_id
WHERE v.project_id IS NOT NULL;

-- 10. Migrate Local variables
-- Insert into template table when project_id is null
INSERT INTO local_variable_template (
    variable_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    type
)
SELECT
    v.variable_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    local.type
FROM variable v
INNER JOIN local_variable local ON v.variable_id = local.variable_id
WHERE v.project_id IS NULL;

-- Insert into new table when project_id is not null
INSERT INTO local_variable_new (
    variable_id, project_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    type
)
SELECT
    v.variable_id, v.project_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    type
FROM variable v
INNER JOIN local_variable local ON v.variable_id = local.variable_id
WHERE v.project_id IS NOT NULL;

-- 11. Migrate OPC_DA variables
-- Insert into template table when project_id is null
INSERT INTO opc_da_variable_template (
    variable_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    type
)
SELECT
    v.variable_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    opc_da.type
FROM variable v
INNER JOIN opc_da_variable opc_da ON v.variable_id = opc_da.variable_id
WHERE v.project_id IS NULL;

-- Insert into new table when project_id is not null
INSERT INTO opc_da_variable_new (
    variable_id, project_id, frame_id, space_id, insert_user, insert_dttm,
    version_user, version_dttm, name, dsc, code, value_expression_type,
    value_expression_id, value_expression, raw_zero_scale, raw_full_scale,
    eng_zero_scale, eng_full_scale, fractional_digit_count, unit,
    log_type, log_expression_id, log_expression, log_period, log_threshold,
    log_min_value, log_max_value, set_min_value, set_max_value,
    active_flag, pulse_on_flag, pulse_on_duration, pulse_off_flag,
    pulse_off_duration, keep_last_values,
    type
)
SELECT
    v.variable_id, v.project_id, v.frame_id, v.space_id, v.insert_user, v.insert_dttm,
    v.version_user, v.version_dttm, v.name, v.dsc, v.code, v.value_expression_type,
    v.value_expression_id, v.value_expression, v.raw_zero_scale, v.raw_full_scale,
    v.eng_zero_scale, v.eng_full_scale, v.fractional_digit_count, v.unit,
    v.log_type, v.log_expression_id, v.log_expression, v.log_period, v.log_threshold,
    v.log_min_value, v.log_max_value, v.set_min_value, v.set_max_value,
    v.active_flag, v.pulse_on_flag, v.pulse_on_duration, v.pulse_off_flag,
    v.pulse_off_duration, v.keep_last_values,
    type
FROM variable v
INNER JOIN opc_da_variable opc_da ON v.variable_id = opc_da.variable_id
WHERE v.project_id IS NOT NULL;
