ALTER TABLE sent_chat_message RENAME COLUMN sent_chat_message_id TO chat_message_id;
ALTER TABLE sent_chat_message RENAME TO chat_message;
ALTER SEQUENCE sent_chat_message_seq RENAME TO chat_message_seq;

UPDATE permissions SET name = 'VIEW_ALL_CHAT_MESSAGES' where name = 'VIEW_SENT_CHAT_MESSAGES';

create table chat_message_recipient
(
    chat_message_recipient_id serial    not null
        constraint chat_message_recipient_chat_message_recipient_id_pk
        primary key,
    chat_message_id   integer      not null
        constraint chat_message_recipient_chat_message_chat_message_id_fk
        references chat_message
        on update cascade on delete cascade,
    user_id   integer      not null
            constraint chat_message_recipient_users_user_id_fk
            references users
            on update cascade,
    is_read  boolean,

    space_id     integer      not null,
    insert_user  varchar(50)  not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index chat_message_recipient_chat_message_id_user_id_uindex
    on chat_message_recipient(chat_message_id, user_id)
;

ALTER SEQUENCE chat_message_recipient_chat_message_recipient_id_seq RENAME TO chat_message_recipient_seq;

ALTER SEQUENCE chat_message_recipient_seq INCREMENT 50;
