-- Step 1: Add a new boolean column to the roles table to mark system-protected roles.
ALTER TABLE inscada.roles ADD COLUMN is_system BOOLEAN NOT NULL DEFAULT FALSE;

-- Step 2: Mark the existing 'administrator' role in the 'default_space' as a system role.
UPDATE inscada.roles
SET is_system = TRUE
WHERE name = 'administrator' AND space_id = (SELECT space_id FROM inscada.space WHERE name = 'default_space');

-- This step adds a consistent 'is_system' flag to the users and space tables
-- to protect critical system entities from modification or deletion.

-- Step 3: Add the column to the users table
ALTER TABLE inscada.users ADD COLUMN is_system BOOLEAN NOT NULL DEFAULT FALSE;

-- Step 4: Mark the 'inscada' superuser as a system entity
UPDATE inscada.users
SET is_system = TRUE
WHERE username = 'inscada';

-- Step 5: Add the column to the space table
ALTER TABLE inscada.space ADD COLUMN is_system BOOLEAN NOT NULL DEFAULT FALSE;

-- Step 6: Mark the 'default_space' as a system entity
UPDATE inscada.space
SET is_system = TRUE
WHERE name = 'default_space';

-- Step 7: This step updates the insert_initial_security_data function to correctly
-- mark the default 'Space Admin' role as a system-protected role.
CREATE OR REPLACE FUNCTION insert_initial_security_data()
RETURNS TRIGGER
LANGUAGE plpgsql
AS $$
DECLARE
    initial_role_id UUID;
BEGIN
    -- Create the initial role for the new space and mark it as a system role.
    INSERT INTO inscada.roles(role_id, name, space_id, is_system, insert_user, insert_dttm)
    VALUES (gen_random_uuid(), 'Space Admin', NEW.space_id, TRUE, 'inscada', now())
    RETURNING role_id INTO initial_role_id;

    -- Assign template permissions (where space_id is NULL) to the new role
    INSERT INTO inscada.role_permissions(role_id, permission_id)
    SELECT initial_role_id, p.permission_id
    FROM inscada.permissions p
    WHERE p.space_id IS NULL;

    -- Assign template menus (where space_id is NULL) to the new role
    INSERT INTO inscada.role_menus(role_id, menu_id)
    SELECT initial_role_id, m.menu_id
    FROM inscada.menus m
    WHERE m.space_id IS NULL;

    RETURN NEW;
END;
$$;