-- This script performs a comprehensive cleanup of incorrectly assigned template permissions and menus.
-- It removes any link where a role belonging to a specific space (r.space_id IS NOT NULL)
-- was incorrectly given a template permission or menu (p.space_id IS NULL or m.space_id IS NULL).
-- This is a one-time data fix for all roles created before the trigger logic in
-- V272__Fix_Initial_Security_Data_Trigger.sql was corrected.

-- 1. Clean up incorrect template permissions from space-specific roles.
DELETE FROM inscada.role_permissions rp
USING
    inscada.roles r,
    inscada.permissions p
WHERE
    rp.role_id = r.role_id AND
    rp.permission_id = p.permission_id AND
    r.space_id IS NOT NULL AND -- The role belongs to a space
    p.space_id IS NULL;       -- The permission is a template

-- 2. Clean up incorrect template menus from space-specific roles.
DELETE FROM inscada.role_menus rm
USING
    inscada.roles r,
    inscada.menus m
WHERE
    rm.role_id = r.role_id AND
    rm.menu_id = m.menu_id AND
    r.space_id IS NOT NULL AND -- The role belongs to a space
    m.space_id IS NULL;       -- The menu is a template