-- Drop the existing unique index that references 'value'
DROP INDEX IF EXISTS custom_menu_space_id_value_uindex;

-- First, add parent_id column to custom_menu table
ALTER TABLE custom_menu
ADD COLUMN parent_id integer,
ADD CONSTRAINT custom_menu_parent_fk
    FOREIGN KEY (parent_id)
    REFERENCES custom_menu(custom_menu_id);

-- Migrate second_custom_menu data to custom_menu
INSERT INTO custom_menu (
    value,
    icon,
    content_type,
    content,
    space_id,
    insert_user,
    insert_dttm,
    version_user,
    version_dttm,
    menu_order,
    parent_id
)
SELECT
    scm.value,
    scm.icon,
    scm.content_type,
    scm.content,
    scm.space_id,
    scm.insert_user,
    scm.insert_dttm,
    scm.version_user,
    scm.version_dttm,
    scm.menu_order,
    scm.custom_menu_id
FROM second_custom_menu scm;

-- Create temporary table to store the mapping of second_custom_menu_id to new custom_menu_id
CREATE TEMPORARY TABLE second_menu_mapping AS
SELECT
    scm.second_custom_menu_id,
    cm.custom_menu_id as new_custom_menu_id
FROM second_custom_menu scm
JOIN custom_menu cm ON cm.parent_id = scm.custom_menu_id
    AND cm.value = scm.value
    AND cm.space_id = scm.space_id;

-- Migrate third_custom_menu data to custom_menu
INSERT INTO custom_menu (
    value,
    icon,
    content_type,
    content,
    space_id,
    insert_user,
    insert_dttm,
    version_user,
    version_dttm,
    menu_order,
    parent_id
)
SELECT
    tcm.value,
    tcm.icon,
    tcm.content_type,
    tcm.content,
    tcm.space_id,
    tcm.insert_user,
    tcm.insert_dttm,
    tcm.version_user,
    tcm.version_dttm,
    tcm.menu_order,
    smm.new_custom_menu_id
FROM third_custom_menu tcm
JOIN second_menu_mapping smm ON smm.second_custom_menu_id = tcm.second_custom_menu_id;

-- Drop temporary mapping table
DROP TABLE second_menu_mapping;

-- Drop the old tables
DROP TABLE third_custom_menu;
DROP TABLE second_custom_menu;

-- Rename the column from 'value' to 'name'
ALTER TABLE custom_menu
RENAME COLUMN value TO name;

-- Create new unique index with the renamed column
CREATE UNIQUE INDEX custom_menu_space_id_parent_id_name_uindex
ON custom_menu(space_id, parent_id, name);

-- First, add a temporary column to store the converted integer values
ALTER TABLE custom_menu
ADD COLUMN menu_order_int integer;

-- Convert existing varchar menu_order values to integers
-- This handles both numeric strings and nulls
UPDATE custom_menu
SET menu_order_int = menu_order::integer
WHERE menu_order is not null
AND menu_order != ''
AND menu_order ~ '^[0-9]+$';

-- Drop the old menu_order column
ALTER TABLE custom_menu
DROP COLUMN menu_order;

-- Rename the new integer column to menu_order
ALTER TABLE custom_menu
RENAME COLUMN menu_order_int TO menu_order;