-- Add retry mechanism and conflict tracking fields to sync_outbox table
ALTER TABLE sync_outbox
    ADD COLUMN failed_at TIMESTAMP WITH TIME ZONE,
    ADD COLUMN failure_message VARCHAR(1024),
    ADD COLUMN retry_count INTEGER NOT NULL DEFAULT 0,
    ADD COLUMN last_retry_at TIMESTAMP WITH TIME ZONE,
    ADD COLUMN max_retries INTEGER NOT NULL DEFAULT 3,
    ADD COLUMN is_conflict BOOLEAN NOT NULL DEFAULT FALSE;

DROP INDEX IF EXISTS idx_sync_outbox_unprocessed_by_term_and_type;

-- Add index for efficient querying of retryable records
-- This helps find records that are ready to sync (including retries)
CREATE INDEX idx_sync_outbox_ready_to_sync
    ON sync_outbox (sync_type, created_at)
    WHERE processed_at IS NULL AND failed_at IS NULL AND is_conflict = FALSE;

-- Index for findFailedOrConflict: includes permanently failed OR conflicts
CREATE INDEX idx_sync_outbox_failed_or_conflict
    ON sync_outbox (sync_type)
    WHERE failed_at IS NOT NULL OR is_conflict = TRUE;