CREATE
OR REPLACE FUNCTION insert_initial_space_data()
  RETURNS TRIGGER
  LANGUAGE PLPGSQL
  AS
$$
begin
insert into inscada.mail_settings(mail_settings_id, smtp_host, smtp_port, protocol, from_address, username, password,
                                    insert_user, insert_dttm, space_id)
select gen_random_uuid(),
       '',
       25,
       'SMTP',
       '',
       'inscada',
       '',
       'inscada',
       now(),
       NEW.space_id;

insert into inscada.sms_settings(sms_settings_id, provider, default_flag, insert_user, insert_dttm, space_id)
select gen_random_uuid(), 'dataport', true, 'inscada', now(), NEW.space_id;

insert into inscada.sms_settings(sms_settings_id, provider, default_flag, insert_user, insert_dttm, space_id)
select gen_random_uuid(), 'twilio', false, 'inscada', now(), NEW.space_id;

insert into inscada.sms_settings(sms_settings_id, provider, default_flag, insert_user, insert_dttm, space_id)
select gen_random_uuid(), 'netgsm', false, 'inscada', now(), NEW.space_id;

insert into inscada.broadcast_settings(broadcast_settings_id, server_ip_addr, app_name, insert_user, insert_dttm, space_id)
select gen_random_uuid(), '', '', 'inscada', now(), NEW.space_id;

insert into inscada.map_settings(map_settings_id, map_api_key, weather_api_key, insert_user, insert_dttm, space_id)
select gen_random_uuid(),
       '',
       '',
       'inscada',
       now(),
       NEW.space_id;

insert into inscada.custom_table_settings(custom_table_settings_id, url, username, password, insert_user, insert_dttm, space_id)
select gen_random_uuid(), 'jdbc:postgresql://localhost:5432/mydb', 'postgres', '', 'inscada', now(), NEW.space_id;

insert into inscada.logo_settings(logo_settings_id, sidebar_logo_height, insert_user, insert_dttm, space_id)
select gen_random_uuid(), 70, 'inscada', now(), NEW.space_id;

RETURN NEW;
END;
$$;