create table custom_menu
(
	custom_menu_id serial not null
		constraint custom_menu_custom_menu_id_pk
			primary key,
	value varchar(100) not null,
	icon varchar(50),
	target varchar(50),
	position varchar(20),
	content_type varchar(50),
	content text,

    space_id     integer      not null,
	insert_user varchar(50) not null,
	insert_dttm timestamp with time zone not null,
	version_user varchar(50),
	version_dttm timestamp with time zone
)
;

create unique index custom_menu_space_id_value_uindex on custom_menu(space_id, value);

ALTER SEQUENCE custom_menu_custom_menu_id_seq RENAME TO custom_menu_seq;
ALTER SEQUENCE custom_menu_seq INCREMENT 50;

create table second_custom_menu
(
    second_custom_menu_id serial       not null
        constraint second_custom_menu_second_custom_menu_id_pk
        primary key,
    custom_menu_id       integer      not null
        constraint second_custom_menu_custom_menu_custom_menu_id_fk
        references custom_menu
        on update cascade on delete cascade,
    value varchar(100) not null,
    icon varchar(50),
    content_type varchar(50),
    content text,
    
    space_id     integer      not null,
   	insert_user varchar(50) not null,
   	insert_dttm timestamp with time zone not null,
   	version_user varchar(50),
   	version_dttm timestamp with time zone
)
;

create unique index second_custom_menu_space_id_custom_menu_id_value_uindex 
on second_custom_menu(space_id, custom_menu_id, value);

ALTER SEQUENCE second_custom_menu_second_custom_menu_id_seq RENAME TO second_custom_menu_seq;
ALTER SEQUENCE second_custom_menu_seq INCREMENT 50;

create table third_custom_menu
(
    third_custom_menu_id serial       not null
        constraint third_custom_menu_third_custom_menu_id_pk
        primary key,
    second_custom_menu_id       integer      not null
        constraint third_custom_menu_second_custom_menu_second_custom_menu_id_fk
        references second_custom_menu
        on update cascade on delete cascade,
    value varchar(100) not null,
    icon varchar(50),
    content_type varchar(50),
    content text,
    
    space_id     integer      not null,
   	insert_user varchar(50) not null,
   	insert_dttm timestamp with time zone not null,
   	version_user varchar(50),
   	version_dttm timestamp with time zone
)
;

create unique index third_custom_menu_space_id_second_custom_menu_id_value_uindex 
on third_custom_menu(space_id, second_custom_menu_id, value);

ALTER SEQUENCE third_custom_menu_third_custom_menu_id_seq RENAME TO third_custom_menu_seq;
ALTER SEQUENCE third_custom_menu_seq INCREMENT 50;

insert into inscada.permissions(permission_id, name)
values  (237, 'CREATE_CUSTOM_MENU'), (238, 'VIEW_CUSTOM_MENU'),
        (239, 'UPDATE_CUSTOM_MENU'), (240, 'DELETE_CUSTOM_MENU'),
        (241, 'EXPORT_CUSTOM_MENU'), (242, 'IMPORT_CUSTOM_MENU');

insert into inscada.role_permissions (role_id, permission_id)
values (1, 237), (1, 238), (1, 239), (1, 240), (1, 241), (1, 242);

insert into inscada.menus (menu_id, name) values (88, 'Custom Menu Dev');
insert into inscada.role_menus (role_id, menu_id) values (1, 88);