-- Frame tables modifications

ALTER TABLE inscada.dnp3_frame ADD COLUMN start_address integer, ADD column quantity integer;
ALTER TABLE inscada.iec104_frame ADD COLUMN start_address integer, ADD column quantity integer;
ALTER TABLE inscada.modbus_frame ADD COLUMN start_address integer, ADD column quantity integer;
ALTER TABLE inscada.s7_frame ADD COLUMN start_address integer, ADD column quantity integer;

UPDATE inscada.dnp3_frame u
SET start_address = f.start_address, quantity = f.quantity
FROM inscada.frame f
WHERE f.frame_id = u.frame_id;

UPDATE inscada.iec104_frame u 
SET start_address = f.start_address, quantity = f.quantity
FROM inscada.frame f
WHERE f.frame_id = u.frame_id;

UPDATE inscada.modbus_frame u 
SET start_address = f.start_address, quantity = f.quantity
FROM inscada.frame f
WHERE f.frame_id = u.frame_id;

UPDATE inscada.s7_frame u 
SET start_address = f.start_address, quantity = f.quantity
FROM inscada.frame f
WHERE f.frame_id = u.frame_id;

ALTER TABLE inscada.frame DROP COLUMN start_address, DROP COLUMN quantity;

ALTER TABLE inscada.dnp3_frame ALTER COLUMN start_address SET NOT NULL, ALTER COLUMN quantity SET NOT NULL;
ALTER TABLE inscada.iec104_frame ALTER COLUMN start_address SET NOT NULL, ALTER COLUMN quantity SET NOT NULL;
ALTER TABLE inscada.modbus_frame ALTER COLUMN start_address SET NOT NULL, ALTER COLUMN quantity SET NOT NULL;
ALTER TABLE inscada.s7_frame ALTER COLUMN start_address SET NOT NULL, ALTER COLUMN quantity SET NOT NULL;

-- Variable tables modifications

ALTER TABLE inscada.dnp3_variable ADD COLUMN start_address integer;
ALTER TABLE inscada.iec104_variable ADD COLUMN start_address integer;
ALTER TABLE inscada.modbus_variable ADD COLUMN start_address integer;
ALTER TABLE inscada.s7_variable ADD COLUMN start_address integer;

UPDATE inscada.dnp3_variable u
SET start_address = v.start_address
FROM inscada.variable v
WHERE v.variable_id = u.variable_id;

UPDATE inscada.iec104_variable u 
SET start_address = v.start_address
FROM inscada.variable v
WHERE v.variable_id = u.variable_id;

UPDATE inscada.modbus_variable u 
SET start_address = v.start_address
FROM inscada.variable v
WHERE v.variable_id = u.variable_id;

UPDATE inscada.s7_variable u 
SET start_address = v.start_address
FROM inscada.variable v
WHERE v.variable_id = u.variable_id;

ALTER TABLE inscada.variable DROP COLUMN start_address;

ALTER TABLE inscada.dnp3_variable ALTER COLUMN start_address SET NOT NULL;
ALTER TABLE inscada.iec104_variable ALTER COLUMN start_address SET NOT NULL;
ALTER TABLE inscada.modbus_variable ALTER COLUMN start_address SET NOT NULL;
ALTER TABLE inscada.s7_variable ALTER COLUMN start_address SET NOT NULL;

-- OPC DA tables

create table opc_da_connection
(
    conn_id integer not null primary key
);

create table opc_da_device
(
    device_id integer not null primary key,
    scan_time integer not null,
    server_status_check_time integer not null,
    com_prog_id varchar(50) not null
);

create table opc_da_frame
(
  frame_id integer not null primary key,
  scan_time_factor integer,
  active_flag boolean not null,
  percent_deadband real
);

create table opc_da_variable
(
    variable_id integer not null primary key,
    type varchar(50) not  null
);

