create table mqtt_connection
(
    conn_id integer not null primary key,
    identifier varchar(23),
    username varchar(50),
    password varchar(50),
    use_ssl boolean,
    initial_delay integer,
    max_delay integer,
    clean_session boolean,
    keep_alive integer,
    pool_size integer
);

create table mqtt_device
(
    device_id integer not null primary key,
    base_topic text not null
);

create table mqtt_frame
(
  frame_id integer not null primary key,
  topic text not null,
  qos integer not null,
  subscribe_expression_type varchar(50),
  subscribe_expression text,
  subscribe_expression_id integer
        constraint mqtt_frame_expression_subscribe_expression_id_fk
        references expression
        on update cascade on delete set null,
  publish_expression_type varchar(50),
  publish_expression text,
  publish_expression_id integer
  		constraint mqtt_frame_expression_publish_expression_id_fk
  		references expression
  		on update cascade on delete set null
);

create table mqtt_variable
(
    variable_id integer not null primary key,
    type varchar(50) not null
);