-- This migration corrects the insert_initial_security_data function.
-- It ensures that only template permissions and menus (where space_id is NULL)
-- are assigned to the default 'Space Admin' role when a new space is created.

CREATE OR REPLACE FUNCTION insert_initial_security_data()
RETURNS TRIGGER
LANGUAGE plpgsql
AS $$
DECLARE
    initial_role_id UUID;
BEGIN
    -- Create the initial role for the new space
    INSERT INTO inscada.roles(role_id, name, space_id, insert_user, insert_dttm)
    VALUES (gen_random_uuid(), 'Space Admin', NEW.space_id, 'inscada', now())
    RETURNING role_id INTO initial_role_id;

    -- Assign template permissions (where space_id is NULL) to the new role
    INSERT INTO inscada.role_permissions(role_id, permission_id)
    SELECT initial_role_id, p.permission_id
    FROM inscada.permissions p
    WHERE p.space_id IS NULL;

    -- Assign template menus (where space_id is NULL) to the new role
    INSERT INTO inscada.role_menus(role_id, menu_id)
    SELECT initial_role_id, m.menu_id
    FROM inscada.menus m
    WHERE m.space_id IS NULL;

    RETURN NEW;
END;
$$;