create table settings
(
    setting_id serial not null constraint settings_setting_id_pk primary key,
    key     varchar(50)  not null,
    value   varchar(100) not null,
    insert_user  varchar(50)  not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
);

create unique index settings_key_uindex on settings (key);

create table map_settings
(
    map_settings_id serial not null constraint map_settings_map_settings_id_pk primary key,
    map_api_key     varchar(255) not null,
    weather_api_key varchar(255) not null,
    insert_user     varchar(50),
    insert_dttm     timestamp with time zone,
    version_user    varchar(50),
    version_dttm    timestamp with time zone,
    space_id        int
);

create table custom_table_settings
(
    custom_table_settings_id serial not null constraint custom_table_settings_custom_table_settings_id_pk primary key,
    url             varchar not null,
    username        varchar not null,
    password        varchar not null,
    insert_user     varchar(50),
    insert_dttm     timestamp with time zone,
    version_user    varchar(50),
    version_dttm    timestamp with time zone,
    space_id        int
);

insert into settings (key, value, insert_user, insert_dttm)
values ('log_duration_in_days', 14, 'inscada', now()),
       ('variable_value_log_duration_in_days', 365, 'inscada', now()),
       ('fired_alarm_log_duration_in_days', 180, 'inscada', now());

insert into inscada.mail_settings(smtp_host,smtp_port, protocol, username, password, insert_user, insert_dttm, space_id)
select 'mail.inscada.com', 25, 'SMTP', 'inscada', '', 'inscada', now(),
       (select space_id from space where space.name='default_space')
    where not exists(select * from inscada.mail_settings);

insert into inscada.sms_settings(provider, config, default_flag, insert_user, insert_dttm, space_id)
select 'dataport', '{}', true, 'inscada', now(),
       (select space_id from space where space.name='default_space')
    where not exists(select * from inscada.sms_settings where provider='dataport');

insert into inscada.sms_settings(provider, config, default_flag, insert_user, insert_dttm, space_id)
select 'twilio', '{}', false, 'inscada', now(),
       (select space_id from space where space.name='default_space')
    where not exists(select * from inscada.sms_settings where provider='twilio');

insert into inscada.broadcast_settings(server_ip_addr, insert_user, insert_dttm, space_id)
select 'https://www.inscada.com', 'inscada', now(), (select space_id from space where space.name='default_space');

insert into inscada.map_settings(map_api_key, weather_api_key, insert_user, insert_dttm, space_id)
select 'pk.eyJ1IjoieXJ5c2t1bCIsImEiOiJjazc0ZDc0NmswMnlvM2ptdnRqaW4ya3IxIn0.9YN8pWOfuz19ILnJy311ww',
       'd1a6442a2d89164ee9cc3d3a9c9c7ed3', 'inscada', now(), (select space_id from space where space.name='default_space');

insert into inscada.custom_table_settings(url, username, password, insert_user, insert_dttm, space_id)
select 'jdbc:postgresql://localhost:5432/mydb', 'postgres', '', 'inscada', now(),
 (select space_id from space where space.name='default_space');

delete from inscada.role_permissions where permission_id in (15,16,25,26,87,88,118,119);
delete from inscada.permissions where permission_id in (15,16,25,26,87,88,118,119);  --Alarm, Log, Value Settings

insert into inscada.permissions(permission_id, name)
values (190, 'VIEW_GENERAL_SETTINGS'), (191, 'UPDATE_GENERAL_SETTINGS');

insert into inscada.role_permissions (role_id, permission_id)
values (1, 190), (1, 191);

insert into inscada.permissions(permission_id, name)
values (192, 'VIEW_CUSTOM_TABLE_SETTINGS'), (193, 'UPDATE_CUSTOM_TABLE_SETTINGS');

insert into inscada.role_permissions (role_id, permission_id)
values (1, 192), (1, 193);

insert into inscada.menus (menu_id, name)
values (62, 'Settings'), (63, 'General Settings'), (64, 'Email Settings'),
       (65, 'SMS Settings'), (66, 'Stream Settings'), (67, 'Map Settings'), (68, 'Custom Table Settings');

insert into inscada.role_menus (role_id, menu_id)
values (1, 62), (1, 63), (1, 64), (1, 65), (1, 66), (1, 67), (1, 68);