-- =============================================================================
-- CREATE UNIFIED VARIABLE VIEW FOR TABLE_PER_CLASS
-- This view aggregates all protocol-specific variable tables into a single queryable view
-- =============================================================================

-- Drop the views if they exist (for re-running migration)
DROP VIEW IF EXISTS variable;
DROP VIEW IF EXISTS frame;
DROP VIEW IF EXISTS device;
DROP VIEW IF EXISTS connection;

CREATE VIEW connection AS
-- DNP3 Connections
SELECT
    conn_id,
    project_id,
    space_id,
    owner_id,
    insert_user,
    insert_dttm,
    version_user,
    version_dttm,
    name,
    dsc,
    protocol,
    ip,
    port
FROM dnp3_connection

UNION ALL

-- Modbus Connections
SELECT
    conn_id,
    project_id,
    space_id,
    owner_id,
    insert_user,
    insert_dttm,
    version_user,
    version_dttm,
    name,
    dsc,
    protocol,
    ip,
    port
FROM modbus_connection

UNION ALL

-- S7 Connections
SELECT
    conn_id,
    project_id,
    space_id,
    owner_id,
    insert_user,
    insert_dttm,
    version_user,
    version_dttm,
    name,
    dsc,
    protocol,
    ip,
    port
FROM s7_connection

UNION ALL

-- IEC104 Connections
SELECT
    conn_id,
    project_id,
    space_id,
    owner_id,
    insert_user,
    insert_dttm,
    version_user,
    version_dttm,
    name,
    dsc,
    protocol,
    ip,
    port
FROM iec104_connection

UNION ALL

-- IEC61850 Connections
SELECT
    conn_id,
    project_id,
    space_id,
    owner_id,
    insert_user,
    insert_dttm,
    version_user,
    version_dttm,
    name,
    dsc,
    protocol,
    ip,
    port
FROM iec61850_connection

UNION ALL

-- MQTT Connections
SELECT
    conn_id,
    project_id,
    space_id,
    owner_id,
    insert_user,
    insert_dttm,
    version_user,
    version_dttm,
    name,
    dsc,
    protocol,
    ip,
    port
FROM mqtt_connection

UNION ALL

-- OPC_UA Connections
SELECT
    conn_id,
    project_id,
    space_id,
    owner_id,
    insert_user,
    insert_dttm,
    version_user,
    version_dttm,
    name,
    dsc,
    protocol,
    ip,
    port
FROM opc_ua_connection

UNION ALL

-- Ethernet_IP Connections
SELECT
    conn_id,
    project_id,
    space_id,
    owner_id,
    insert_user,
    insert_dttm,
    version_user,
    version_dttm,
    name,
    dsc,
    protocol,
    ip,
    port
FROM ethernet_ip_connection

UNION ALL

-- Fatek Connections
SELECT
    conn_id,
    project_id,
    space_id,
    owner_id,
    insert_user,
    insert_dttm,
    version_user,
    version_dttm,
    name,
    dsc,
    protocol,
    ip,
    port
FROM fatek_connection

UNION ALL

-- Local Connections
SELECT
    conn_id,
    project_id,
    space_id,
    owner_id,
    insert_user,
    insert_dttm,
    version_user,
    version_dttm,
    name,
    dsc,
    protocol,
    ip,
    port
FROM local_connection

UNION ALL

-- OPC_DA Connections
SELECT
    conn_id,
    project_id,
    space_id,
    owner_id,
    insert_user,
    insert_dttm,
    version_user,
    version_dttm,
    name,
    dsc,
    protocol,
    ip,
    port
FROM opc_da_connection;

-- =============================================================================
-- DEVICE VIEW - Add missing clazz_ discriminator column
-- =============================================================================

DROP VIEW IF EXISTS device;

CREATE VIEW device AS
-- DNP3 Devices
SELECT
    d.device_id,
    d.conn_id,
    d.space_id,
    d.insert_user,
    d.insert_dttm,
    d.version_user,
    d.version_dttm,
    d.name,
    d.dsc,
    c.protocol as protocol
FROM dnp3_device d
JOIN dnp3_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Modbus Devices
SELECT
    d.device_id,
    d.conn_id,
    d.space_id,
    d.insert_user,
    d.insert_dttm,
    d.version_user,
    d.version_dttm,
    d.name,
    d.dsc,
    c.protocol as protocol
FROM modbus_device d
JOIN modbus_connection c ON d.conn_id = c.conn_id

UNION ALL

-- S7 Devices
SELECT
    d.device_id,
    d.conn_id,
    d.space_id,
    d.insert_user,
    d.insert_dttm,
    d.version_user,
    d.version_dttm,
    d.name,
    d.dsc,
    c.protocol as protocol
FROM s7_device d
JOIN s7_connection c ON d.conn_id = c.conn_id

UNION ALL

-- IEC104 Devices
SELECT
    d.device_id,
    d.conn_id,
    d.space_id,
    d.insert_user,
    d.insert_dttm,
    d.version_user,
    d.version_dttm,
    d.name,
    d.dsc,
    c.protocol as protocol
FROM iec104_device d
JOIN iec104_connection c ON d.conn_id = c.conn_id

UNION ALL

-- IEC61850 Devices
SELECT
    d.device_id,
    d.conn_id,
    d.space_id,
    d.insert_user,
    d.insert_dttm,
    d.version_user,
    d.version_dttm,
    d.name,
    d.dsc,
    c.protocol as protocol
FROM iec61850_device d
JOIN iec61850_connection c ON d.conn_id = c.conn_id

UNION ALL

-- MQTT Devices
SELECT
    d.device_id,
    d.conn_id,
    d.space_id,
    d.insert_user,
    d.insert_dttm,
    d.version_user,
    d.version_dttm,
    d.name,
    d.dsc,
    c.protocol as protocol
FROM mqtt_device d
JOIN mqtt_connection c ON d.conn_id = c.conn_id

UNION ALL

-- OPC_UA Devices
SELECT
    d.device_id,
    d.conn_id,
    d.space_id,
    d.insert_user,
    d.insert_dttm,
    d.version_user,
    d.version_dttm,
    d.name,
    d.dsc,
    c.protocol as protocol
FROM opc_ua_device d
JOIN opc_ua_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Ethernet_IP Devices
SELECT
    d.device_id,
    d.conn_id,
    d.space_id,
    d.insert_user,
    d.insert_dttm,
    d.version_user,
    d.version_dttm,
    d.name,
    d.dsc,
    c.protocol as protocol
FROM ethernet_ip_device d
JOIN ethernet_ip_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Fatek Devices
SELECT
    d.device_id,
    d.conn_id,
    d.space_id,
    d.insert_user,
    d.insert_dttm,
    d.version_user,
    d.version_dttm,
    d.name,
    d.dsc,
    c.protocol as protocol
FROM fatek_device d
JOIN fatek_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Local Devices
SELECT
    d.device_id,
    d.conn_id,
    d.space_id,
    d.insert_user,
    d.insert_dttm,
    d.version_user,
    d.version_dttm,
    d.name,
    d.dsc,
    c.protocol as protocol
FROM local_device d
JOIN local_connection c ON d.conn_id = c.conn_id

UNION ALL

-- OPC_DA Devices
SELECT
    d.device_id,
    d.conn_id,
    d.space_id,
    d.insert_user,
    d.insert_dttm,
    d.version_user,
    d.version_dttm,
    d.name,
    d.dsc,
    c.protocol as protocol
FROM opc_da_device d
JOIN opc_da_connection c ON d.conn_id = c.conn_id;

-- =============================================================================
-- FRAME VIEW - Add missing clazz_ discriminator column
-- =============================================================================

DROP VIEW IF EXISTS frame;

CREATE VIEW frame AS
-- DNP3 Frames
SELECT
    f.frame_id,
    f.device_id,
    f.space_id,
    f.insert_user,
    f.insert_dttm,
    f.version_user,
    f.version_dttm,
    f.name,
    f.dsc,
    f.minutes_offset,
    f.scan_time_factor,
    f.readable_flag,
    f.writable_flag,
    c.protocol as protocol
FROM dnp3_frame f
JOIN dnp3_device d ON f.device_id = d.device_id
JOIN dnp3_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Modbus Frames
SELECT
    f.frame_id,
    f.device_id,
    f.space_id,
    f.insert_user,
    f.insert_dttm,
    f.version_user,
    f.version_dttm,
    f.name,
    f.dsc,
    f.minutes_offset,
    f.scan_time_factor,
    f.readable_flag,
    f.writable_flag,
    c.protocol as protocol
FROM modbus_frame f
JOIN modbus_device d ON f.device_id = d.device_id
JOIN modbus_connection c ON d.conn_id = c.conn_id

UNION ALL

-- S7 Frames
SELECT
    f.frame_id,
    f.device_id,
    f.space_id,
    f.insert_user,
    f.insert_dttm,
    f.version_user,
    f.version_dttm,
    f.name,
    f.dsc,
    f.minutes_offset,
    f.scan_time_factor,
    f.readable_flag,
    f.writable_flag,
    c.protocol as protocol
FROM s7_frame f
JOIN s7_device d ON f.device_id = d.device_id
JOIN s7_connection c ON d.conn_id = c.conn_id

UNION ALL

-- IEC104 Frames
SELECT
    f.frame_id,
    f.device_id,
    f.space_id,
    f.insert_user,
    f.insert_dttm,
    f.version_user,
    f.version_dttm,
    f.name,
    f.dsc,
    f.minutes_offset,
    f.scan_time_factor,
    f.readable_flag,
    f.writable_flag,
    c.protocol as protocol
FROM iec104_frame f
JOIN iec104_device d ON f.device_id = d.device_id
JOIN iec104_connection c ON d.conn_id = c.conn_id

UNION ALL

-- IEC61850 Frames
SELECT
    f.frame_id,
    f.device_id,
    f.space_id,
    f.insert_user,
    f.insert_dttm,
    f.version_user,
    f.version_dttm,
    f.name,
    f.dsc,
    f.minutes_offset,
    f.scan_time_factor,
    f.readable_flag,
    f.writable_flag,
    c.protocol as protocol
FROM iec61850_frame f
JOIN iec61850_device d ON f.device_id = d.device_id
JOIN iec61850_connection c ON d.conn_id = c.conn_id

UNION ALL

-- MQTT Frames
SELECT
    f.frame_id,
    f.device_id,
    f.space_id,
    f.insert_user,
    f.insert_dttm,
    f.version_user,
    f.version_dttm,
    f.name,
    f.dsc,
    f.minutes_offset,
    f.scan_time_factor,
    f.readable_flag,
    f.writable_flag,
    c.protocol as protocol
FROM mqtt_frame f
JOIN mqtt_device d ON f.device_id = d.device_id
JOIN mqtt_connection c ON d.conn_id = c.conn_id

UNION ALL

-- OPC_UA Frames
SELECT
    f.frame_id,
    f.device_id,
    f.space_id,
    f.insert_user,
    f.insert_dttm,
    f.version_user,
    f.version_dttm,
    f.name,
    f.dsc,
    f.minutes_offset,
    f.scan_time_factor,
    f.readable_flag,
    f.writable_flag,
    c.protocol as protocol
FROM opc_ua_frame f
JOIN opc_ua_device d ON f.device_id = d.device_id
JOIN opc_ua_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Ethernet_IP Frames
SELECT
    f.frame_id,
    f.device_id,
    f.space_id,
    f.insert_user,
    f.insert_dttm,
    f.version_user,
    f.version_dttm,
    f.name,
    f.dsc,
    f.minutes_offset,
    f.scan_time_factor,
    f.readable_flag,
    f.writable_flag,
    c.protocol as protocol
FROM ethernet_ip_frame f
JOIN ethernet_ip_device d ON f.device_id = d.device_id
JOIN ethernet_ip_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Fatek Frames
SELECT
    f.frame_id,
    f.device_id,
    f.space_id,
    f.insert_user,
    f.insert_dttm,
    f.version_user,
    f.version_dttm,
    f.name,
    f.dsc,
    f.minutes_offset,
    f.scan_time_factor,
    f.readable_flag,
    f.writable_flag,
    c.protocol as protocol
FROM fatek_frame f
JOIN fatek_device d ON f.device_id = d.device_id
JOIN fatek_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Local Frames
SELECT
    f.frame_id,
    f.device_id,
    f.space_id,
    f.insert_user,
    f.insert_dttm,
    f.version_user,
    f.version_dttm,
    f.name,
    f.dsc,
    f.minutes_offset,
    f.scan_time_factor,
    f.readable_flag,
    f.writable_flag,
    c.protocol as protocol
FROM local_frame f
JOIN local_device d ON f.device_id = d.device_id
JOIN local_connection c ON d.conn_id = c.conn_id

UNION ALL

-- OPC_DA Frames
SELECT
    f.frame_id,
    f.device_id,
    f.space_id,
    f.insert_user,
    f.insert_dttm,
    f.version_user,
    f.version_dttm,
    f.name,
    f.dsc,
    f.minutes_offset,
    f.scan_time_factor,
    f.readable_flag,
    f.writable_flag,
    c.protocol as protocol
FROM opc_da_frame f
JOIN opc_da_device d ON f.device_id = d.device_id
JOIN opc_da_connection c ON d.conn_id = c.conn_id;

-- =============================================================================
-- VARIABLE VIEW - Add missing clazz_ discriminator column
-- =============================================================================

DROP VIEW IF EXISTS variable;

CREATE VIEW variable AS
-- DNP3 Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM dnp3_variable v
JOIN dnp3_frame f ON v.frame_id = f.frame_id
JOIN dnp3_device d ON f.device_id = d.device_id
JOIN dnp3_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Modbus Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM modbus_variable v
JOIN modbus_frame f ON v.frame_id = f.frame_id
JOIN modbus_device d ON f.device_id = d.device_id
JOIN modbus_connection c ON d.conn_id = c.conn_id

UNION ALL

-- S7 Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM s7_variable v
JOIN s7_frame f ON v.frame_id = f.frame_id
JOIN s7_device d ON f.device_id = d.device_id
JOIN s7_connection c ON d.conn_id = c.conn_id

UNION ALL

-- IEC104 Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM iec104_variable v
JOIN iec104_frame f ON v.frame_id = f.frame_id
JOIN iec104_device d ON f.device_id = d.device_id
JOIN iec104_connection c ON d.conn_id = c.conn_id

UNION ALL

-- IEC61850 Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM iec61850_variable v
JOIN iec61850_frame f ON v.frame_id = f.frame_id
JOIN iec61850_device d ON f.device_id = d.device_id
JOIN iec61850_connection c ON d.conn_id = c.conn_id

UNION ALL

-- MQTT Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM mqtt_variable v
JOIN mqtt_frame f ON v.frame_id = f.frame_id
JOIN mqtt_device d ON f.device_id = d.device_id
JOIN mqtt_connection c ON d.conn_id = c.conn_id

UNION ALL

-- OPC_UA Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM opc_ua_variable v
JOIN opc_ua_frame f ON v.frame_id = f.frame_id
JOIN opc_ua_device d ON f.device_id = d.device_id
JOIN opc_ua_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Ethernet_IP Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM ethernet_ip_variable v
JOIN ethernet_ip_frame f ON v.frame_id = f.frame_id
JOIN ethernet_ip_device d ON f.device_id = d.device_id
JOIN ethernet_ip_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Fatek Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM fatek_variable v
JOIN fatek_frame f ON v.frame_id = f.frame_id
JOIN fatek_device d ON f.device_id = d.device_id
JOIN fatek_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Local Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM local_variable v
JOIN local_frame f ON v.frame_id = f.frame_id
JOIN local_device d ON f.device_id = d.device_id
JOIN local_connection c ON d.conn_id = c.conn_id

UNION ALL

-- OPC_DA Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM opc_da_variable v
JOIN opc_da_frame f ON v.frame_id = f.frame_id
JOIN opc_da_device d ON f.device_id = d.device_id
JOIN opc_da_connection c ON d.conn_id = c.conn_id;

-- Add comments for documentation
COMMENT ON VIEW connection IS 'Unified view combining all protocol-specific connection tables for TABLE_PER_CLASS compatibility';
COMMENT ON VIEW device IS 'Unified view combining all protocol-specific device tables for TABLE_PER_CLASS compatibility';
COMMENT ON VIEW frame IS 'Unified view combining all protocol-specific frame tables for TABLE_PER_CLASS compatibility';
COMMENT ON VIEW variable IS 'Unified view combining all protocol-specific variable tables for TABLE_PER_CLASS compatibility';
