-- Add space-aware menus with is_global support
-- Add space_id and is_global columns to menus table
ALTER TABLE menus ADD COLUMN space_id VARCHAR(36);
ALTER TABLE menus ADD COLUMN is_global BOOLEAN DEFAULT FALSE;

-- Drop existing unique constraint and create new one
DROP INDEX IF EXISTS menus_name_uindex;

-- Create new unique index on name and space_id combination
CREATE UNIQUE INDEX menus_space_name_uindex ON menus (space_id, name);

-- Create index for better performance
CREATE INDEX idx_menus_is_global ON menus(is_global);
CREATE INDEX idx_menus_space_id ON menus(space_id);

-- Add foreign key constraint
ALTER TABLE menus ADD CONSTRAINT fk_menus_space
    FOREIGN KEY (space_id) REFERENCES space(space_id);

-- Mark global menus (system-wide menus that should be available across all spaces)
UPDATE menus SET is_global = TRUE
WHERE name IN (
    'Auth Log',
    'License',
    'Users',
    'Roles',
    'Spaces',
    'System Stats',
    'OTP Settings',
    'Ip Filter Settings'
);

INSERT INTO menus (menu_id, name, is_global, space_id, insert_user, insert_dttm) VALUES
    ('109', 'Space Users', FALSE, NULL, 'system', NOW()),
    ('110', 'Space Roles', FALSE, NULL, 'system', NOW());

