-- Add leadership term and sync type columns to the outbox table
ALTER TABLE sync_outbox
    ADD COLUMN leadership_term_id BIGINT NOT NULL DEFAULT -1,
    ADD COLUMN sync_type VARCHAR(255) NOT NULL DEFAULT 'unknown';

-- Drop the old, now-redundant index.
DROP INDEX IF EXISTS idx_sync_outbox_unprocessed;

-- Add a new, more specific partial index to optimize queries for the sync workers.
-- This composite index is highly efficient for finding unprocessed records
-- for a specific type and term, ordered by creation date.
CREATE INDEX idx_sync_outbox_unprocessed_by_term_and_type
    ON sync_outbox (sync_type, leadership_term_id, created_at ASC)
    WHERE processed_at IS NULL;