-- Step 1: Find and nullify duplicate phone numbers.
-- This script identifies users with duplicate phone numbers and sets the 'phone' field
-- to NULL for all but the oldest entry for each phone number.
-- This preserves the user accounts while ensuring uniqueness for the constraint.
WITH duplicates AS (
    SELECT
        user_id,
        ROW_NUMBER() OVER(PARTITION BY phone ORDER BY insert_dttm ASC) as rn
    FROM
        inscada."users"
    WHERE
        phone IS NOT NULL AND phone != '' AND deleted_dttm IS NULL
)
UPDATE
    inscada."users"
SET
    phone = NULL
FROM
    duplicates
WHERE
    inscada."users".user_id = duplicates.user_id AND duplicates.rn > 1;

-- Step 2: Add the unique constraint to the phone column.
-- This will only succeed if Step 1 has successfully resolved all duplicates.
-- We use a partial index to enforce uniqueness only on active (not soft-deleted) users.
CREATE UNIQUE INDEX IF NOT EXISTS uk_user_phone ON inscada."users" (phone) WHERE deleted_dttm IS NULL;