INSERT INTO permissions (permission_id, name, is_global, space_id, insert_user, insert_dttm) VALUES
    ('272', 'VIEW_CLUSTER_STATUS', TRUE, NULL, 'system', NOW());

INSERT INTO menus (menu_id, name, is_global, space_id, insert_user, insert_dttm) VALUES
    ('111', 'Cluster Status', TRUE, NULL, 'system', NOW());

-- Insert VIEW_CLUSTER_STATUS permission for all existing spaces
INSERT INTO permissions (permission_id, name, is_global, space_id, insert_user, insert_dttm)
SELECT
    gen_random_uuid()::text as permission_id,
    'VIEW_CLUSTER_STATUS' as name,
    TRUE as is_global,
    s.space_id,
    'system' as insert_user,
    NOW() as insert_dttm
FROM space s
WHERE s.space_id IS NOT NULL;

-- Insert Cluster Status menu for all existing spaces
INSERT INTO menus (menu_id, name, is_global, space_id, insert_user, insert_dttm)
SELECT
    gen_random_uuid()::text as menu_id,
    'Cluster Status' as name,
    TRUE as is_global,
    s.space_id,
    'system' as insert_user,
    NOW() as insert_dttm
FROM space s
WHERE s.space_id IS NOT NULL;