alter table faceplate add column is_new_version boolean;

create table faceplate_placeholder
(
    placeholder_id serial    not null
        constraint faceplate_placeholder_placeholder_id_pk
        primary key,
    faceplate_id    integer      not null
        constraint faceplate_placeholder_faceplate_faceplate_id_fk
        references faceplate
        on update cascade on delete cascade,
    name            varchar(100) not null,
    type            varchar(50)  not null,
    props           text,

    space_id        integer      not null,
    insert_user     varchar(50)  not null,
    insert_dttm     timestamp with time zone not null,
    version_user    varchar(50),
    version_dttm    timestamp with time zone
)
;

create unique index faceplate_placeholder_faceplate_id_name_uindex
    on faceplate_placeholder (faceplate_id, name)
;

ALTER SEQUENCE faceplate_placeholder_placeholder_id_seq RENAME TO faceplate_placeholder_seq;

ALTER SEQUENCE faceplate_placeholder_seq INCREMENT 50;