create table sent_chat_message
(
    sent_chat_message_id serial not null constraint sen_chat_message_sent_chat_message_id_pk primary key,
    content         varchar(4000) not null,
    insert_user     varchar(50),
    insert_dttm     timestamp with time zone,
    version_user    varchar(50),
    version_dttm    timestamp with time zone,
    space_id        int
);

create index sent_chat_message_space_id_insert_user_index on sent_chat_message (space_id, insert_user);
create index sent_chat_message_space_id_insert_dttm_index on sent_chat_message (space_id, insert_dttm);
create index sent_chat_message_space_id_content_index on sent_chat_message (space_id, upper(content));

insert into inscada.permissions(permission_id, name)
values (194, 'VIEW_SENT_CHAT_MESSAGES');

insert into inscada.role_permissions (role_id, permission_id)
values (1, 194);

insert into inscada.menus (menu_id, name)
values (69, 'Chat History');

insert into inscada.role_menus (role_id, menu_id)
values (1, 69);