﻿--- Space Tables

create table space
(
    space_id serial not null
        constraint space_space_id_pk
            primary key,
    name         varchar(100)             not null,
    insert_user  varchar(50)              not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
);

alter sequence space_space_id_seq increment 50;

create unique index space_name_uindex on space (name);

create table space_users
(
    space_id int not null,
    user_id  int not null
);

alter table space_users
    add constraint space_users_pk
        primary key (space_id, user_id);

--- Space Permissions - What if role with id 1 is removed?

insert into inscada.permissions(permission_id, name)
values (184, 'CREATE_SPACE'), (185, 'UPDATE_SPACE'), (186, 'DELETE_SPACE'), (187, 'VIEW_SPACE');

insert into inscada.role_permissions (role_id, permission_id)
values (1, 184), (1, 185), (1, 186), (1, 187);

insert into inscada.menus (menu_id, name)
values (59, 'Spaces');

insert into inscada.role_menus (role_id, menu_id)
values (1, 59);

--- Default space

insert into space (name, insert_user, insert_dttm)
values ('default_space', 'inscada', now());

insert into space_users (space_id, user_id)
select (select space_id from space where space.name='default_space'), user_id
from users;

--- Space columns and indexes

alter table alarm
    add space_id int;
drop index if exists alarm_project_id_name_uindex;
create unique index alarm_space_id_project_id_name_uindex on alarm (space_id, project_id, name);
update alarm set space_id = (select space_id from space where space.name='default_space');
alter table alarm alter column space_id set not null;

alter table alarm_group
    add space_id int;
drop index if exists alarm_group_project_id_name_uindex;
create unique index alarm_group_space_id_project_id_name_uindex on alarm_group (space_id, project_id, name);
update alarm_group set space_id = (select space_id from space where space.name='default_space');
alter table alarm_group alter column space_id set not null;

alter table animation
    add space_id int;
drop index if exists animation_project_id_name_uindex;
create unique index animation_space_id_project_id_name_uindex on animation (space_id, project_id, name);
update animation set space_id = (select space_id from space where space.name='default_space');
alter table animation alter column space_id set not null;

alter table animation_element
    add space_id int;
drop index if exists animation_element_animation_id_name_uindex;
create unique index animation_element_space_id_animation_id_name_uindex on animation_element (space_id, animation_id, name);
update animation_element set space_id = (select space_id from space where space.name='default_space');
alter table animation_element alter column space_id set not null;

alter table animation_script
    add space_id int;
update animation_script set space_id = (select space_id from space where space.name='default_space');
alter table animation_script alter column space_id set not null;

alter table board
    add space_id int;
update board set space_id = (select space_id from space where space.name='default_space');
alter table board alter column space_id set not null;

alter table board_group
    add space_id int;
drop index if exists board_group_name_uindex;
create unique index board_group_space_id_name_uindex on board_group (space_id, name);
update board_group set space_id = (select space_id from space where space.name='default_space');
alter table board_group alter column space_id set not null;

alter table broadcast
    add space_id int;
drop index if exists broadcast_stream_id_uindex;
create unique index broadcast_space_id_stream_id_uindex on broadcast (space_id, stream_id);
update broadcast set space_id = (select space_id from space where space.name='default_space');
alter table broadcast alter column space_id set not null;

alter table broadcast_settings
    add space_id int;
update broadcast_settings set space_id = (select space_id from space where space.name='default_space');
alter table broadcast_settings alter column space_id set not null;

alter table connection
    add space_id int;
drop index if exists connection_project_id_name_uindex;
create unique index connection_space_id_project_id_name_uindex on connection (space_id, project_id, name);
update connection set space_id = (select space_id from space where space.name='default_space');
alter table connection alter column space_id set not null;

alter table custom_report
    add space_id int;
drop index if exists custom_report_project_id_name_uindex;
create unique index custom_report_space_id_project_id_name_uindex on custom_report (space_id, project_id, name);
update custom_report set space_id = (select space_id from space where space.name='default_space');
alter table custom_report alter column space_id set not null;

alter table custom_table
    add space_id int;
drop index if exists custom_table_name_uindex;
create unique index custom_table_space_id_name_uindex on custom_table (space_id, name);
update custom_table set space_id = (select space_id from space where space.name='default_space');
alter table custom_table alter column space_id set not null;

alter table custom_table_field
    add space_id int;
update custom_table_field set space_id = (select space_id from space where space.name='default_space');
alter table custom_table_field alter column space_id set not null;

alter table data_transfer
    add space_id int;
drop index if exists data_transfer_project_id_name_uindex;
create unique index data_transfer_space_id_project_id_name_uindex on data_transfer (space_id, project_id, name);
update data_transfer set space_id = (select space_id from space where space.name='default_space');
alter table data_transfer alter column space_id set not null;

alter table data_transfer_detail
    add space_id int;
update data_transfer_detail set space_id = (select space_id from space where space.name='default_space');
alter table data_transfer_detail alter column space_id set not null;

alter table device
    add space_id int;
drop index if exists device_conn_id_name_uindex;
drop index if exists device_name_uindex;
create unique index device_conn_id_name_uindex on device (conn_id, name) where conn_id is not null;
create unique index device_space_id_name_uindex on device (space_id, name) where conn_id is null;
update device set space_id = (select space_id from space where space.name='default_space');
alter table device alter column space_id set not null;

alter table expression
    add space_id int;
drop index if exists expression_name_uindex;
create unique index expression_space_id_name_uindex on expression (space_id, name);
update expression set space_id = (select space_id from space where space.name='default_space');
alter table expression alter column space_id set not null;

alter table frame
    add space_id int;
update frame set space_id = (select space_id from space where space.name='default_space');
alter table frame alter column space_id set not null;

alter table icon_category
    add space_id int;
drop index if exists icon_category_name_uindex;
create unique index icon_category_space_id_name_uindex on icon_category (space_id, name);
update icon_category set space_id = (select space_id from space where space.name='default_space');
alter table icon_category alter column space_id set not null;

alter table keyword
    add space_id int;
drop index if exists keyword_key_type_uindex;
create unique index keyword_space_id_key_type_uindex on keyword (space_id, type, key);
update keyword set space_id = (select space_id from space where space.name='default_space');
alter table keyword alter column space_id set not null;

alter table language
    add space_id int,
    add insert_user varchar(50),
    add insert_dttm  timestamp with time zone,
    add version_user varchar(50),
    add version_dttm timestamp with time zone;
drop index if exists language_lang_key_uindex;
create unique index language_space_id_lang_key_uindex on language (space_id, lang, key);
update language set space_id=(select space_id from space where space.name='default_space');
update language set insert_user='system_update', insert_dttm=now(), version_user='system_update', version_dttm=now();
alter table language alter column insert_user set not null;
alter table language alter column insert_dttm set not null;
alter table language alter column space_id set not null;

alter table mail_settings
    add space_id int;
update mail_settings set space_id = (select space_id from space where space.name='default_space');
alter table mail_settings alter column space_id set not null;

alter table monitor_table
    add space_id int;
drop index if exists monitor_table_project_id_name_uindex;
create unique index monitor_table_space_id_project_id_name_uindex on monitor_table (space_id, project_id, name);
update monitor_table set space_id = (select space_id from space where space.name='default_space');
alter table monitor_table alter column space_id set not null;

alter table monitor_variable
    add space_id int;
update monitor_variable set space_id = (select space_id from space where space.name='default_space');
alter table monitor_variable alter column space_id set not null;

alter table procedure
    add space_id int;
drop index if exists procedure_project_id_name_uindex;
create unique index procedure_space_id_project_id_name_uindex on procedure (space_id, project_id, name);
update procedure set space_id = (select space_id from space where space.name='default_space');
alter table procedure alter column space_id set not null;

alter table procedure_icon
    add space_id int;
update procedure_icon set space_id = (select space_id from space where space.name='default_space');
alter table procedure_icon alter column space_id set not null;

alter table procedure_icon_state
    add space_id int;
update procedure_icon_state set space_id = (select space_id from space where space.name='default_space');
alter table procedure_icon_state alter column space_id set not null;

alter table project
    add space_id int;
drop index if exists project_name_uindex;
create unique index project_space_id_name_uindex on project (space_id, name);
update project set space_id = (select space_id from space where space.name='default_space');
alter table project alter column space_id set not null;

alter table project_attachment
    add space_id int;
update project_attachment set space_id = (select space_id from space where space.name='default_space');
alter table project_attachment alter column space_id set not null;

alter table report
    add space_id int;
update report set space_id = (select space_id from space where space.name='default_space');
alter table report alter column space_id set not null;

alter table report_group
    add space_id int;
update report_group set space_id = (select space_id from space where space.name='default_space');
alter table report_group alter column space_id set not null;

alter table report_subgroup
    add space_id int;
update report_subgroup set space_id = (select space_id from space where space.name='default_space');
alter table report_subgroup alter column space_id set not null;

alter table report_variable
    add space_id int;
update report_variable set space_id = (select space_id from space where space.name='default_space');
alter table report_variable alter column space_id set not null;

alter table script
    add space_id int;
update script set space_id = (select space_id from space where space.name='default_space');
alter table script alter column space_id set not null;

alter table sent_mail
    add space_id int;
drop index if exists sent_mail_from_addr_index;
create index sent_mail_space_id_from_addr_index on sent_mail (space_id, from_addr);
drop index if exists sent_mail_dttm_index;
create index sent_mail_space_id_dttm_index on sent_mail (space_id, dttm);
drop index if exists sent_mail_subject_index;
create index sent_mail_space_id_subject_index on sent_mail (space_id, subject);
update sent_mail set space_id = (select space_id from space where space.name='default_space');
alter table sent_mail alter column space_id set not null;

alter table sent_sms
    add space_id int;
drop index if exists sent_sms_from_addr_index;
create index sent_sms_space_id_from_addr_index on sent_sms (space_id, from_addr);
drop index if exists sent_sms_to_addr_index;
create index sent_sms_space_id_to_addr_index on sent_sms (space_id, to_addr);
drop index if exists sent_sms_username_index;
create index sent_sms_space_id_username_index on sent_sms (space_id, username);
drop index if exists sent_sms_dttm_index;
create index sent_sms_space_id_dttm_index on sent_sms (space_id, dttm);
update sent_sms set space_id = (select space_id from space where space.name='default_space');
alter table sent_sms alter column space_id set not null;

alter table sms_settings
    add space_id int;
drop index if exists sms_settings_provider_uindex;
create unique index sms_settings_space_id_provider_uindex on sms_settings (space_id, provider);
update sms_settings set space_id = (select space_id from space where space.name='default_space');
alter table sms_settings alter column space_id set not null;

alter table trace_table
    add space_id int;
drop index if exists trace_table_project_id_name_uindex;
create unique index trace_table_space_id_project_id_name_uindex on trace_table (space_id, project_id, name);
update trace_table set space_id = (select space_id from space where space.name='default_space');
alter table trace_table alter column space_id set not null;

alter table trend
    add space_id int;
update trend set space_id = (select space_id from space where space.name='default_space');
alter table trend alter column space_id set not null;

alter table trend_tag
    add space_id int;
update trend_tag set space_id = (select space_id from space where space.name='default_space');
alter table trend_tag alter column space_id set not null;

alter table variable
    add space_id int;
alter table variable drop constraint project_id_frame_id_check;
drop index variable_project_id_name_uindex;
drop index variable_name_frame_id_uindex;
create unique index variable_project_id_name_uindex on variable (project_id, name)  where project_id is not null;
create unique index variable_frame_id_name_uindex on variable (frame_id, name) where project_id is null;
update variable set space_id = (select space_id from space where space.name='default_space');
alter table variable alter column space_id set not null;
