﻿DROP TABLE inscada.auth_token;

create table inscada.auth_token
(
    auth_token_id serial  not null
        constraint auth_token_auth_token_id_pk
            primary key,
    user_id integer not null
        constraint auth_token_users_user_id_fk
            references users
            on update restrict on delete cascade,
    token varchar not null,
    issue_dttm timestamp with time zone not null,
    expire_dttm timestamp with time zone,
    user_generated_flag boolean not null
);

create unique index auth_token_token_uindex
    on auth_token (token)
;

ALTER SEQUENCE auth_token_auth_token_id_seq INCREMENT 50;

CREATE TABLE inscada.auth_secret
(
    auth_secret_id    SERIAL       NOT NULL
        CONSTRAINT auth_secret_auth_secret_id_pk
            PRIMARY KEY,
    auth_secret_value VARCHAR(128) NOT NULL
);

-- insert random 1024 bits secret key on create
INSERT INTO inscada.auth_secret(auth_secret_value)
SELECT string_agg(substr('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789', ceil(random() * 62)::integer,
                         1), '')
FROM generate_series(1, 128);