/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.auth.model.AuthToken;
import com.inscada.mono.mail.restcontrollers.MailController;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.space.SpaceContext;
import com.inscada.mono.space.model.Space;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.PreUpdate;
import java.util.Objects;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.SQLRestriction;

@MappedSuperclass
@FilterDef(name="spaceFilter", parameters={@ParamDef(name="spaceId", type=String.class)}, defaultCondition="space_id = :spaceId")
@Filter(name="spaceFilter")
public abstract class SpaceBaseModel
extends BaseModel {
    public static final String SPACE_COLUMN = "space_id";
    public static final String SPACE_DEFAULT_CONDITION = "space_id = :spaceId";
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="space_id", updatable=false)
    protected Space space;
    public static final String SPACE_FILTER_NAME = "spaceFilter";
    public static final String SPACE_PARAMETER_NAME = "spaceId";

    public Space getSpace() {
        SpaceBaseModel a;
        return a.space;
    }

    public boolean equals(Object object) {
        SpaceBaseModel a = this;
        Object a2 = object;
        if (a == a2) {
            return --1 != 0;
        }
        if (!(a2 instanceof SpaceBaseModel)) {
            return false;
        }
        Object object2 = a2;
        return Objects.equals(a.getSpace(), object2.getSpace());
    }

    @PreUpdate
    @PreRemove
    public void checkSpace() {
        SpaceBaseModel a;
        if (a.getSpace() == null || !a.getSpace().equals((Object)SpaceContext.getActiveSpace())) {
            throw new EntityNotFoundException(AuthToken.m_Ufa((Object)"\u0017\u00051\u000e?M \u00051M'\u001d5\u000e1"));
        }
    }

    public int hashCode() {
        SpaceBaseModel a;
        Object[] objectArray = new Object[--1];
        objectArray[3 & 4] = a.getSpace();
        return Objects.hash(objectArray);
    }

    @PrePersist
    public void setActiveSpace() {
        SpaceBaseModel a;
        if (a.getSpace() == null) {
            a.setSpace(Objects.requireNonNull(SpaceContext.getActiveSpace(), MailController.m_pj((Object)"6d\u0004w\u00004\u0016|\na\tpEv\u00004\u0015f\u0000g\u0000z\u0011")));
        }
    }

    public void setSpace(Space space) {
        SpaceBaseModel a = space;
        SpaceBaseModel a2 = this;
        a2.space = a;
    }

    public SpaceBaseModel() {
        SpaceBaseModel a;
    }
}

