/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.f4b6a3.uuid.UuidCreator;
import com.inscada.mono.cluster.d.c_il;
import com.inscada.mono.shared.aspects.SetSpaceIdAspect;
import jakarta.persistence.Column;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.util.Date;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@MappedSuperclass
@EntityListeners(value={AuditingEntityListener.class, c_il.class})
@FilterDef(name="softDeleteFilter", defaultCondition="deleted_dttm IS NULL")
@Filter(name="softDeleteFilter")
public abstract class BaseModel {
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @LastModifiedBy
    @Column(name="version_user")
    protected String lastModifiedBy;
    public static final String SOFT_DELETE_FILTER_DEFAULT_CONDITION = "deleted_dttm IS NULL";
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @CreatedBy
    @Column(name="insert_user", updatable=false)
    protected String createdBy;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @CreatedDate
    @Column(name="insert_dttm", updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date creationDate;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Version
    @Column(name="version")
    private Long version;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Column(name="deleted_user")
    private String deletedBy;
    public static final String SOFT_DELETE_FILTER_NAME = "softDeleteFilter";
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Column(name="deleted_dttm")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deletedDate;
    @Id
    @Column(name="id", updatable=false, nullable=false, length=36)
    protected String id;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @LastModifiedDate
    @Column(name="version_dttm")
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date lastModifiedDate;

    public Date getLastModifiedDate() {
        BaseModel a;
        return a.lastModifiedDate;
    }

    public void setCreatedBy(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.createdBy = a;
    }

    @PreRemove
    private /* synthetic */ void preventHardDelete() {
        throw new UnsupportedOperationException(SetSpaceIdAspect.m_af((Object)"\u0017Q-T\u007fT:\\:D:\u00106C\u007f^0D\u007fQ3\\0G:Tq\u0010\u000f\\:Q,U\u007fE,U\u007fD7U\u007fB:@0C6D0B&\u0017,\u0010;U3U+U\u007f]:D7_;\u00109_-\u0010,_9D\u007fT:\\:D6_1\u001e"));
    }

    public String getLastModifiedBy() {
        BaseModel a;
        return a.lastModifiedBy;
    }

    public Date getDeletedDate() {
        BaseModel a;
        return a.deletedDate;
    }

    public void setLastModifiedBy(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.lastModifiedBy = a;
    }

    public void setLastModifiedDate(Date date) {
        Object a = date;
        BaseModel a2 = this;
        a2.lastModifiedDate = a;
    }

    public void setCreationDate(Date date) {
        Object a = date;
        BaseModel a2 = this;
        a2.creationDate = a;
    }

    public void setDeletedDate(Date date) {
        Object a = date;
        BaseModel a2 = this;
        a2.deletedDate = a;
    }

    public String getDeletedBy() {
        BaseModel a;
        return a.deletedBy;
    }

    public String getId() {
        BaseModel a;
        return a.id;
    }

    public Long getVersion() {
        BaseModel a;
        return a.version;
    }

    @PrePersist
    protected void onCreate() {
        BaseModel a;
        if (a.id == null) {
            a.id = UuidCreator.getTimeOrdered().toString();
        }
    }

    protected BaseModel() {
        BaseModel a;
    }

    public String getCreatedBy() {
        BaseModel a;
        return a.createdBy;
    }

    public void setId(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.id = a;
    }

    public void setVersion(Long l) {
        Object a = l;
        BaseModel a2 = this;
        a2.version = a;
    }

    public Date getCreationDate() {
        BaseModel a;
        return a.creationDate;
    }

    public void setDeletedBy(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.deletedBy = a;
    }
}

