/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.exceptions;

import com.inscada.mono.alarm.model.FiredAlarmList;
import com.inscada.mono.auth.exceptions.AuthTokenException;
import com.inscada.mono.auth.exceptions.RunAsExecutionException;
import com.inscada.mono.broadcast.exceptions.BroadcastOperationException;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.exceptions.CommunicationException;
import com.inscada.mono.communication.base.exceptions.SetValueException;
import com.inscada.mono.impexp.exceptions.ImportExportException;
import com.inscada.mono.report.exceptions.ReportGenerationException;
import com.inscada.mono.report.exceptions.ReportSchedulingException;
import com.inscada.mono.report.services.c_jB;
import com.inscada.mono.script.exceptions.ScriptException;
import com.inscada.mono.settings.exceptions.SettingsException;
import com.inscada.mono.shared.exceptions.AlreadyExistsException;
import com.inscada.mono.shared.exceptions.FileStorageException;
import com.inscada.mono.shared.exceptions.InscadaException;
import com.inscada.mono.shared.exceptions.MismatchException;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.exceptions.ParsingException;
import com.inscada.mono.shared.exceptions.RelationExistsException;
import com.inscada.mono.shared.exceptions.ValidationDefinitionException;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import com.inscada.mono.sms.exceptions.SmsProviderException;
import com.inscada.mono.space.exceptions.SpaceOperationException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.OptimisticLockException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.StaleObjectStateException;
import org.influxdb.InfluxDBMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.NonNull;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice(basePackages={"com.inscada.mono"})
public class GeneralExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String REPORT_GENERATION_ERROR = "Report Generation Error";
    private static final String CONSTRAINT_VIOLATION = "Constraint Violation";
    private final Environment environment;
    private static final String OPTIMISTIC_LOCK_ERROR = "Optimistic Lock Error";
    private static final String FILE_STORAGE_ERROR = "File Storage Error";
    private static final Logger log = LoggerFactory.getLogger(GeneralExceptionHandler.class);
    private static final String NOT_FOUND_ERROR = "Not Found Error";
    private static final String SETTINGS_ERROR = "Settings Error";
    private static final String SPACE_OPERATION_ERROR = "Space Operation Error";
    private static final String PARSING_ERROR = "Parsing Error";
    private static final String SECURITY_ERROR = "Security Error";
    private static final String SET_VALUE_ERROR = "Set Value Error";
    private static final String REPORT_SCHEDULING_ERROR = "Report Scheduling Error";
    private static final String COMMUNICATION_ERROR = "Communication Error";
    private static final String VALIDATION_ERROR = "Validation Error";
    private static final String NOT_ACTIVE_ERROR = "Not Active Error";
    private static final String UNKNOWN_ERROR = "Unknown Error";
    private static final String INSCADA_ERROR = "Inscada Error";
    private static final String ALREADY_EXISTS_ERROR = "Already Exists Error";
    private static final String VALIDATION_DEFINITION_ERROR = "Validation Definition Error";
    private static final String AUTH_TOKEN_ERROR = "Auth Token Error";
    private static final String IMPORT_EXPORT_ERROR = "Import/Export Error";
    private static final String BROWSE_OPERATION_ERROR = "Browse Operation Error";
    private static final String SMS_PROVIDER_ERROR = "SMS Provider Error";
    private static final String DATABASE_ERROR = "Database Error";
    private static final String BROADCAST_OPERATION_ERROR = "Broadcast Operation Error";
    private static final String RUN_AS_ERROR = "Run-As Execution Error";
    private static final String RELATION_EXISTS_ERROR = "Relation Exists Error";
    private static final String MISMATCH_ERROR = "Mismatch Error";
    private static final String SCRIPT_ERROR = "Script Execution Error";

    @ExceptionHandler(value={CommunicationException.class})
    protected ResponseEntity<Object> handleCommunicationException(CommunicationException communicationException) {
        GeneralExceptionHandler a = communicationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, COMMUNICATION_ERROR);
    }

    @ExceptionHandler(value={ReportGenerationException.class})
    protected ResponseEntity<Object> handleReportGenerationException(ReportGenerationException reportGenerationException) {
        GeneralExceptionHandler a = reportGenerationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_GENERATION_ERROR);
    }

    private /* synthetic */ boolean isSseRequest() {
        block5: {
            ServletRequestAttributes servletRequestAttributes;
            block4: {
                GeneralExceptionHandler generalExceptionHandler = this;
                try {
                    servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                    if (servletRequestAttributes != null) break block4;
                    return false;
                }
                catch (Exception exception) {
                    return (2 & 5) != 0;
                }
            }
            HttpServletRequest httpServletRequest = servletRequestAttributes.getRequest();
            String string = httpServletRequest.getHeader(FiredAlarmList.m_HKa((Object)"/\u0006\r\u0000\u001e\u0011"));
            String a = httpServletRequest.getHeader("Content-Type");
            if ((string == null || !string.contains(c_jB.m_YG((Object)"/a#pta-a5pvw/v>e6"))) && (a == null || !a.contains(FiredAlarmList.m_HKa((Object)"\u0011\u000b\u001d\u001aJ\u000b\u0013\u000b\u000b\u001aH\u001d\u0011\u001c\u0000\u000f\b")))) break block5;
            return true;
        }
        return false;
    }

    @ExceptionHandler(value={ParsingException.class})
    protected ResponseEntity<Object> handleParsingException(ParsingException parsingException) {
        GeneralExceptionHandler a = parsingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, PARSING_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2) {
        Object a;
        void a2;
        void a3;
        void a4;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler a5 = generalExceptionHandler;
        return a5.createExceptionDetails((HttpStatusCode)a4, (String)a3, (Exception)a2, (String)a, null);
    }

    @ExceptionHandler(value={RunAsExecutionException.class})
    protected ResponseEntity<Object> handleRunAsExecution(RunAsExecutionException runAsExecutionException) {
        GeneralExceptionHandler a = runAsExecutionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, RUN_AS_ERROR);
    }

    @ExceptionHandler(value={AuthTokenException.class})
    protected ResponseEntity<Object> handleAuthTokenException(AuthTokenException authTokenException) {
        GeneralExceptionHandler a = authTokenException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, AUTH_TOKEN_ERROR);
    }

    @ExceptionHandler(value={RelationExistsException.class})
    protected ResponseEntity<Object> handleRelationExists(RelationExistsException relationExistsException) {
        GeneralExceptionHandler a = relationExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, RELATION_EXISTS_ERROR);
    }

    @ExceptionHandler(value={AccessDeniedException.class, BadCredentialsException.class})
    protected ResponseEntity<Object> handleSecurityExceptions(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.FORBIDDEN, SECURITY_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleExceptionInternal(Exception exception, Object object, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void status;
        GeneralExceptionHandler generalExceptionHandler = exception2;
        Exception exception2 = exception;
        GeneralExceptionHandler ex = generalExceptionHandler;
        if (ex.isSseRequest() && (ex.isClientAbort((Throwable)exception2) || exception2 instanceof HttpMessageNotReadableException || exception2 instanceof HttpMessageNotWritableException)) {
            log.warn(FiredAlarmList.m_HKa((Object)"6= N\f\u0000\u0011\u000b\u0017\u0000\u0004\u0002E\u000b\u0017\u001c\n\u001cE\u001d\u0010\u001e\u0015\u001c\u0000\u001d\u0016\u000b\u0001TE\u0015\u0018"), (Object)exception2.getMessage());
            return ResponseEntity.noContent().build();
        }
        ExceptionDetails body = ex.createExceptionDetails((HttpStatusCode)status, exception2.getMessage(), exception2, UNKNOWN_ERROR);
        log.error(c_jB.m_YG((Object)"M5p>v5e7$>v)k)>{\u007f&"), (Object)body, (Object)exception2);
        return new ResponseEntity((Object)body, (HttpStatusCode)status);
    }

    private /* synthetic */ boolean isClientAbort(Throwable throwable) {
        Throwable a = throwable;
        GeneralExceptionHandler a2 = this;
        Throwable throwable2 = a;
        while (throwable2 != null) {
            String string;
            if (a instanceof ClientAbortException) {
                return 3 >> 1;
            }
            if (a instanceof IOException && (string = a.getMessage()) != null && ((string = string.toLowerCase(Locale.ROOT)).contains(c_jB.m_YG((Object)"9v4o>j{t2t>")) || string.contains(FiredAlarmList.m_HKa((Object)"\r\n\u0000\u000b\u000b\u0006\u001a\f\u0001\u000bN\u0017\u000b\u0016\u000b\u0011")) || string.contains(c_jB.m_YG((Object)":f4v/a?$9}{p3a{w4b/s:v>")))) {
                return true;
            }
            throwable2 = a.getCause();
        }
        return false;
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    protected ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException methodArgumentTypeMismatchException) {
        GeneralExceptionHandler a = methodArgumentTypeMismatchException;
        GeneralExceptionHandler a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[2 & 5] = a.getName();
        objectArray[4 ^ 5] = a.getValue();
        objectArray[5 >> 1] = a.getRequiredType() != null ? a.getRequiredType().getSimpleName() : c_jB.m_YG((Object)".j0j4s5");
        String string = FiredAlarmList.m_HKa((Object)">\u0004\u001c\u0004\u0003\u0000\u001a\u0000\u001cEI@\u001dBN\u0012\u0007\u0011\u0006E\u0018\u0004\u0002\u0010\u000bEI@\u001dBN\u0006\u0001\u0010\u0002\u0001N\u000b\u0001\u0011N\u0007\u000bE\r\n\u0000\u0013\u000b\u0017\u001a\u0000\nE\u001a\nN\u0011\u0017\u0015\u000bEI@\u001dB").formatted(objectArray);
        return a2.buildErrorResponse((Exception)a, string, (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }

    private /* synthetic */ String formatErrorMessages(Map<String, List<String>> map) {
        Map<String, List<String>> a2 = map;
        GeneralExceptionHandler a3 = this;
        return a2.entrySet().stream().map(a -> (String)a.getKey() + ": " + String.join((CharSequence)FiredAlarmList.m_HKa((Object)"BE"), (Iterable)a.getValue())).collect(Collectors.joining(FiredAlarmList.m_HKa((Object)"E\u0012E")));
    }

    @ExceptionHandler(value={FileStorageException.class})
    protected ResponseEntity<Object> handleFileStorage(FileStorageException fileStorageException) {
        GeneralExceptionHandler a = fileStorageException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, FILE_STORAGE_ERROR);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    protected ResponseEntity<Object> handleDataIntegrityViolation(DataIntegrityViolationException dataIntegrityViolationException) {
        GeneralExceptionHandler a = dataIntegrityViolationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, ExceptionUtils.getRootCauseMessage((Throwable)generalExceptionHandler), (HttpStatusCode)HttpStatus.CONFLICT, DATABASE_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    @ExceptionHandler(value={TransactionSystemException.class})
    protected ResponseEntity<Object> handleTransactionSystemException(TransactionSystemException transactionSystemException) {
        void a;
        GeneralExceptionHandler generalExceptionHandler = this;
        Object a2 = a.getRootCause();
        if (a2 instanceof ConstraintViolationException) {
            a2 = (ConstraintViolationException)a2;
            return generalExceptionHandler.handleConstraintViolation((ConstraintViolationException)a2);
        }
        void v0 = a;
        return generalExceptionHandler.buildErrorResponse((Exception)v0, ExceptionUtils.getRootCauseMessage((Throwable)v0), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ResponseEntity<Object> buildErrorResponse(Exception exception, String string, HttpStatusCode httpStatusCode, String string2) {
        void a;
        void a2;
        void a3;
        Object a4 = string;
        GeneralExceptionHandler a5 = this;
        a4 = a5.createExceptionDetails((HttpStatusCode)a3, (String)a4, (Exception)a2, (String)a, null);
        log.error(FiredAlarmList.m_HKa((Object)"'\u000b\u001a\u0000\u001c\u000b\u000f\tN\u0000\u001c\u0017\u0001\u0017TE\u0015\u0018"), a4, (Object)a2);
        return new ResponseEntity(a4, (HttpStatusCode)a3);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    protected ResponseEntity<Object> handleIllegalState(IllegalStateException illegalStateException) {
        IllegalStateException a = illegalStateException;
        GeneralExceptionHandler a2 = this;
        IllegalStateException illegalStateException2 = a;
        return a2.buildErrorResponse((Exception)illegalStateException2, illegalStateException2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }

    @ExceptionHandler(value={AlreadyExistsException.class})
    protected ResponseEntity<Object> handleAlreadyExists(AlreadyExistsException alreadyExistsException) {
        GeneralExceptionHandler a = alreadyExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, ALREADY_EXISTS_ERROR);
    }

    private /* synthetic */ String getCurrentPath() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getRequestURI();
        }
        catch (Exception exception) {
            return c_jB.m_YG((Object)"t:p3+.j0j4s5");
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String sanitizeMessage(String string, Exception exception) {
        void a;
        Object a2 = exception;
        GeneralExceptionHandler a3 = this;
        if (a2 instanceof ScriptException) {
            return a;
        }
        if (a3.isDevelopment()) {
            return a;
        }
        if (a2 instanceof AlreadyExistsException) {
            return FiredAlarmList.m_HKa((Object)"7\u000b\u0016\u0001\u0010\u001c\u0006\u000bE\u000f\t\u001c\u0000\u000f\u0001\u0017E\u000b\u001d\u0007\u0016\u001a\u0016");
        }
        if (a2 instanceof FileStorageException) {
            return c_jB.m_YG((Object)"\u001dm7a{k+a)e/m4j{b:m7a?");
        }
        if (a2 instanceof MismatchException) {
            return FiredAlarmList.m_HKa((Object)"7\u000b\u0016\u0001\u0010\u001c\u0006\u000bE\u0003\f\u001d\b\u000f\u0011\r\r");
        }
        if (a2 instanceof NotActiveException) {
            return c_jB.m_YG((Object)"V>w4q)g>$2w{j4p{e8p2r>");
        }
        if (a2 instanceof NotFoundException) {
            return FiredAlarmList.m_HKa((Object)"<\u0000\u001d\n\u001b\u0017\r\u0000N\u000b\u0001\u0011N\u0003\u0001\u0010\u0000\u0001");
        }
        if (a2 instanceof RelationExistsException) {
            return c_jB.m_YG((Object)"\ta7e/a?$)a(k.v8a{a#m(p(");
        }
        if (a2 instanceof OptimisticLockException || a2 instanceof StaleObjectStateException) {
            return FiredAlarmList.m_HKa((Object)"<\u0000\u001d\n\u001b\u0017\r\u0000N\u0012\u000f\u0016N\u0010\u001e\u0001\u000f\u0011\u000b\u0001N\u0007\u0017E\u000f\u000b\u0001\u0011\u0006\u0000\u001cE\u001b\u0016\u000b\u0017");
        }
        if (a2 instanceof SmsProviderException) {
            return c_jB.m_YG((Object)"W\u0016W{w>v-m8a{k+a)e/m4j{b:m7a?");
        }
        if (a2 instanceof SettingsException) {
            return FiredAlarmList.m_HKa((Object)"/\u0015\u001e\t\u0007\u0006\u000f\u0011\u0007\n\u0000E\u001d\u0000\u001a\u0011\u0007\u000b\t\u0016N\u0000\u001c\u0017\u0001\u0017");
        }
        if (a2 instanceof ParsingException) {
            return c_jB.m_YG((Object)"\u0012j-e7m?$?e/e{b4v6e/");
        }
        if (a2 instanceof ValidationDefinitionException) {
            return FiredAlarmList.m_HKa((Object)",\u0000\u0011\u000b\u0017\u0000\u0004\u0002E\u0018\u0004\u0002\f\n\u0004\u001a\f\u0001\u000bN\u0006\u0001\u000b\b\f\t\u0010\u001c\u0004\u001a\f\u0001\u000bN\u0000\u001c\u0017\u0001\u0017");
        }
        if (a2 instanceof BrowseOperationException) {
            return c_jB.m_YG((Object)"\u001aj{a)v4v{k8g.v)a?$?q)m5c{e{f)k,w>$4t>v:p2k5");
        }
        if (a2 instanceof SetValueException) {
            return FiredAlarmList.m_HKa((Object)"$\u0000E\u000b\u0017\u001c\n\u001cE\u0001\u0006\r\u0010\u001c\u0017\u000b\u0001N\u0012\u0006\f\u0002\u0000N\u0016\u000b\u0011\u001a\f\u0000\u0002N\u0004N\u0013\u000f\t\u001b\u0000");
        }
        if (a2 instanceof CommunicationException) {
            return c_jB.m_YG((Object)"\u0018k6i.j2g:p2k5$8k5b2c.v:p2k5$>v)k)");
        }
        if (a2 instanceof RunAsExecutionException) {
            return FiredAlarmList.m_HKa((Object)"$\u0000E\u0007\u000b\u001a\u0000\u001c\u000b\u000f\tN\n\u001e\u0000\u001c\u0004\u001a\f\u0001\u000bN\u0003\u000f\f\u0002\u0000\nE\n\u0010\u001c\f\u0000\u0002N\u0000\u0016\u0000\r\u0010\u001a\f\u0001\u000b");
        }
        if (a2 instanceof SpaceOperationException) {
            return c_jB.m_YG((Object)"\bt:g>$4t>v:p2k5$=e2h>`{`.a{p4$:$9q(m5a(w{v.h>$-m4h:p2k5");
        }
        if (a2 instanceof ImportExportException) {
            return FiredAlarmList.m_HKa((Object)"$\u0000E\u000b\u0017\u001c\n\u001cE\u0001\u0006\r\u0010\u001c\u0017\u000b\u0001N\u0001\u001b\u0017\u0007\u000b\tE\n\u0004\u001a\u0004N\f\u0003\u0015\u0001\u0017\u001aJ\u000b\u001d\u001e\n\u001c\u0011");
        }
        if (a2 instanceof ReportGenerationException) {
            return c_jB.m_YG((Object)"E5$>v)k)$4g8q)v>`{`.v2j<$)a+k)p{c>j>v:p2k5");
        }
        if (a2 instanceof ReportSchedulingException) {
            return FiredAlarmList.m_HKa((Object)"/\u000bN\u0000\u001c\u0017\u0001\u0017N\n\r\u0006\u001b\u0017\u001c\u0000\nE\n\u0010\u001c\f\u0000\u0002N\u0017\u000b\u0015\u0001\u0017\u001aE\u001d\u0006\u0006\u0000\n\u0010\u0002\f\u0000\u0002");
        }
        if (a2 instanceof BroadcastOperationException) {
            return c_jB.m_YG((Object)"E5$>v)k)$4g8q)v>`{`.v2j<$:$9v4e?g:w/$4t>v:p2k5");
        }
        if (a2 instanceof AuthTokenException) {
            return FiredAlarmList.m_HKa((Object)"/\u000bN\u0004\u001b\u0011\u0006\u0000\u0000\u0011\u0007\u0006\u000f\u0011\u0007\n\u0000E\u001a\n\u0005\u0000\u0000E\u000b\u0017\u001c\n\u001cE\u0001\u0006\r\u0010\u001c\u0017\u000b\u0001");
        }
        if (a2 instanceof DataIntegrityViolationException) {
            return c_jB.m_YG((Object)"\u001fe/e9e(a{g4j(p)e2j/$-m4h:p2k5");
        }
        if (a2 instanceof TransactionSystemException) {
            return FiredAlarmList.m_HKa((Object)"*\u0004\u001a\u0004\f\u0004\u001d\u0000N\u0011\u001c\u0004\u0000\u0016\u000f\u0006\u001a\f\u0001\u000bN\u0000\u001c\u0017\u0001\u0017");
        }
        if (a2 instanceof InfluxDBMapperException) {
            return c_jB.m_YG((Object)"P2i>$(a)m>w{`:p:f:w>$>v)k)");
        }
        if (a2 instanceof SecurityException || a2 instanceof AccessDeniedException || a2 instanceof BadCredentialsException) {
            return FiredAlarmList.m_HKa((Object)"$\r\u0006\u000b\u0016\u001dE\n\u0000\u0000\f\u000b\u0001");
        }
        if (a2 instanceof MethodArgumentNotValidException || a2 instanceof IllegalArgumentException) {
            return c_jB.m_YG((Object)"\u0012j-e7m?$2j+q/");
        }
        if (a2 instanceof ConstraintViolationException) {
            return FiredAlarmList.m_HKa((Object)"3\u000f\t\u0007\u0001\u000f\u0011\u0007\n\u0000E\r\n\u0000\u0016\u001a\u0017\u000f\f\u0000\u0011N\u0013\u0007\n\u0002\u0004\u001a\f\u0001\u000b");
        }
        if (a2 instanceof HttpMessageNotReadableException) {
            return c_jB.m_YG((Object)"M5r:h2`{v>u.a(p{b4v6e/");
        }
        if (a2 instanceof MissingServletRequestParameterException) {
            return FiredAlarmList.m_HKa((Object)"#\f\u001d\u0016\u0007\u000b\tE\u001c\u0000\u001f\u0010\u0007\u0017\u000b\u0001N\u0015\u000f\u0017\u000f\b\u000b\u0011\u000b\u0017");
        }
        if (a2 instanceof IllegalStateException) {
            return c_jB.m_YG((Object)"\u0012j-e7m?$:t+h2g:p2k5$(p:p>");
        }
        return FiredAlarmList.m_HKa((Object)"/\u000bN\u0010\u0000\u0000\u0016\u0015\u000b\u0006\u001a\u0000\nE\u000b\u0017\u001c\n\u001cE\u0001\u0006\r\u0010\u001c\u0017\u000b\u0001");
    }

    @ExceptionHandler(value={SpaceOperationException.class})
    protected ResponseEntity<Object> handleSpaceOperationException(SpaceOperationException spaceOperationException) {
        GeneralExceptionHandler a = spaceOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SPACE_OPERATION_ERROR);
    }

    @ExceptionHandler(value={SmsProviderException.class})
    protected ResponseEntity<Object> handleSmsProviderException(SmsProviderException smsProviderException) {
        GeneralExceptionHandler a = smsProviderException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SMS_PROVIDER_ERROR);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    protected ResponseEntity<Object> handleIllegalArgument(IllegalArgumentException illegalArgumentException) {
        IllegalArgumentException a = illegalArgumentException;
        GeneralExceptionHandler a2 = this;
        IllegalArgumentException illegalArgumentException2 = a;
        return a2.buildErrorResponse((Exception)illegalArgumentException2, illegalArgumentException2.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }

    @ExceptionHandler(value={SettingsException.class})
    protected ResponseEntity<Object> handleSettingsException(SettingsException settingsException) {
        GeneralExceptionHandler a = settingsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SETTINGS_ERROR);
    }

    @ExceptionHandler(value={ScriptException.class})
    protected ResponseEntity<Object> handleScriptException(ScriptException scriptException) {
        GeneralExceptionHandler a = scriptException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SCRIPT_ERROR);
    }

    @ExceptionHandler(value={NotFoundException.class, EntityNotFoundException.class})
    protected ResponseEntity<Object> handleEntityNotFound(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND, NOT_FOUND_ERROR);
    }

    @ExceptionHandler(value={ImportExportException.class})
    protected ResponseEntity<Object> handleImportExportException(ImportExportException importExportException) {
        GeneralExceptionHandler a = importExportException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, IMPORT_EXPORT_ERROR);
    }

    @ExceptionHandler(value={OptimisticLockException.class, StaleObjectStateException.class})
    protected ResponseEntity<Object> handleOptimisticLock(Exception exception) {
        Object a = exception;
        GeneralExceptionHandler a2 = this;
        return a2.buildErrorResponse((Exception)a, FiredAlarmList.m_HKa((Object)":\r\u0007\u0016N\u0017\u000b\u0006\u0001\u0017\nE\u0019\u0004\u001dE\u001b\u0015\n\u0004\u001a\u0000\nE\f\u001cN\u0004\u0000\n\u001a\r\u000b\u0017N\u0010\u001d\u0000\u001cKN5\u0002\u0000\u000f\u0016\u000bE\u001c\u0000\b\u0017\u000b\u0016\u0006E\u0017\n\u001b\u0017N\u0001\u000f\u0011\u000fE\u000f\u000b\nE\u001a\u0017\u0017E\u000f\u0002\u000f\f\u0000K"), (HttpStatusCode)HttpStatus.CONFLICT, OPTIMISTIC_LOCK_ERROR);
    }

    @ExceptionHandler(value={InfluxDBMapperException.class})
    protected ResponseEntity<Object> handleInfluxDBMapper(InfluxDBMapperException influxDBMapperException) {
        GeneralExceptionHandler a = influxDBMapperException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleAllExceptions(Exception exception) {
        Exception a = exception;
        Object a2 = this;
        if (a2.isSseRequest() && (a2.isClientAbort((Throwable)a) || a instanceof HttpMessageNotReadableException || a instanceof HttpMessageNotWritableException)) {
            log.warn(c_jB.m_YG((Object)"W\bA{v>u.a(p{a)v4v{w.t+v>w(a?>{\u007f&"), (Object)a.getMessage());
            return ResponseEntity.noContent().build();
        }
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, UNKNOWN_ERROR);
    }

    @ExceptionHandler(value={NotActiveException.class})
    protected ResponseEntity<Object> handleNotActive(NotActiveException notActiveException) {
        GeneralExceptionHandler a = notActiveException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, NOT_ACTIVE_ERROR);
    }

    @ExceptionHandler(value={MismatchException.class})
    protected ResponseEntity<Object> handleMismatch(MismatchException mismatchException) {
        GeneralExceptionHandler a = mismatchException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, MISMATCH_ERROR);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException missingServletRequestParameterException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = missingServletRequestParameterException;
        GeneralExceptionHandler ex = generalExceptionHandler;
        Object[] objectArray = new Object[1 ^ 3];
        objectArray[5 >> 3] = generalExceptionHandler2.getParameterName();
        objectArray[3 >> 1] = generalExceptionHandler2.getParameterType();
        ExceptionDetails headers = ex.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, FiredAlarmList.m_HKa((Object)"7\u000b\u0014\u001b\f\u001c\u0000\nE\u001e\u0004\u001c\u0004\u0003\u0000\u001a\u0000\u001cEI@\u001dBN\n\bE\u001a\u001c\u001e\u0000NBK\u0016IE\u0007\u0016N\b\u0007\u0016\u001d\f\u0000\u0002").formatted(objectArray), (Exception)generalExceptionHandler2, VALIDATION_ERROR);
        log.error(c_jB.m_YG((Object)"\u0016m(w2j<$+e)e6a/a)>{\u007f&"), (Object)headers, (Object)generalExceptionHandler2);
        return new ResponseEntity((Object)headers, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={BrowseOperationException.class})
    protected ResponseEntity<Object> handleBrowseOperationException(BrowseOperationException browseOperationException) {
        GeneralExceptionHandler a = browseOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROWSE_OPERATION_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException methodArgumentNotValidException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        object = new HashMap();
        Map status = ex.getBindingResult().getFieldErrors().stream().collect(Collectors.groupingBy(FieldError::getField, Collectors.mapping(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return c_jB.m_YG((Object)"J4$6a(w:c>$:r:m7e9h>");
        }, Collectors.toList())));
        List a = ex.getBindingResult().getGlobalErrors().stream().map(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return c_jB.m_YG((Object)"J4$6a(w:c>$:r:m7e9h>");
        }).collect(Collectors.toList());
        object.putAll(status);
        if (!a.isEmpty()) {
            object.put(FiredAlarmList.m_HKa((Object)"\t\t\u0001\u0007\u000f\t"), a);
        }
        object = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, headers.formatErrorMessages((Map)object), (Exception)ex, VALIDATION_ERROR, (Map)object);
        log.error(c_jB.m_YG((Object)"R:h2`:p2k5$>v)k)>{\u007f&"), object, (Object)ex);
        return new ResponseEntity(object, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={BroadcastOperationException.class})
    protected ResponseEntity<Object> handleBroadcastOperationException(BroadcastOperationException broadcastOperationException) {
        GeneralExceptionHandler a = broadcastOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROADCAST_OPERATION_ERROR);
    }

    @ExceptionHandler(value={ReportSchedulingException.class})
    protected ResponseEntity<Object> handleReportSchedulingException(ReportSchedulingException reportSchedulingException) {
        GeneralExceptionHandler a = reportSchedulingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_SCHEDULING_ERROR);
    }

    @ExceptionHandler(value={SetValueException.class})
    protected ResponseEntity<Object> handleSetValueException(SetValueException setValueException) {
        GeneralExceptionHandler a = setValueException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SET_VALUE_ERROR);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    protected ResponseEntity<Object> handleConstraintViolation(ConstraintViolationException constraintViolationException) {
        GeneralExceptionHandler a2 = constraintViolationException;
        GeneralExceptionHandler a3 = this;
        Map map = a2.getConstraintViolations().stream().collect(Collectors.groupingBy(a -> a.getPropertyPath().toString(), Collectors.mapping(ConstraintViolation::getMessage, Collectors.toList())));
        GeneralExceptionHandler generalExceptionHandler = a3;
        a2 = generalExceptionHandler.createExceptionDetails((HttpStatusCode)HttpStatus.CONFLICT, generalExceptionHandler.formatErrorMessages(map), (Exception)a2, CONSTRAINT_VIOLATION, map);
        log.error(c_jB.m_YG((Object)"G4j(p)e2j/$-m4h:p2k5>{\u007f&"), (Object)a2);
        return new ResponseEntity((Object)a2, (HttpStatusCode)HttpStatus.CONFLICT);
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException httpMessageNotReadableException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        generalExceptionHandler2 = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, "Malformed JSON request: " + ex.getMessage(), (Exception)ex, VALIDATION_ERROR);
        log.error(FiredAlarmList.m_HKa((Object)"#\u0000\u001d\u0016\u000f\u0002\u000bE\u0000\n\u001aE\u001c\u0000\u000f\u0001\u000f\u0007\u0002\u0000TE\u0015\u0018"), (Object)generalExceptionHandler2, (Object)ex);
        return new ResponseEntity((Object)generalExceptionHandler2, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ValidationDefinitionException.class})
    protected ResponseEntity<Object> handleValidationDefinitionException(ValidationDefinitionException validationDefinitionException) {
        GeneralExceptionHandler a = validationDefinitionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, VALIDATION_DEFINITION_ERROR);
    }

    private /* synthetic */ boolean isDevelopment() {
        String[] stringArray = this;
        String[] a = stringArray.environment.getActiveProfiles();
        if (a.length == 0) {
            return (3 ^ 3) != 0;
        }
        return Arrays.asList(a).contains(c_jB.m_YG((Object)"?a-"));
    }

    public GeneralExceptionHandler(Environment environment) {
        GeneralExceptionHandler a = environment;
        GeneralExceptionHandler a2 = this;
        a2.environment = a;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2, Map<String, List<String>> map) {
        void a;
        void a2;
        Object a3;
        void a4;
        String a5;
        GeneralExceptionHandler a6;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler generalExceptionHandler2 = a6 = generalExceptionHandler;
        a5 = generalExceptionHandler2.sanitizeMessage(a5, (Exception)a4);
        String string3 = generalExceptionHandler2.isDevelopment() ? a4.getClass().getName() : c_jB.m_YG((Object)"\u001e|8a+p2k5");
        Object object2 = a6.isDevelopment() ? a3 : FiredAlarmList.m_HKa((Object)" \u001c\u0017\u0001\u0017");
        return new ExceptionDetails(a2.value(), a5, string3, (String)object2, (Map)a, (String)(a3 = a6.isDevelopment() ? ExceptionUtils.getStackTrace((Throwable)a4) : null), new Date(), a6.getCurrentPath());
    }

    @ExceptionHandler(value={InscadaException.class})
    protected ResponseEntity<Object> handleInscadaException(InscadaException inscadaException) {
        GeneralExceptionHandler a = inscadaException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }
}

