/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.services;

import com.inscada.mono.auth.c_yK;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.manager.LeaderFencedManager;
import com.inscada.mono.cluster.services.c_C;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.y.c_XB;
import com.inscada.mono.license.model.LicenseActivationRequest;
import com.inscada.mono.log.d.c_dA;
import com.inscada.mono.project.d.c_k;
import com.inscada.mono.project.model.ProjectStatus;
import com.inscada.mono.script.d.c_WB;
import com.inscada.mono.script.d.c_cc;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.script.model.Script;
import com.inscada.mono.script.services.c_OA;
import com.inscada.mono.script.services.c_cb;
import com.inscada.mono.script.services.c_wb;
import com.inscada.mono.script.y.c_DC;
import com.inscada.mono.script.y.c_SA;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ScriptManager
extends LeaderFencedManager
implements c_k {
    private static final Logger f_bc = LoggerFactory.getLogger(ScriptManager.class);
    public static final short f_Nb = 303;
    private final c_yK f_ic;
    private final c_wb f_PC;
    public static final short f_nc = 302;
    private final c_dA f_Rb;
    private final c_cb f_pd;
    public static final short f_AA = 306;
    private static final String f_uc = "scheduled_scripts";
    private final c_XB f_dd;
    private final Map<String, Job> f_sA;
    public static final short f_VC = 307;
    public static final short f_CA = 305;
    public static final short f_jA = 304;
    public static final short f_VA = 301;
    private final Lock f_XA;
    private final JedisPooled f_SB;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader(long l) {
        ScriptManager scriptManager;
        ScriptManager scriptManager2 = scriptManager = this;
        String a = scriptManager2.f_pC.m_la();
        f_bc.info(ProjectStatus.m_VK((Object)"\u0005;$1&,\u001b9891=$bv\f>1%x872=vp-%\u007fx>9%x4=57;=v,>=v\u0014\u0013\u0019\u0012\u001d\u0004vv\n3+\"7$18?v+503<#43<v+5*?(\"+xvx"), (Object)a);
        scriptManager2.f_XA.lock();
        try {
            HashSet hashSet = new HashSet(scriptManager.f_SB.smembers(f_uc));
            if (hashSet.isEmpty()) {
                f_bc.info(LicenseActivationRequest.m_rk((Object)"spRzPgmrNrGvR3\b_ErDvR3[n\t)\u0000]O3SpHvDfLvD3SpRzPgS3F|U}D3I}\u0000AEwI`\u0000gO3RvSgOaE="), (Object)a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[--1] = hashSet.size();
            objectArray[--2] = hashSet;
            f_bc.info(ProjectStatus.m_VK((Object)"\u000b5*?(\"\u0015767?3*vp\u001a=7<3*v#+qlx\u00107#62x-%v+503<#43<v+5*?(\"x\u001f\u001c%x?6v\n3<?+v,9x$=%,9*3bv#+"), objectArray);
            ArrayList a2 = new ArrayList();
            String[] stringArray = new String[--1];
            stringArray[3 & 4] = LicenseActivationRequest.m_rk((Object)"EiVwLsPrZpG");
            scriptManager.f_ic.m_UEa(() -> {
                void a;
                Object a2 = hashSet;
                ScriptManager a3 = this;
                a.addAll(a3.f_pd.m_NF((Set)a2));
            }, stringArray);
            f_bc.info(ProjectStatus.m_VK((Object)"\u000b5*?(\"\u0015767?3*vp\u001a=7<3*v#+qlx\u0017,\"=;(\"18?v,9x$=%,9*3x-%v+5*?(\"+x"), (Object)a, (Object)a2.size());
            a2.forEach(repeatableScript -> {
                void a;
                ScriptManager scriptManager;
                ScriptManager scriptManager2 = scriptManager = this;
                Object a2 = scriptManager2.f_pC.m_la();
                String[] stringArray = new String[1 ^ 3];
                stringArray[3 >> 2] = LicenseActivationRequest.m_rk((Object)"@c[eWu_eLsPrZpG");
                stringArray[2 ^ 3] = ProjectStatus.m_VK((Object)"\u0015\u0019\u0018\u001b\u0013\u0014\t\u000b\u0015\n\u001f\b\u0002");
                scriptManager2.f_ic.m_aga(() -> scriptManager.lambda$restoreSingleScriptOnLeader$1((String)a2, (RepeatableScript)a), a.getSpace(), stringArray);
            });
            f_bc.info(LicenseActivationRequest.m_rk((Object)"@CaIcT^A}AtEa\u0000;lvAwEa\u0000h]:\u001a3fzNzS{Ew\u0000`CaIcT3RvSgOaAgI|N3PaOpE`S="), (Object)a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[--2] = exception;
            f_bc.error(ProjectStatus.m_VK((Object)"\u000b5*?(\"\u0015767?3*vp\u001a=7<3*v#+qlx\u0013*$7$x2-$18?v+5*?(\"x$=%,9*7,?78x&*9;3+%bv#+"), objectArray);
            return;
        }
        finally {
            scriptManager.f_XA.unlock();
        }
    }

    protected c_SA getScriptStatusInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_sA.containsKey(a)) {
            return c_SA.f_nb;
        }
        return c_SA.f_yc;
    }

    private /* synthetic */ void lambda$scheduleScriptInternal$4(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_XA.lock();
        try {
            Job job;
            ScriptManager scriptManager;
            block14: {
                a2.cancelScriptInternal((RepeatableScript)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to schedule script " + a.getName());
                }
                switch (c_OA.f_vC[a.getType().ordinal()]) {
                    case 1: {
                        ScriptManager scriptManager2 = a2;
                        while (false) {
                        }
                        scriptManager = scriptManager2;
                        job = scriptManager2.createDailyScriptJob((RepeatableScript)a);
                        break block14;
                    }
                    case 2: {
                        ScriptManager scriptManager3 = a2;
                        scriptManager = scriptManager3;
                        job = scriptManager3.createPeriodicScriptJob((RepeatableScript)a);
                        break block14;
                    }
                    case 3: {
                        job = a2.createOnceScriptJob((RepeatableScript)a);
                        break;
                    }
                    case 4: {
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown schedule type of " + String.valueOf(a.getType()));
                    }
                }
                scriptManager = a2;
            }
            scriptManager.f_sA.put(a.getId(), job);
            String[] stringArray = new String[2 ^ 3];
            stringArray[3 >> 2] = a.getId();
            a2.f_SB.sadd(f_uc, stringArray);
            return;
        }
        finally {
            a2.f_XA.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public ScriptManager(c_cb c_cb2, c_XB c_XB2, c_wb c_wb2, c_dA c_dA2, JedisPooled jedisPooled, c_C c_C2, c_yK c_yK2) {
        ScriptManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ScriptManager a8;
        ScriptManager scriptManager = scriptManager2;
        ScriptManager scriptManager2 = c_yK2;
        ScriptManager scriptManager3 = a8 = scriptManager;
        ScriptManager scriptManager4 = a8;
        ScriptManager scriptManager5 = a8;
        super((c_C)a7);
        ScriptManager scriptManager6 = a8;
        a8.f_XA = new ReentrantLock();
        scriptManager6.f_sA = new ConcurrentHashMap();
        scriptManager5.f_pd = a6;
        scriptManager5.f_dd = a5;
        scriptManager4.f_PC = a4;
        scriptManager4.f_Rb = a3;
        scriptManager3.f_SB = a2;
        scriptManager3.f_ic = a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_SA getScriptStatus(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(ProjectStatus.m_VK((Object)"\u001a\u001d\u0017\u001c\u0013\nlx\u0011=\",?61x%;$1&,v+\"9\"-%x07$x-%v49;74:!x"), a);
            return a2.getScriptStatusInternal((String)a);
        }
        f_bc.debug(LicenseActivationRequest.m_rk((Object)"]o]\r_eRdVr)\u0000AEbUvSgI}G3LvAwEa\u0000uOa\u0000`CaIcT3SgAgU`\u0000uOa\u0000h]="), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[2 & 5] = a;
            return (c_SA)a2.f_pC.m_Fa(Short.valueOf((short)(0x45BF & 0x3B6F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get script status for " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ String generateJobName(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        Object[] objectArray = new Object[1 ^ 3];
        objectArray[3 & 4] = a.getType().m_OI();
        objectArray[3 & 5] = a.getName();
        return LicenseActivationRequest.m_rk((Object)"\u0005`\u0000@CaIcT3\r3\u0005`").formatted(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Job createDailyScriptJob(RepeatableScript repeatableScript) {
        String string;
        void a;
        ScriptManager scriptManager = this;
        Object a2 = a.getTime();
        a2 = LocalTime.of(((Date)a2).getHours(), ((Date)a2).getMinutes(), ((Date)a2).getSeconds());
        ScriptManager scriptManager2 = scriptManager;
        String string2 = string = scriptManager2.generateJobName((RepeatableScript)a);
        return scriptManager2.f_dd.m_qm(a.getProject(), string2, scriptManager.fenced(string2, () -> scriptManager.lambda$createDailyScriptJob$8((RepeatableScript)a)), (LocalTime)a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<String, c_SA> getScriptStatuses(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(LicenseActivationRequest.m_rk((Object)"_eRdVr)\u0000TEgTzNt\u0000rL\u007f\u0000`CaIcT3SgAgU`E`\u0000uOa\u0000cR|JvCg\u0000h]3L|CrL\u007fY="), a);
            return a2.getScriptStatusesByProjectIdInternal((String)a);
        }
        f_bc.debug(ProjectStatus.m_VK((Object)"\u0018\u0017\u0018u\u001a\u001d\u0017\u001c\u0013\nlx\u0004='-3+\"18?v4392=$x07$x74:x%;$1&,v+\"9\"-%=%x07$x&*923;\"x-%x"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[2 & 5] = a;
            return (Map)a2.f_pC.m_Fa(Short.valueOf((short)(0x4BB3 & 0x357F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_WB.class})
    public void handleCancelEvent(c_WB c_WB2) {
        void a;
        ScriptManager scriptManager = this;
        if (scriptManager.f_pC.m_ma()) {
            ScriptManager a2 = a.m_mH();
            f_bc.info(ProjectStatus.m_VK((Object)"\u0014\u0013\u0019\u0012\u001d\u0004bv\u00107624?61x\u001598;34\u0013.36\"x07$x%;$1&,lx-%vp\u001f\u001clx-%\u007f"), (Object)a2.getName(), (Object)a2.getId());
            scriptManager.cancelScriptInternal((RepeatableScript)a2);
            return;
        }
        f_bc.debug(LicenseActivationRequest.m_rk((Object)"]o]\r_eRdVr)\u0000ZG}OaI}G3crNpE\u007feeE}T3F|R3SpRzPg\u001a3[n"), (Object)a.m_mH().getId());
    }

    protected void cancelScriptsByProjectIdInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if ((a = a2.f_pd.m_gE((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelScriptInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleScriptOnLeader$1(String string, RepeatableScript repeatableScript) {
        void a;
        ScriptManager a2 = repeatableScript;
        ScriptManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[--1] = a2.getName();
            objectArray[--2] = a2.getId();
            f_bc.info(ProjectStatus.m_VK((Object)"\u000b5*?(\"\u0015767?3*vp\u001a=7<3*v#+qlx\u0004=%,9*?61x%;$1&,lx-%vp\u001f\u001clx-%\u007f"), objectArray);
            a3.scheduleScriptInternal((RepeatableScript)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[--2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_Rb.m_AK(a2.getProject()).m_V("Script Restore (Leader " + (String)a + ")", LicenseActivationRequest.m_rk((Object)"\u0005`\u0000;iW\u001a3\u0005`\t3FrI\u007fEw\u0000gO3RvSgOaE=\u0000PAfSv\u001a3\u0005`").formatted(objectArray));
            try {
                f_bc.warn(ProjectStatus.m_VK((Object)"\u000b5*?(\"\u0015767?3*vp\u001a=7<3*v#+qlx\u0017,\"=;(\"18?v,9x598;34v+5*?(\"x-%v90,3*v*3+\"7$9\"196v>71:-$=x"), (Object)a, (Object)a2.getId());
                a3.cancelScriptInternal((RepeatableScript)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[5 >> 3] = a;
                objectArray2[--1] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_bc.error(LicenseActivationRequest.m_rk((Object)"@CaIcT^A}AtEa\u0000;lvAwEa\u0000h]:\u001a3frI\u007fEw\u0000gO3CrNpE\u007f\u0000`CaIcT3[n\u0000rFgEa\u0000aE`T|RrTzO}\u0000uAzLfRv\u001a3[n"), objectArray2);
                return;
            }
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ScriptManager a;
        a.registerRemoteCallsWithClusterNode();
        f_bc.info(LicenseActivationRequest.m_rk((Object)"spRzPgmrNrGvR3I}IgIrLzZvD3A}D3RvGzSgEaEw\u0000rS3c\u007fU`TvR]OwE_I`TvNvR="));
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<String, c_SA> getScriptStatuses(List<String> list) {
        List<String> a = list;
        ScriptManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_pC.m_ma()) {
            f_bc.debug(ProjectStatus.m_VK((Object)"\u0014\u0013\u0019\u0012\u001d\u0004bv\u001f3,\"18?v+5*?(\"x%,7,#+3+v>9*v#+x\u001f\u001c%x:759:4/bv#+"), (Object)a.size(), (Object)a);
            return a2.getScriptStatusesByIdsInternal((List)a);
        }
        f_bc.debug(LicenseActivationRequest.m_rk((Object)"n\\n>lVaWeA\u001a3rvQfE`TzNt\u0000\u007fErDvR3F|R3SpRzPg\u0000`TrTfSvS3F|R3[n\u0000Zd`\u001a3[n"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = new ArrayList(a);
            return (Map)a2.f_pC.m_Fa(Short.valueOf((short)(0xF7A & 0x71B7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get script statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(ProjectStatus.m_VK((Object)"z"))), (Throwable)exception);
        }
    }

    private /* synthetic */ Job createPeriodicScriptJob(RepeatableScript repeatableScript) {
        String string;
        ScriptManager a;
        ScriptManager a2 = repeatableScript;
        ScriptManager scriptManager = a = this;
        String string2 = string = scriptManager.generateJobName((RepeatableScript)a2);
        return scriptManager.f_dd.m_gm(a2.getProject(), string2, a.fenced(string2, () -> a.lambda$createPeriodicScriptJob$7((RepeatableScript)a2)), Duration.ofMillis(a2.getPeriod().intValue()), a2.getOffset());
    }

    protected Map<String, c_SA> getScriptStatusesByProjectIdInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if ((a = a2.f_pd.m_qF((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(RepeatableScriptSummary::getId, repeatableScriptSummary -> {
            ScriptManager a = repeatableScriptSummary;
            ScriptManager a2 = this;
            return a2.getScriptStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScripts(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(ProjectStatus.m_VK((Object)"\u0014\u0013\u0019\u0012\u001d\u0004bv\u001b765=:4?61x74:x%;$1&,%x07$x&*923;\"x-%v49;74:!x"), a);
            a2.cancelScriptsByProjectIdInternal((String)a);
            return;
        }
        f_bc.debug(LicenseActivationRequest.m_rk((Object)"]o]\r_eRdVr)\u0000AEbUvSgI}G3LvAwEa\u0000gO3CrNpE\u007f\u0000rL\u007f\u0000`CaIcT`\u0000uOa\u0000cR|JvCg\u0000h]="), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x11FB & 0x6F35)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel scripts for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(String string, String string2) {
        void a;
        ScriptManager a2;
        Object a3 = string2;
        ScriptManager scriptManager = a2 = this;
        scriptManager.scheduleScript(scriptManager.f_pd.m_HE((String)a, (String)a3).getId());
    }

    protected void scheduleScriptInternal(String string) {
        ScriptManager a;
        Object a2 = string;
        ScriptManager scriptManager = a = this;
        scriptManager.scheduleScriptInternal(scriptManager.f_pd.m_jF((String)a2));
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ScriptManager scriptManager = this;
        try {
            Class[] classArray = new Class[4 ^ 5];
            classArray[2 & 5] = String.class;
            scriptManager.f_pC.m_Da((short)(0x57ED & 0x293F), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(ProjectStatus.m_VK((Object)"+503<#43\u000b5*?(\"\u00118,3*89:"), classArray));
            Class[] classArray2 = new Class[4 ^ 5];
            classArray2[3 ^ 3] = String.class;
            scriptManager.f_pC.m_Da((short)(0x5FE & 0x7B2F), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(LicenseActivationRequest.m_rk((Object)"CrNpE\u007fspRzPgi}TvR}A\u007f"), classArray2));
            Class[] classArray3 = new Class[4 ^ 5];
            classArray3[3 >> 2] = String.class;
            scriptManager.f_pC.m_Da((short)(0x71FF & 0xF2F), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(ProjectStatus.m_VK((Object)"1=\"\u000b5*?(\"\u000b\"9\"-%\u00118,3*89:"), classArray3));
            Class[] classArray4 = new Class[3 & 5];
            classArray4[2 & 5] = String.class;
            scriptManager.f_pC.m_Da((short)(0x59FF & 0x2730), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(LicenseActivationRequest.m_rk((Object)"SpHvDfLvspRzPgSQYCR|JvCgiwi}TvR}A\u007f"), classArray4));
            Class[] classArray5 = new Class[3 & 5];
            classArray5[5 >> 3] = String.class;
            scriptManager.f_pC.m_Da((short)(0x7535 & 0xBFB), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(ProjectStatus.m_VK((Object)";765=:\u000b5*?(\"+\u0014!\u0006*923;\"\u00112\u00118,3*89:"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            scriptManager.f_pC.m_Da((short)(0x3D32 & 0x43FF), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(LicenseActivationRequest.m_rk((Object)"GvT@CaIcT@TrTfSvSQYZD`i}TvR}A\u007f"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            scriptManager.f_pC.m_Da((short)(0x3337 & 0x4DFB), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(ProjectStatus.m_VK((Object)"?3,\u0005;$1&,\u0005,7,#+3+\u0014!\u0006*923;\"\u00112\u00118,3*89:"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(LicenseActivationRequest.m_rk((Object)"frI\u007fEw\u0000gO3RvGzSgEa\u0000@CaIcT^A}AtEa\u0000ApP\u0000~EgH|D`"), a);
        }
    }

    private /* synthetic */ void lambda$cancelScriptInternal$9(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_XA.lock();
        try {
            Job job = (Job)a2.f_sA.get(a.getId());
            if (job != null) {
                a2.f_dd.m_Em(job);
            }
            ScriptManager scriptManager = a2;
            scriptManager.f_sA.remove(a.getId());
            String[] stringArray = new String[--1];
            stringArray[3 >> 2] = a.getId();
            scriptManager.f_SB.srem(f_uc, stringArray);
            return;
        }
        finally {
            a2.f_XA.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$createOnceScriptJob$6(RepeatableScript repeatableScript) {
        void a;
        ScriptManager scriptManager = this;
        ScriptManager a2 = Script.newBuilder((RepeatableScript)a).build();
        scriptManager.f_PC.m_xh((Script)a2);
        scriptManager.cancelScript(a.getId());
    }

    @TransactionalEventListener(value={c_cc.class})
    public void handleRescheduleEvent(c_cc c_cc2) {
        ScriptManager scriptManager = this;
        if (scriptManager.f_pC.m_ma()) {
            ScriptManager a = a.m_ah();
            f_bc.info(ProjectStatus.m_VK((Object)"\u0014\u0013\u0019\u0012\u001d\u0004bv\u00107624?61x\u0004=%;>=2-:=\u0013.36\"x07$x%;$1&,lx-%vp\u001f\u001clx-%\u007f"), (Object)a.getName(), (Object)a.getId());
            if (scriptManager.getScriptStatusInternal(a.getId()) == c_SA.f_nb) {
                scriptManager.scheduleScriptInternal(a.getId());
                return;
            }
        } else {
            f_bc.debug(LicenseActivationRequest.m_rk((Object)"]o]\r_eRdVr)\u0000ZG}OaI}G3rvSpHvDfLveeE}T3F|R3SpRzPg\u001a3[n"), (Object)a.m_ah().getId());
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.info(ProjectStatus.m_VK((Object)"\u0014\u0013\u0019\u0012\u001d\u0004bv\u00107624?61x\u0006*923;\"\u001c395,?.7,3\u001d =8,v>9*v($7<=5,v\u0011\u0012bv#+"), a);
            a2.cancelScriptsByProjectIdInternal((String)a);
            return;
        }
        f_bc.debug(LicenseActivationRequest.m_rk((Object)"n\\n>lVaWeA\u001a3itN|RzNt\u0000CR|JvCgdvApTzVrTveeE}T3F|R3PaOyEpT3iW\u001a3[n"), a);
    }

    protected void cancelScriptInternal(String string) {
        ScriptManager a;
        Object a2 = string;
        ScriptManager scriptManager = a = this;
        scriptManager.cancelScriptInternal(scriptManager.f_pd.m_jF((String)a2));
    }

    protected void scheduleScriptsByProjectIdInternal(String string) {
        Object a2 = string;
        ScriptManager a3 = this;
        if ((a2 = a3.f_pd.m_gE((String)a2)) == null || a2.isEmpty()) {
            return;
        }
        a2.stream().filter(a -> {
            if (a.getType() != c_DC.f_EB) {
                return (4 ^ 5) != 0;
            }
            return false;
        }).forEach(arg_0 -> a3.scheduleScriptInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(String string, String string2) {
        void a;
        ScriptManager a2;
        Object a3 = string2;
        ScriptManager scriptManager = a2 = this;
        scriptManager.cancelScript(scriptManager.f_pd.m_HE((String)a, (String)a3).getId());
    }

    private /* synthetic */ Job createOnceScriptJob(RepeatableScript repeatableScript) {
        String string;
        ScriptManager a;
        ScriptManager a2 = repeatableScript;
        ScriptManager scriptManager = a = this;
        String string2 = string = scriptManager.generateJobName((RepeatableScript)a2);
        return scriptManager.f_dd.m_Om(a2.getProject(), string2, a.fenced(string2, () -> a.lambda$createOnceScriptJob$6((RepeatableScript)a2)), Duration.ofMillis(a2.getDelay().intValue()), 3 >> 2);
    }

    protected Map<String, c_SA> getScriptStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        ScriptManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getScriptStatusInternal(arg_0)));
    }

    protected void cancelScriptInternal(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_ic.m_mEa(() -> a2.lambda$cancelScriptInternal$9((RepeatableScript)a), (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScripts(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(LicenseActivationRequest.m_rk((Object)"lVaWeA\u001a3spHvDfLzNt\u0000rL\u007f\u0000`CaIcT`\u0000uOa\u0000cR|JvCg\u0000h]3L|CrL\u007fY="), a);
            a2.scheduleScriptsByProjectIdInternal((String)a);
            return;
        }
        f_bc.debug(ProjectStatus.m_VK((Object)"\u0018\u0017\u0018u\u001a\u001d\u0017\u001c\u0013\nlx\u0004='-3+\"18?v4392=$x\"7v+503<#43x74:x%;$1&,%x07$x&*923;\"x-%x"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x49F8 & 0x3737)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule scripts for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_SA getScriptStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ScriptManager a3 = this;
        if ((a2 = a3.f_pd.m_UE((String)a2, (String)a)) == null) {
            return c_SA.f_yc;
        }
        return a3.getScriptStatus(a2.getId());
    }

    protected void scheduleScriptInternal(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_ic.m_mEa(() -> a2.lambda$scheduleScriptInternal$4((RepeatableScript)a), (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(LicenseActivationRequest.m_rk((Object)"_eRdVr)\u0000@C{EwU\u007fI}G3SpRzPg\u0000h]3L|CrL\u007fY="), a);
            a2.scheduleScriptInternal((String)a);
            return;
        }
        f_bc.debug(ProjectStatus.m_VK((Object)"\u0016\u0019\u0016{\u0014\u0013\u0019\u0012\u001d\u0004bv\n3)#=%,?61x:=7<3*v,9x%;>=2-:=v+5*?(\"x-%x"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x21AD & 0x5F7F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule script " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        ScriptManager scriptManager = this;
        ScriptManager a22 = (Job)scriptManager.f_sA.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_bc.info(ProjectStatus.m_VK((Object)"\u0005;$1&,\u001b9891=$x~\u00169,v\u0014392=$x-%\u007fbv\u001b765=:4?61x:759:x<74x07$x%;$1&,v\u0011\u0012bv#+"), (Object)a3, (Object)a);
                scriptManager.f_dd.m_Em((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[5 >> 3] = a3;
                objectArray[--1] = a;
                objectArray[--2] = a22.getMessage();
                objectArray[--3] = a22;
                f_bc.error(LicenseActivationRequest.m_rk((Object)"spRzPgmrNrGvR3\b]Og\u0000_ErDvR3[n\t)\u0000VRaOa\u0000pA}CvL\u007fI}G3L|CrL3J|B3F|R3SpRzPg\u0000Zd3[n\u001a3[n"), objectArray);
            }
        }
    }

    public void notLeader() {
        ScriptManager scriptManager;
        ScriptManager scriptManager2 = scriptManager = this;
        Object a = scriptManager2.f_pC.m_la();
        f_bc.info(LicenseActivationRequest.m_rk((Object)"spRzPgmrNrGvR)\u0000GHzS3N|Dv\u0000;[n\t3I`\u0000]o3l\\nTeA\u0000GhV\u0000_eRdVr=\u0000PA}CvL\u007fI}G3A\u007fL3L|CrL3SpRzPg\u0000yOqS=\u000e="), a);
        scriptManager2.f_XA.lock();
        try {
            new ArrayList(scriptManager.f_sA.keySet()).forEach(arg_0 -> scriptManager.lambda$notLeader$2((String)a, arg_0));
            scriptManager.f_sA.clear();
            f_bc.info(ProjectStatus.m_VK((Object)"\u0005;$1&,\u001b9891=$x~\u00169,v\u0014392=$x-%\u007fbv\u0019:4v49;74v+5*?(\"x<74+v07.3x4=36v*3)#=%,3<v,9x598;34v98<v;:=7*3<v>$7;x:759:x\"*7;=18?x"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[3 & 5] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_bc.error(LicenseActivationRequest.m_rk((Object)"@CaIcT^A}AtEa\u0000;n|T3lvAwEa\u0000h]:\u001a3eaR|R3DfRzNt\u0000cR|CvS`\u0000|F3CrNpE\u007fLzNt\u0000\u007fOpA\u007f\u0000`CaIcT3J|B`\u001a3[n"), objectArray);
            return;
        }
        finally {
            scriptManager.f_XA.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(ProjectStatus.m_VK((Object)"\u001a\u001d\u0017\u001c\u0013\nlx\u001598;34:18?v+5*?(\"x-%v49;74:!x"), a);
            a2.cancelScriptInternal((String)a);
            return;
        }
        f_bc.debug(LicenseActivationRequest.m_rk((Object)"n\\n>lVaWeA\u001a3rvQfE`TzNt\u0000\u007fErDvR3T|\u0000pA}CvL3SpRzPg\u0000h]="), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x97F & 0x77AE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel script " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$createDailyScriptJob$8(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a = Script.newBuilder((RepeatableScript)a).build();
        a2.f_PC.m_xh((Script)a);
    }

    private /* synthetic */ void lambda$createPeriodicScriptJob$7(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a = Script.newBuilder((RepeatableScript)a).build();
        a2.f_PC.m_xh((Script)a);
    }
}

