/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableView;
import com.inscada.mono.communication.base.y.c_Pk;
import com.inscada.mono.report.model.ReportSubgroup;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="report_variable")
@AttributeOverride(name="id", column=@Column(name="report_variable_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"subgroupId", "reportSubgroup"}), @CheckAtLeastOneNotNull(fieldNames={"variableId", "variable"})})
public class ReportVariable
extends SpaceBaseModel {
    @NotBlank
    @Size(max=100)
    private String name;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="variable_id", insertable=false, updatable=false)
    private VariableView variable;
    @Column(name="report_subgroup_id", insertable=false, updatable=false)
    private String subgroupId;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="deviation_calc_report_variable_id")
    private ReportVariable deviationCalcReportVariable;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="report_subgroup_id")
    private ReportSubgroup reportSubgroup;
    @NotNull
    @Min(value=1L)
    @Column(name="variable_order")
    private Short variableOrder;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="deviation_variable_id", insertable=false, updatable=false)
    private VariableView deviationVariable;
    @Column(name="total_variable_id")
    private String totalVariableId;
    @Column(name="deviation_variable_id")
    private String deviationVariableId;
    @Size(max=50)
    private String pattern;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="total_variable_id", insertable=false, updatable=false)
    private VariableView totalVariable;
    @NotNull
    @Column(name="calc_type")
    private c_Pk calcType;
    @Column(name="deviation_calc_report_variable_id", insertable=false, updatable=false)
    private String deviationCalcReportVariableId;
    @Column(name="variable_id")
    private String variableId;
    @Size(max=255)
    @Column
    private String dsc;
    @Column(name="total_calc_type")
    private c_Pk totalCalcType;

    public void setSubgroupId(String string) {
        Object a = string;
        ReportVariable a2 = this;
        a2.subgroupId = a;
    }

    public void setDeviationCalcReportVariable(ReportVariable reportVariable) {
        ReportVariable a;
        ReportVariable a2 = reportVariable;
        ReportVariable reportVariable2 = a = this;
        reportVariable2.deviationCalcReportVariable = a2;
        reportVariable2.deviationCalcReportVariableId = a2 != null ? a2.getId() : null;
    }

    @JsonSetter
    public void setDeviationVariable(VariableView variableView) {
        ReportVariable a = variableView;
        ReportVariable a2 = this;
        a2.deviationVariable = a;
        if (a2.deviationVariable != null) {
            a2.deviationVariableId = a.getId();
            return;
        }
        a2.deviationVariableId = null;
    }

    public String getTotalVariableId() {
        ReportVariable a;
        return a.totalVariableId;
    }

    public String getVariableId() {
        ReportVariable a;
        return a.variableId;
    }

    public ReportVariable getDeviationCalcReportVariable() {
        ReportVariable a;
        return a.deviationCalcReportVariable;
    }

    public void setTotalVariable(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.totalVariableId = a.getId();
            variable2.totalVariable = VariableView.from(a);
            return;
        }
        a2.totalVariableId = null;
        a2.totalVariable = null;
    }

    public void setVariable(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.variableId = a.getId();
            variable2.variable = VariableView.from(a);
            return;
        }
        a2.variableId = null;
        a2.variable = null;
    }

    public c_Pk getTotalCalcType() {
        ReportVariable a;
        return a.totalCalcType;
    }

    public void setCalcType(c_Pk c_Pk2) {
        ReportVariable a = c_Pk2;
        ReportVariable a2 = this;
        a2.calcType = a;
    }

    public void setReportSubgroup(ReportSubgroup reportSubgroup) {
        ReportVariable a;
        ReportVariable a2 = reportSubgroup;
        ReportVariable reportVariable = a = this;
        reportVariable.reportSubgroup = a2;
        reportVariable.subgroupId = a2 != null ? a2.getId() : null;
    }

    public VariableView getTotalVariable() {
        ReportVariable a;
        return a.totalVariable;
    }

    public int hashCode() {
        ReportVariable a;
        Object[] objectArray = new Object[--3];
        objectArray[3 & 4] = super.hashCode();
        objectArray[5 >> 2] = a.getName();
        objectArray[1 ^ 3] = a.getSubgroupId();
        return Objects.hash(objectArray);
    }

    public String getName() {
        ReportVariable a;
        return a.name;
    }

    public c_Pk getCalcType() {
        ReportVariable a;
        return a.calcType;
    }

    public void setVariableId(String string) {
        Object a = string;
        ReportVariable a2 = this;
        a2.variableId = a;
    }

    public ReportVariable() {
        ReportVariable a;
    }

    public void setDeviationVariableId(String string) {
        Object a = string;
        ReportVariable a2 = this;
        a2.deviationVariableId = a;
    }

    public void setDeviationCalcReportVariableId(String string) {
        Object a = string;
        ReportVariable a2 = this;
        a2.deviationCalcReportVariableId = a;
    }

    public String getDeviationCalcReportVariableId() {
        ReportVariable a;
        return a.deviationCalcReportVariableId;
    }

    public String getDeviationVariableId() {
        ReportVariable a;
        return a.deviationVariableId;
    }

    public void setName(String string) {
        Object a = string;
        ReportVariable a2 = this;
        a2.name = a;
    }

    @JsonSetter
    public void setTotalVariable(VariableView variableView) {
        ReportVariable a = variableView;
        ReportVariable a2 = this;
        a2.totalVariable = a;
        if (a2.totalVariable != null) {
            a2.totalVariableId = a.getId();
            return;
        }
        a2.totalVariableId = null;
    }

    public Short getVariableOrder() {
        ReportVariable a;
        return a.variableOrder;
    }

    public void setDsc(String string) {
        Object a = string;
        ReportVariable a2 = this;
        a2.dsc = a;
    }

    public void setPattern(String string) {
        Object a = string;
        ReportVariable a2 = this;
        a2.pattern = a;
    }

    public void setDeviationVariable(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.deviationVariableId = a.getId();
            variable2.deviationVariable = VariableView.from(a);
            return;
        }
        a2.deviationVariableId = null;
        a2.deviationVariable = null;
    }

    public String getDsc() {
        ReportVariable a;
        return a.dsc;
    }

    public void setTotalCalcType(c_Pk c_Pk2) {
        ReportVariable a = c_Pk2;
        ReportVariable a2 = this;
        a2.totalCalcType = a;
    }

    public VariableView getDeviationVariable() {
        ReportVariable a;
        return a.deviationVariable;
    }

    public void setVariableOrder(Short s) {
        Object a = s;
        ReportVariable a2 = this;
        a2.variableOrder = a;
    }

    public String getSubgroupId() {
        ReportVariable a;
        return a.subgroupId;
    }

    public String getPattern() {
        ReportVariable a;
        return a.pattern;
    }

    @JsonSetter
    public void setVariable(VariableView variableView) {
        ReportVariable a = variableView;
        ReportVariable a2 = this;
        a2.variable = a;
        if (a2.variable != null) {
            a2.variableId = a.getId();
            return;
        }
        a2.variableId = null;
    }

    public VariableView getVariable() {
        ReportVariable a;
        return a.variable;
    }

    public ReportSubgroup getReportSubgroup() {
        ReportVariable a;
        return a.reportSubgroup;
    }

    public void setTotalVariableId(String string) {
        Object a = string;
        ReportVariable a2 = this;
        a2.totalVariableId = a;
    }

    public boolean equals(Object object) {
        ReportVariable a = this;
        Object a2 = object;
        if (a == a2) {
            return 5 >> 2;
        }
        if (!(a2 instanceof ReportVariable)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (2 & 5) != 0;
        }
        if (a.getName().equals(object2.getName()) && a.getSubgroupId().equals(object2.getSubgroupId())) {
            return (2 ^ 3) != 0;
        }
        return false;
    }
}

