/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.auth.c_yK;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.manager.LeaderFencedManager;
import com.inscada.mono.cluster.services.c_C;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueDto;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.services.c_nh;
import com.inscada.mono.communication.base.services.c_sg;
import com.inscada.mono.communication.base.services.c_si;
import com.inscada.mono.communication.base.y.c_Pk;
import com.inscada.mono.communication.base.y.c_vk;
import com.inscada.mono.datatransfer.d.c_AB;
import com.inscada.mono.datatransfer.d.c_ZB;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.model.DataTransferSummary;
import com.inscada.mono.datatransfer.services.c_Lc;
import com.inscada.mono.datatransfer.services.c_ub;
import com.inscada.mono.datatransfer.y.c_uB;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.y.c_XB;
import com.inscada.mono.log.d.c_dA;
import com.inscada.mono.project.d.c_k;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
extends LeaderFencedManager
implements c_k {
    private final c_si f_qi;
    private final c_XB f_LG;
    private final c_yK f_Fj;
    private final Map<String, Job> f_FH;
    public static final short f_Gi = 405;
    public static final short f_Ng = 407;
    private final c_sg f_oG;
    public static final short f_mh = 406;
    private static final String f_bh = "scheduledDataTransfers";
    public static final short f_tH = 402;
    private static final Logger f_bc = LoggerFactory.getLogger(DataTransferManager.class);
    public static final short f_Dj = 404;
    private final c_nh f_Qg;
    private final c_dA f_Zg;
    private final JedisPooled f_JG;
    public static final short f_WI = 403;
    public static final short f_ch = 401;
    private final Lock f_gi;
    private final c_Lc f_nI;

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_uB> getDataTransferStatuses(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_pC.m_ma()) {
            f_bc.debug(LoggedVariableValueDto.m_VCa((Object)"^{SzWl(\u001eU[fJ{Pu\u001ev_f_2J`_|Mt[`\u001eaJsJgMwM2X}L2Eo\u001e[za\u001e~Qq_~Rk\u00042Eo"), (Object)a.size(), (Object)a);
            return a2.getDataTransferStatusesByIdsInternal((List)a);
        }
        f_bc.debug(DataTransferSummary.m_AQ((Object)"AfA\u0004ClNmJ{5\t]L~\\jZ{@aN/EjHkL}\tiF}\tkH{H/]}HaZiL}\t|]n]zZjZ/O`[/Rr\tFm|\u0013/Rr"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = new ArrayList(a);
            return (Map)a2.f_pC.m_Fa(Short.valueOf((short)(0x19D6 & 0x67BF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(LoggedVariableValueDto.m_VCa((Object)">"))), (Throwable)exception);
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.info(DataTransferSummary.m_AQ((Object)"eJhKl]\u0013/anGkEfGh\t_[`CjJ{mjHl]f_n]jlyLa]/O`[/Y}FeLl]/`K\u0013/Rr"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_bc.debug(LoggedVariableValueDto.m_VCa((Object)"p]p?rW\u007fV{@\u00042wuP}L{Pu\u001eBL}Tw]fzw_qJ{HsJw{d[|J2X}L2N`Qx[qJ2wV\u00042Eo"), a);
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        DataTransferManager dataTransferManager = this;
        try {
            Class[] classArray = new Class[2 ^ 3];
            classArray[3 & 4] = String.class;
            dataTransferManager.f_pC.m_Da((short)(0x6BB7 & 0x15D9), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(LoggedVariableValueDto.m_VCa((Object)"MqVwZgRwzsJsj`_|Mt[`w|JwL|_~"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[3 >> 2] = String.class;
            dataTransferManager.f_pC.m_Da((short)(0x15D7 & 0x6BBA), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(DataTransferSummary.m_AQ((Object)"JnGlLcmn]n}}HaZiL}`a]j[aHc"), classArray2));
            Class[] classArray3 = new Class[--1];
            classArray3[3 >> 2] = String.class;
            dataTransferManager.f_pC.m_Da((short)(0x5BFF & 0x2593), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(LoggedVariableValueDto.m_VCa((Object)"u[fzsJsj`_|Mt[`mf_fKaw|JwL|_~"), classArray3));
            Class[] classArray4 = new Class[5 >> 2];
            classArray4[2 & 5] = String.class;
            dataTransferManager.f_pC.m_Da((short)(0x719C & 0xFF7), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(DataTransferSummary.m_AQ((Object)"ZlAjMzEjmn]n}}HaZiL}ZMP_[`CjJ{`k`a]j[aHc"), classArray4));
            Class[] classArray5 = new Class[2 ^ 3];
            classArray5[3 ^ 3] = String.class;
            dataTransferManager.f_pC.m_Da((short)(0x2B97 & 0x55FD), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(LoggedVariableValueDto.m_VCa((Object)"]sPq[~zsJsj`_|Mt[`MPGBL}Tw]fwvw|JwL|_~"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            dataTransferManager.f_pC.m_Da((short)(0x5FFF & 0x2196), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(DataTransferSummary.m_AQ((Object)"Nj]KH{H[[nG|Oj[\\]n]zZjZMPFM|`a]j[aHc"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            dataTransferManager.f_pC.m_Da((short)(0x33B7 & 0x4DDF), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(LoggedVariableValueDto.m_VCa((Object)"YwJV_f_FLsPaXwLAJsJgMwMPGBL}Tw]fwvw|JwL|_~"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(DataTransferSummary.m_AQ((Object)"on@cLk\t{F/[jNfZ{L}\tKH{H[[nG|Oj[BHaHhL}\t]yL\tbL{A`M|"), a);
        }
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$4(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.transfer((DataTransfer)a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$17(Date date, Map map, Map map2, Map map3, Date date2, List list) {
        void a;
        void a2;
        void a3;
        Map a4;
        void a5;
        List a6;
        DataTransferManager dataTransferManager = list2;
        List list2 = list;
        DataTransferManager a7 = dataTransferManager;
        String[] stringArray = (String[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(String[]::new);
        c_Pk[] c_PkArray = (c_Pk[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_Pk[]::new);
        a4 = a7.f_oG.m_zBa(stringArray, (Date)a5, (Date)((Object)a4), c_PkArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableId, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$16(a4, (Map)a3, (Map)a2, (Map)a, arg_0));
    }

    private /* synthetic */ void lambda$cancelDataTransferInternal$6(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_gi.lock();
        try {
            Job job = (Job)a2.f_FH.get(a.getId());
            if (job != null) {
                a2.f_LG.m_Em(job);
            }
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_FH.remove(a.getId());
            String[] stringArray = new String[--1];
            stringArray[3 ^ 3] = a.getId();
            dataTransferManager.f_JG.srem(f_bh, stringArray);
            return;
        }
        finally {
            a2.f_gi.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleStatValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_qi.m_ZCa((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        a3 = dataTransferManager.f_Qg.m_SAa((String[])a3.toArray(String[]::new));
        Date date = new Date();
        a2.stream().filter(arg_0 -> dataTransferManager.lambda$handleStatValues$12(date, map2, (Map)a, (Map)a3, arg_0)).collect(Collectors.groupingBy(dataTransferDetail -> {
            void a;
            DataTransferManager a2 = dataTransferDetail;
            DataTransferManager a3 = this;
            return (Date)a3.calculateDateRange((Date)a, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> dataTransferManager.lambda$handleStatValues$17(date, map2, (Map)a3, (Map)a, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleCurrentValues$10(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        void a2;
        VariableValue a3;
        Object a4 = map2;
        DataTransferManager a5 = this;
        a3 = (VariableValue)a3.get(a2.getSourceVariableId());
        a4 = (VariableValue)a4.get(a2.getTargetVariableId());
        a = (Variable)a.get(a2.getTargetVariableId());
        if (a3 != null && a != null && a5.isValueInThresholdRange(a2.getThreshold(), a3, (VariableValue)a4)) {
            void a6;
            a4 = new HashMap<String, Object>();
            a4.put(DataTransferSummary.m_AQ((Object)"yHc\\j"), a3.getValue());
            a6.put(a.getName(), a4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.cancelDataTransfer(dataTransferManager.f_nI.m_EM((String)a, (String)a3).getId());
    }

    protected void cancelDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_Fj.m_mEa(() -> a2.lambda$cancelDataTransferInternal$6((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_uB getDataTransferStatus(String string, String string2) {
        void a;
        Object a2 = string;
        DataTransferManager a3 = this;
        if ((a2 = a3.f_nI.m_Jm((String)a2, (String)a)) == null) {
            return c_uB.f_VG;
        }
        return a3.getDataTransferStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    public DataTransferManager(c_Lc c_Lc2, c_si c_si2, c_nh c_nh2, c_sg c_sg2, c_XB c_XB2, JedisPooled jedisPooled, c_dA c_dA2, c_C c_C2, c_yK c_yK2) {
        DataTransferManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        DataTransferManager a10;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = c_yK2;
        DataTransferManager dataTransferManager3 = a10 = dataTransferManager;
        DataTransferManager dataTransferManager4 = a10;
        DataTransferManager dataTransferManager5 = a10;
        DataTransferManager dataTransferManager6 = a10;
        super((c_C)a9);
        DataTransferManager dataTransferManager7 = a10;
        a10.f_gi = new ReentrantLock();
        dataTransferManager7.f_FH = new ConcurrentHashMap();
        dataTransferManager6.f_nI = a8;
        dataTransferManager6.f_qi = a7;
        dataTransferManager5.f_Qg = a6;
        dataTransferManager5.f_oG = a5;
        dataTransferManager4.f_LG = a4;
        dataTransferManager4.f_Zg = a3;
        dataTransferManager3.f_JG = a2;
        dataTransferManager3.f_Fj = a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_uB getDataTransferStatus(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(LoggedVariableValueDto.m_VCa((Object)"rW\u007fV{@\u00042ywJfW|Y2ZsJs\u001efLsPaXwL2Mf_fKa\u001etQ`\u001e[z(\u001eiC2R}]sR~G<"), a);
            return a2.getDataTransferStatusInternal((String)a);
        }
        f_bc.debug(DataTransferSummary.m_AQ((Object)"g@g\"eJhKl]\u0013/{jXzL|]fGh\tcLnMj[/O`[/Mn]n\t{[nG|Oj[/Z{H{\\|\tiF}\tFm5\ttT!"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[5 >> 3] = a;
            return (c_uB)a2.f_pC.m_Fa(Short.valueOf((short)(0x27B7 & 0x59DB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_ZB.class})
    public void handleCancelEvent(c_ZB c_ZB2) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_pC.m_ma()) {
            DataTransferManager a2 = a.m_tP();
            f_bc.info(DataTransferSummary.m_AQ((Object)"ClNmJ{5\tGHaMc@aN/jnGlLclyLa]/O`[/Mn]n\t{[nG|Oj[5\ttT/\u0001Fm5\ttT&"), (Object)a2.getName(), (Object)a2.getId());
            dataTransferManager.cancelDataTransferInternal((DataTransfer)a2);
            return;
        }
        f_bc.debug(LoggedVariableValueDto.m_VCa((Object)"p]p?rW\u007fV{@\u00042wuP}L{Pu\u001eQ_|]wRWHwPf\u001etQ`\u001ev_f_2J`_|Mt[`\u00042Eo"), (Object)a.m_tP().getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object object = (String[])a2.stream().map(DataTransferDetail::getSourceVariableId).toArray(String[]::new);
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_qi.m_ZCa((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        DataTransferManager dataTransferManager2 = dataTransferManager;
        object = dataTransferManager2.f_Qg.m_SAa(object);
        a3 = dataTransferManager2.f_Qg.m_SAa((String[])a3.toArray(String[]::new));
        a2.forEach(arg_0 -> dataTransferManager.lambda$handleCurrentValues$10((Map)object, (Map)a3, map2, (Map)a, arg_0));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(DataTransferSummary.m_AQ((Object)"eJhKl]\u0013/zlAjMzEfGh\tkH{H/]}HaZiL}\ttT/E`JnEcP!"), a);
            a2.scheduleDataTransferInternal((String)a);
            return;
        }
        f_bc.debug(LoggedVariableValueDto.m_VCa((Object)"\\q\\\u0013^{SzWl(\u001e@[cKwMfW|Y2Rw_v[`\u001efQ2MqVwZgRw\u001ev_f_2J`_|Mt[`\u001eiC<"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x43BD & 0x3DD3)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfer " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats loggedVariableValueStats, c_Pk c_Pk2) {
        void a;
        DataTransferManager a2 = loggedVariableValueStats;
        DataTransferManager a3 = this;
        switch (c_ub.f_di[a.ordinal()]) {
            case 1: {
                return a2.getMinValue();
            }
            case 2: {
                return a2.getMaxValue();
            }
            case 3: {
                return a2.getAvgValue();
            }
            case 4: {
                return a2.getSumValue();
            }
            case 5: {
                return a2.getCountValue();
            }
            case 6: {
                return a2.getFirstValue();
            }
            case 7: {
                return a2.getLastValue();
            }
            case 8: {
                return a2.getMaxDiffValue();
            }
            case 9: {
                return a2.getLastFirstDiffValue();
            }
            case 10: {
                return a2.getMiddleValue();
            }
            case 11: {
                return a2.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + String.valueOf(a));
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[2 & 5] = a.getSourceVariableId();
        objectArray[--1] = a.getRangeType();
        objectArray[5 >> 1] = a.getCalcType();
        return DataTransferSummary.m_AQ((Object)"kH{H\"]}HaZiL}\u0013|]n]|\u0013yH}@nKcL5\f|\u0013*Z5\f|").formatted(objectArray);
    }

    protected c_uB getDataTransferStatusInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_FH.containsKey(a)) {
            return c_uB.f_dh;
        }
        return c_uB.f_VG;
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_uB> getDataTransferStatuses(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(DataTransferSummary.m_AQ((Object)"eJhKl]\u0013/nj]{@aN/HcE/Mn]n\t{[nG|Oj[/Z{H{\\|L|\tiF}\t\u007f[`CjJ{\ttT/E`JnEcP!"), a);
            return a2.getDataTransferStatusesByProjectIdInternal((String)a);
        }
        f_bc.debug(LoggedVariableValueDto.m_VCa((Object)"p]p?rW\u007fV{@\u00042lwOg[aJ{Pu\u001e~[sZwL2X}L2_~R2ZsJs\u001efLsPaXwL2Mf_fKa[a\u001etQ`\u001ebL}Tw]f\u001eiC<"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_pC.m_Fa(Short.valueOf((short)(0x33BF & 0x4DD7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    protected void scheduleDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_nI.m_np((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_vk c_vk2) {
        DataTransferManager a = c_vk2;
        DataTransferManager a2 = this;
        switch (c_ub.f_sh[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a));
    }

    public void notLeader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_pC.m_la();
        f_bc.info(DataTransferSummary.m_AQ((Object)"KH{H[[nG|Oj[BHaHhL}\u0013/}g@|\taFkL/\u0001tT&\tfZ/g@\tCfAnJ{/}Gl/eJhKl]\u0007/jnGlLcEfGh\tnEc\tcFlHc\tkH{H/]}HaZiL}\teFmZ!\u0007!"), a);
        dataTransferManager2.f_gi.lock();
        try {
            new ArrayList(dataTransferManager.f_FH.keySet()).forEach(arg_0 -> dataTransferManager.lambda$notLeader$2((String)a, arg_0));
            dataTransferManager.f_FH.clear();
            f_bc.info(LoggedVariableValueDto.m_VCa((Object)"zsJsj`_|Mt[`ssPsYwL2\u0016\\Qf\u001e^[sZwL2Eo\u0017(\u001eSR~\u001e~Qq_~\u001ev_f_2J`_|Mt[`\u001exQpM2VsHw\u001ep[wP2LwOg[aJwZ2J}\u001eq_|]wR2_|Z2]~[sLwZ2X`Q\u007f\u001e~Qq_~\u001efLs]yW|Y<"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_bc.error(DataTransferSummary.m_AQ((Object)"mn]n}}HaZiL}dnGnNj[/\u0001AF{\tCLnMj[/Rr\u00005\tJ[}F}\tk\\}@aN/Y}FlL|Z/Fi\tlHaJjEc@aN/E`JnE/Mn]n\t{[nG|Oj[/C`K|\u0013/Rr"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_gi.unlock();
        }
    }

    protected void cancelDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_nI.m_IN((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void transfer(DataTransfer dataTransfer) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(dataTransferDetail -> {
            void a;
            List a2 = dataTransferDetail;
            List a3 = arrayList2;
            if (a2.getCalcType() != null && a2.getRangeType() != null) {
                a3.add(a2);
                return;
            }
            a.add(a2);
        });
        HashMap a2 = new HashMap();
        if (!arrayList.isEmpty()) {
            dataTransferManager.handleCurrentValues(arrayList, (Map)a2);
        }
        if (!arrayList2.isEmpty()) {
            dataTransferManager.handleStatValues(arrayList2, (Map)a2);
        }
        if (!a2.isEmpty()) {
            dataTransferManager.f_Qg.m_Sca(a.getProjectId(), (Map)a2);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(DataTransferSummary.m_AQ((Object)"eJhKl]\u0013/jnGlLcEfGh\tkH{H/]}HaZiL}\ttT/E`JnEcP!"), a);
            a2.cancelDataTransferInternal((String)a);
            return;
        }
        f_bc.debug(LoggedVariableValueDto.m_VCa((Object)"\\q\\\u0013^{SzWl(\u001e@[cKwMfW|Y2Rw_v[`\u001efQ2]sPq[~\u001ev_f_2J`_|Mt[`\u001eiC<"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x1F93 & 0x61FE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfer " + (String)a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_AB.class})
    public void handleRescheduleEvent(c_AB c_AB2) {
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_pC.m_ma()) {
            DataTransferManager a = a.m_Ar();
            f_bc.info(DataTransferSummary.m_AQ((Object)"ClNmJ{5\tGHaMc@aN/{jZlAjMzEjlyLa]/O`[/Mn]n\t{[nG|Oj[5\ttT/\u0001Fm5\ttT&"), (Object)a.getName(), (Object)a.getId());
            if (dataTransferManager.getDataTransferStatusInternal(a.getId()) == c_uB.f_dh) {
                dataTransferManager.scheduleDataTransferInternal(a.getId());
                return;
            }
        } else {
            f_bc.debug(LoggedVariableValueDto.m_VCa((Object)"p]p?rW\u007fV{@\u00042wuP}L{Pu\u001e@[a]z[vK~[WHwPf\u001etQ`\u001ev_f_2J`_|Mt[`\u00042Eo"), (Object)a.m_Ar().getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleDataTransferOnLeader$1(String string, DataTransfer dataTransfer) {
        void a;
        DataTransferManager a2 = dataTransfer;
        DataTransferManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[--1] = a2.getName();
            objectArray[5 >> 1] = a2.getId();
            f_bc.info(DataTransferSummary.m_AQ((Object)"KH{H[[nG|Oj[BHaHhL}\t'ejHkL}\ttT&\u0013/{jZ{F}@aN/Mn]n\t{[nG|Oj[5\ttT/\u0001Fm5\ttT&"), objectArray);
            a3.scheduleDataTransferInternal((DataTransfer)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_Zg.m_AK(a2.getProject()).m_V("Data Transfer Restore (Leader " + (String)a + ")", LoggedVariableValueDto.m_VCa((Object)"\u001ba\u001e:wV\u00042\u001ba\u00172XsW~[v\u001efQ2LwMfQ`[<\u001eQ_gMw\u00042\u001ba").formatted(objectArray));
            try {
                f_bc.warn(DataTransferSummary.m_AQ((Object)"KH{H[[nG|Oj[BHaHhL}\t'ejHkL}\ttT&\u0013/h{]jD\u007f]fGh\t{F/JnGlLc\tkH{H/]}HaZiL}\ttT/Hi]j[/[jZ{F}H{@`G/On@c\\}L!"), (Object)a, (Object)a2.getId());
                a3.cancelDataTransferInternal((DataTransfer)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[5 >> 3] = a;
                objectArray2[4 ^ 5] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_bc.error(LoggedVariableValueDto.m_VCa((Object)"zsJsj`_|Mt[`ssPsYwL2\u0016^[sZwL2Eo\u0017(\u001eT_{RwZ2J}\u001eq_|]wR2ZsJs\u001efLsPaXwL2Eo\u001esXf[`\u001e`[aJ}LsJ{Q|\u001et_{RgLw\u00042Eo"), objectArray2);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$16(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        DataTransferManager a2;
        Object a3;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = dataTransferDetail;
        DataTransferManager a4 = dataTransferManager;
        if ((a3 = (LoggedVariableValueStats)a3.get(a2.getSourceVariableId())) != null && (a = (Variable)a.get(a2.getTargetVariableId())) != null) {
            String a5;
            double d = a4.extractValue(a3, a2.getCalcType());
            a3 = (VariableValue)a5.get(a2.getTargetVariableId());
            DataTransferManager dataTransferManager3 = a4;
            a5 = dataTransferManager3.buildStatCacheKey((DataTransferDetail)a2);
            String string = dataTransferManager3.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            int n = dataTransferManager3.getMaxTTLForRangeType(a2.getRangeType());
            dataTransferManager3.f_JG.setex(a5, (long)n, String.valueOf(d));
            a4.f_JG.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager3.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(LoggedVariableValueDto.m_VCa((Object)"d_~Kw"), d);
                a6.put(a.getName(), a3);
            }
        }
    }

    protected Map<String, c_uB> getDataTransferStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$handleStatValues$12(Date date, Map map, Map map2, Map map3, DataTransferDetail dataTransferDetail) {
        void a;
        void a2;
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a3 = dataTransferManager2.buildStatCacheKey((DataTransferDetail)a2);
        if (!dataTransferManager2.shouldRecalculateStats((DataTransferDetail)a2, (Date)a, (String)(a3 = dataTransferManager2.f_JG.get((String)a3)))) {
            void a4;
            void a5;
            void a6;
            dataTransferManager.updateVariableWithCachedValue((String)a3, (DataTransferDetail)a2, (Map)a6, (Map)a5, (Map)a4);
            return 3 >> 2;
        }
        return true;
    }

    protected void scheduleDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_Fj.m_mEa(() -> a2.lambda$scheduleDataTransferInternal$5((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(DataTransferSummary.m_AQ((Object)"ClNmJ{5\t\\JgLk\\c@aN/HcE/Mn]n\t{[nG|Oj[|\tiF}\t\u007f[`CjJ{\ttT/E`JnEcP!"), a);
            a2.scheduleDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_bc.debug(LoggedVariableValueDto.m_VCa((Object)"p]p?rW\u007fV{@\u00042lwOg[aJ{Pu\u001e~[sZwL2J}\u001ea]z[vK~[2_~R2ZsJs\u001efLsPaXwLa\u001etQ`\u001ebL}Tw]f\u001eiC<"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x7DB6 & 0x3DD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, VariableValue<?> variableValue, VariableValue<?> variableValue2) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue2;
        VariableValue<?> a4 = this;
        if (a2 == null || a3 == null) {
            return true;
        }
        if (!(a instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d2 = ((Number)a.getValue()).doubleValue();
        double d3 = ((Number)a3.getValue()).doubleValue();
        double d4 = d2 == 0.0 ? Math.abs(d3 - d2) : Math.abs((d3 - d2) / d2 * 100.0);
        if (d4 >= a2.doubleValue()) {
            return 5 >> 2;
        }
        return false;
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(DataTransferSummary.m_AQ((Object)"ClNmJ{5\tLHaJjEc@aN/HcE/Mn]n\t{[nG|Oj[|\tiF}\t\u007f[`CjJ{\ttT/E`JnEcP!"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_bc.debug(LoggedVariableValueDto.m_VCa((Object)"p]p?rW\u007fV{@\u00042lwOg[aJ{Pu\u001e~[sZwL2J}\u001eq_|]wR2_~R2ZsJs\u001efLsPaXwLa\u001etQ`\u001ebL}Tw]f\u001eiC<"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x41FD & 0x3F97)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail dataTransferDetail, Date date, String string) {
        int n;
        void a;
        void a2;
        Object a222 = string;
        DataTransferManager a3 = this;
        if (a222 == null) {
            return (2 ^ 3) != 0;
        }
        a222 = Calendar.getInstance();
        String string2 = a3.f_JG.get(a3.buildStatLastCalcTimeKey((DataTransferDetail)a2));
        if (string2 == null) {
            return (4 ^ 5) != 0;
        }
        ((Calendar)a222).setTimeInMillis(Long.parseLong(string2));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)a);
        switch (c_ub.f_sh[a2.getRangeType().ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
            case 2: {
                int n2;
                if (((Calendar)a222).get(0xB & 0x7F) != calendar.get(0xB & 0x7F)) {
                    n2 = 3 >> 1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 3: 
            case 4: {
                int n2;
                if (((Calendar)a222).get(0x16 & 0x6F) != calendar.get(0x77 & 0xE)) {
                    n2 = 5 >> 2;
                    break;
                }
                n2 = 0;
                break;
            }
            case 5: 
            case 6: {
                int n2;
                if (((Calendar)a222).get(--3) != calendar.get(--3)) {
                    n2 = 3 & 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 7: 
            case 8: {
                int n2;
                if (((Calendar)a222).get(--2) != calendar.get(--2)) {
                    n2 = 3 & 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 9: 
            case 10: {
                int n2 = n = ((Calendar)a222).get(3 & 5) != calendar.get(2 ^ 3) ? 5 >> 2 : 0;
            }
        }
        if (n != 0) {
            DataTransferManager dataTransferManager = a3;
            a222 = dataTransferManager.buildStatCacheKey((DataTransferDetail)a2);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            String[] stringArray = new String[--2];
            stringArray[0] = a222;
            stringArray[1] = string3;
            dataTransferManager.f_JG.del(stringArray);
            return true;
        }
        if (!a2.getRangeType().toString().startsWith(DataTransferSummary.m_AQ((Object)"L\\}[jG{"))) {
            return false;
        }
        int a222 = switch (c_ub.f_sh[a2.getRangeType().ordinal()]) {
            case 1 -> 5;
            case 3 -> 5;
            case 5 -> 60;
            case 7 -> 720;
            case 9 -> 720;
            default -> throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a2.getRangeType()));
        };
        long l = a.getTime();
        long l2 = Long.parseLong(string2);
        return l - l2 >= (long)(a222 * (0x7D & 0x3E) * (0x6FFA & 0x13ED));
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        a.registerRemoteCallsWithClusterNode();
        f_bc.info(DataTransferSummary.m_AQ((Object)"mn]n}}HaZiL}dnGnNj[/@a@{@nEfSjM/HaM/[jNfZ{L}Lk\tnZ/jc\\|]j[AFkLC@|]jGj[!"));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, Double d2, VariableValue<?> variableValue) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue;
        VariableValue<?> a4 = this;
        return a4.isValueInThresholdRange((Double)a2, (VariableValue)new NumberVariableValue((Number)a, new Date()), a3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$scheduleDataTransferInternal$5(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_gi.lock();
        try {
            String string;
            a2.cancelDataTransferInternal((DataTransfer)a);
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to schedule data transfer " + a.getName());
            }
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 ^ 3] = a.getName();
            String string2 = string = LoggedVariableValueDto.m_VCa((Object)"\u001ba\u001eV_f_2j`_|Mt[`").formatted(objectArray);
            string = a2.f_LG.m_In(a.getProject(), string2, a2.fenced(string2, () -> a2.lambda$scheduleDataTransferInternal$4((DataTransfer)a)), Duration.ofMillis(a.getPeriod().intValue()));
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_FH.put(a.getId(), string);
            String[] stringArray = new String[5 >> 2];
            stringArray[5 >> 3] = a.getId();
            dataTransferManager.f_JG.sadd(f_bh, stringArray);
            return;
        }
        finally {
            a2.f_gi.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void updateVariableWithCachedValue(String string, DataTransferDetail dataTransferDetail, Map<String, Variable<?, ?, ?>> map, Map<String, Map<String, Object>> map2, Map<String, VariableValue<?>> map3) {
        void a;
        Variable a2;
        Object a3 = string;
        DataTransferManager a4 = this;
        if ((a2 = (Variable)a2.get(a.getTargetVariableId())) != null) {
            void a5;
            double d = Double.parseDouble((String)a3);
            a3 = (VariableValue)a5.get(a.getTargetVariableId());
            if (a4.isValueInThresholdRange(a.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(LoggedVariableValueDto.m_VCa((Object)"d_~Kw"), d);
                a6.put(a2.getName(), a3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.f_nI.m_EM((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date date, c_vk c_vk2) {
        void a;
        void a2;
        Object a3;
        DataTransferManager dataTransferManager = this;
        Object object = a3 = Calendar.getInstance();
        ((Calendar)a3).setTime((Date)a2);
        ((Calendar)object).set(0xF & 0x7D, 3 ^ 3);
        ((Calendar)object).set(0x4F & 0x3E, 3 ^ 3);
        Calendar calendar = (Calendar)((Calendar)object).clone();
        switch (c_ub.f_sh[a.ordinal()]) {
            case 1: {
                Object object2 = a3;
                while (false) {
                }
                ((Calendar)object2).set(0x2E & 0x5D, 3 >> 2);
                return Pair.of((Object)((Calendar)object2).getTime(), (Object)a2);
            }
            case 2: {
                calendar.add(0xF & 0x7B, -4 >> 2);
                Object object3 = a3;
                ((Calendar)object3).add(0x3B & 0x4F, 0xFFFFFFFE & 0xFFFFFFFF);
                ((Calendar)object3).set(0x4D & 0x3E, 3 >> 2);
                return Pair.of((Object)((Calendar)object3).getTime(), (Object)calendar.getTime());
            }
            case 3: {
                Object object4 = a3;
                ((Calendar)object4).set(0x3B & 0x4F, 5 >> 3);
                ((Calendar)object4).set(0x1F & 0x6C, 5 >> 3);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 4: {
                calendar.add(--5, -4 >> 2);
                Object object5 = a3;
                ((Calendar)a3).add(--5, -2);
                ((Calendar)object5).set(11, 3 ^ 3);
                ((Calendar)object5).set(0x7F & 0xC, 3 & 4);
                return Pair.of((Object)((Calendar)object5).getTime(), (Object)calendar.getTime());
            }
            case 5: {
                Object object6 = a3;
                Object object7 = a3;
                ((Calendar)object7).set(7, ((Calendar)object7).getFirstDayOfWeek());
                ((Calendar)object6).set(11, 5 >> 3);
                ((Calendar)object6).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 6: {
                calendar.add(--3, -4 >> 2);
                Object object8 = a3;
                ((Calendar)a3).add(--3, -2);
                Object object9 = a3;
                ((Calendar)object9).set(7, ((Calendar)object9).getFirstDayOfWeek());
                ((Calendar)object8).set(11, 0);
                ((Calendar)object8).set(12, 0);
                return Pair.of((Object)((Calendar)object8).getTime(), (Object)calendar.getTime());
            }
            case 7: {
                Object object10 = a3;
                ((Calendar)a3).set(--5, 1);
                ((Calendar)object10).set(11, 0);
                ((Calendar)object10).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 8: {
                calendar.add(--2, -4 >> 2);
                Object object11 = a3;
                Object object12 = a3;
                ((Calendar)object12).add(2, -2);
                ((Calendar)object12).set(5, 1);
                ((Calendar)object11).set(11, 0);
                ((Calendar)object11).set(12, 0);
                return Pair.of((Object)((Calendar)object11).getTime(), (Object)calendar.getTime());
            }
            case 9: {
                Object object13 = a3;
                ((Calendar)a3).set(6, 1);
                ((Calendar)object13).set(11, 0);
                ((Calendar)object13).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 10: {
                calendar.add(1, -1);
                Object object14 = a3;
                Object object15 = a3;
                ((Calendar)object15).add(1, -2);
                ((Calendar)object15).set(6, 1);
                ((Calendar)object14).set(11, 0);
                ((Calendar)object14).set(12, 0);
                return Pair.of((Object)((Calendar)object14).getTime(), (Object)calendar.getTime());
            }
        }
        throw new IllegalArgumentException(DataTransferSummary.m_AQ((Object)"ZGjQ\u007fLl]jM/[nGhL/]vYj"));
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[2 & 5] = a.getSourceVariableId();
        objectArray[--1] = a.getRangeType();
        objectArray[--2] = a.getCalcType();
        return LoggedVariableValueDto.m_VCa((Object)"ZsJs\u0013fLsPaXwL(RsMf\u0013q_~]?J{Sw\u0004d_`Ws\\~[(\u001ba\u00047M(\u001ba").formatted(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader(long l) {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        String a = dataTransferManager2.f_pC.m_la();
        f_bc.info(LoggedVariableValueDto.m_VCa((Object)"zsJsj`_|Mt[`ssPsYwL(\u001eFV{M2P}Zw\u001e:Eo\u00172VsM2\\w]}Sw\u001efVw\u001e^{SzWl<\u001e@[aJ}L{Pu\u001ea]z[vK~[v\u001ev_f_2J`_|Mt[`M<\u0010<"), (Object)a);
        dataTransferManager2.f_gi.lock();
        try {
            HashSet hashSet = new HashSet(dataTransferManager.f_JG.smembers(f_bh));
            if (hashSet.isEmpty()) {
                f_bc.info(DataTransferSummary.m_AQ((Object)"KH{H[[nG|Oj[BHaHhL}\t'ejHkL}\ttT&\u0013/g`\t|JgLk\\cLk\tkH{H/]}HaZiL}Z/O`\\aM/@a\t]Lk@|\t{F/[jZ{F}L!"), (Object)a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[3 & 5] = hashSet.size();
            objectArray[5 >> 1] = hashSet;
            f_bc.info(LoggedVariableValueDto.m_VCa((Object)"V_f_FLsPaXwL__|_u[`\u001e:rw_v[`\u001eiC;\u00042x}K|Z2Eo\u001ea]z[vK~[v\u001ev_f_2J`_|Mt[`\u001e[za\u001e{P2lwZ{M2J}\u001e`[aJ}Lw\u00042Eo"), objectArray);
            ArrayList a2 = new ArrayList();
            String[] stringArray = new String[2 ^ 3];
            stringArray[3 & 4] = DataTransferSummary.m_AQ((Object)"\u007fFlXvKh[hP}]hAzIl]");
            dataTransferManager.f_Fj.m_UEa(() -> {
                void a;
                Object a2 = hashSet;
                DataTransferManager a3 = this;
                a.addAll(a3.f_nI.m_fq((Set)a2));
            }, stringArray);
            f_bc.info(LoggedVariableValueDto.m_VCa((Object)"V_f_FLsPaXwL__|_u[`\u001e:rw_v[`\u001eiC;\u00042\u007ffJwSbJ{Pu\u001efQ2LwMfQ`[2Eo\u001ev_f_2J`_|Mt[`M<"), (Object)a, (Object)a2.size());
            a2.forEach(dataTransfer -> {
                void a;
                DataTransferManager dataTransferManager;
                DataTransferManager dataTransferManager2 = dataTransferManager = this;
                Object a2 = dataTransferManager2.f_pC.m_la();
                String[] stringArray = new String[5 >> 1];
                stringArray[3 & 4] = DataTransferSummary.m_AQ((Object)"zLaJmZeJvKh[hP}]hAzIl]");
                stringArray[--1] = LoggedVariableValueDto.m_VCa((Object)"}SpQ{^aV\u007fF\u007fMj@\u007f\\mT{@");
                dataTransferManager2.f_Fj.m_aga(() -> dataTransferManager.lambda$restoreSingleDataTransferOnLeader$1((String)a2, (DataTransfer)a), a.getSpace(), stringArray);
            });
            f_bc.info(DataTransferSummary.m_AQ((Object)"mn]n}}HaZiL}dnGnNj[/\u0001CLnMj[/Rr\u00005\tI@a@|AjM/Mn]n\t{[nG|Oj[/[jZ{F}H{@`G/Y}FlL|Z!"), (Object)a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[3 >> 1] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_bc.error(LoggedVariableValueDto.m_VCa((Object)"V_f_FLsPaXwL__|_u[`\u001e:rw_v[`\u001eiC;\u00042{`L}L2ZgL{Pu\u001ev_f_2J`_|Mt[`\u001e`[aJ}LsJ{Q|\u001ebL}]wMa\u00042Eo"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_gi.unlock();
        }
    }

    protected Map<String, c_uB> getDataTransferStatusesByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_nI.m_do((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(DataTransferSummary::getId, dataTransferSummary -> {
            DataTransferManager a = dataTransferSummary;
            DataTransferManager a2 = this;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    protected void scheduleDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.f_nI.m_NO((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        DataTransferManager dataTransferManager = this;
        DataTransferManager a22 = (Job)dataTransferManager.f_FH.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_bc.info(DataTransferSummary.m_AQ((Object)"mn]n}}HaZiL}dnGnNj[/\u0001AF{\tCLnMj[/Rr\u00005\tLHaJjEc@aN/E`JnE/C`K/O`[/Mn]n\t{[nG|Oj[/`K\u0013/Rr"), (Object)a3, (Object)a);
                dataTransferManager.f_LG.m_Em((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[3 & 4] = a3;
                objectArray[3 & 5] = a;
                objectArray[--2] = a22.getMessage();
                objectArray[--3] = a22;
                f_bc.error(LoggedVariableValueDto.m_VCa((Object)"V_f_FLsPaXwL__|_u[`\u001e:p}J2rw_v[`\u001eiC;\u00042{`L}L2]sPq[~R{Pu\u001e~Qq_~\u001exQp\u001etQ`\u001ev_f_2J`_|Mt[`\u001e[z2Eo\u00042Eo"), objectArray);
            }
        }
    }

    protected void cancelDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.f_nI.m_bq((String)a2));
    }
}

