/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.opcua.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.protocols.opcua.model.OpcUaDevice;
import com.inscada.mono.communication.protocols.opcua.y.c_NF;
import com.inscada.mono.communication.protocols.opcua.y.c_gD;
import com.inscada.mono.communication.protocols.opcua.y.c_pf;
import com.inscada.mono.shared.n.c_fb;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="opc_ua_connection")
public class OpcUaConnection
extends Connection<OpcUaDevice> {
    @Column(name="password")
    @Convert(converter=c_fb.class)
    private String password;
    @NotNull
    @Column(name="is_anonymous_authentication")
    private Boolean isAnonymousAuthentication;
    @Column(name="encoding_type")
    private c_NF encodingType;
    @Column(name="server_name")
    private String serverName;
    @NotNull
    @Column(name="security_mode")
    private c_pf securityMode;
    @JsonIgnore
    @OneToMany(mappedBy="connection")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<OpcUaDevice> devices;
    @Column(name="is_https_enabled")
    private Boolean isHttpsEnabled;
    @Column(name="username")
    private String username;
    @NotNull
    @Column(name="is_username_password_authentication")
    private Boolean isUsernamePasswordAuthentication;
    @Min(value=100L)
    @Column(name="timeout")
    private Integer timeoutInMs;
    @NotNull
    @Column(name="security_policy")
    private c_gD securityPolicy;
    @Min(value=0L)
    @Max(value=65535L)
    @Column(name="https_port")
    private Integer httpsPort;

    public Set<OpcUaDevice> getDevices() {
        OpcUaConnection a;
        return a.devices;
    }

    public Integer getTimeoutInMs() {
        OpcUaConnection a;
        return a.timeoutInMs;
    }

    public String getUsername() {
        OpcUaConnection a;
        return a.username;
    }

    public void setHttpsPort(Integer n) {
        Object a = n;
        OpcUaConnection a2 = this;
        a2.httpsPort = a;
    }

    public c_gD getSecurityPolicy() {
        OpcUaConnection a;
        return a.securityPolicy;
    }

    public void setIsHttpsEnabled(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isHttpsEnabled = a;
    }

    public void setDevices(Set<OpcUaDevice> set) {
        Object a = set;
        OpcUaConnection a2 = this;
        a2.devices = a;
    }

    public void setIsAnonymousAuthentication(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isAnonymousAuthentication = a;
    }

    public Boolean getIsUsernamePasswordAuthentication() {
        OpcUaConnection a;
        return a.isUsernamePasswordAuthentication;
    }

    public OpcUaConnection() {
        OpcUaConnection a;
        OpcUaConnection opcUaConnection = a;
        opcUaConnection.devices = new HashSet();
    }

    public void setPassword(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.password = a;
    }

    public Boolean getIsAnonymousAuthentication() {
        OpcUaConnection a;
        return a.isAnonymousAuthentication;
    }

    public c_NF getEncodingType() {
        OpcUaConnection a;
        return a.encodingType;
    }

    public void setSecurityPolicy(c_gD c_gD2) {
        OpcUaConnection a = c_gD2;
        OpcUaConnection a2 = this;
        a2.securityPolicy = a;
    }

    public String getPassword() {
        OpcUaConnection a;
        return a.password;
    }

    public void setTimeoutInMs(Integer n) {
        Object a = n;
        OpcUaConnection a2 = this;
        a2.timeoutInMs = a;
    }

    public void setServerName(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.serverName = a;
    }

    public void setUsername(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.username = a;
    }

    public void setEncodingType(c_NF c_NF2) {
        OpcUaConnection a = c_NF2;
        OpcUaConnection a2 = this;
        a2.encodingType = a;
    }

    public String getServerName() {
        OpcUaConnection a;
        return a.serverName;
    }

    public void setSecurityMode(c_pf c_pf2) {
        OpcUaConnection a = c_pf2;
        OpcUaConnection a2 = this;
        a2.securityMode = a;
    }

    public c_pf getSecurityMode() {
        OpcUaConnection a;
        return a.securityMode;
    }

    public void setIsUsernamePasswordAuthentication(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isUsernamePasswordAuthentication = a;
    }

    public Integer getHttpsPort() {
        OpcUaConnection a;
        return a.httpsPort;
    }

    public Boolean getIsHttpsEnabled() {
        OpcUaConnection a;
        return a.isHttpsEnabled;
    }
}

