/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.mqtt.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.protocols.mqtt.model.MqttDevice;
import com.inscada.mono.shared.n.c_fb;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="mqtt_connection")
public class MqttConnection
extends Connection<MqttDevice> {
    @Size(max=23)
    private String identifier;
    @Column(name="use_ssl")
    private Boolean useSsl;
    @Positive
    @Column(name="pool_size")
    private Integer poolSize;
    @Max(value=65535000L)
    @PositiveOrZero
    @Column(name="keep_alive")
    private Integer keepAliveInMs;
    @Size(max=50)
    @Convert(converter=c_fb.class)
    private String password;
    @Column(name="clean_session")
    private Boolean cleanSession;
    @PositiveOrZero
    @Column(name="max_delay")
    private Integer maxDelayInMs;
    @Positive
    @Column(name="initial_delay")
    private Integer initialDelayInMs;
    @JsonIgnore
    @OneToMany(mappedBy="connection")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<MqttDevice> devices;
    @Size(max=50)
    private String username;

    public MqttConnection() {
        MqttConnection a;
        MqttConnection mqttConnection = a;
        mqttConnection.devices = new HashSet();
    }

    public void setPoolSize(Integer n) {
        Object a = n;
        MqttConnection a2 = this;
        a2.poolSize = a;
    }

    public String getIdentifier() {
        MqttConnection a;
        return a.identifier;
    }

    public void setUsername(String string) {
        Object a = string;
        MqttConnection a2 = this;
        a2.username = a;
    }

    public Integer getPoolSize() {
        MqttConnection a;
        return a.poolSize;
    }

    public Integer getMaxDelayInMs() {
        MqttConnection a;
        return a.maxDelayInMs;
    }

    public void setUseSsl(Boolean bl) {
        Object a = bl;
        MqttConnection a2 = this;
        a2.useSsl = a;
    }

    public String getPassword() {
        MqttConnection a;
        return a.password;
    }

    public void setPassword(String string) {
        Object a = string;
        MqttConnection a2 = this;
        a2.password = a;
    }

    public Integer getKeepAliveInMs() {
        MqttConnection a;
        return a.keepAliveInMs;
    }

    public Boolean getCleanSession() {
        MqttConnection a;
        return a.cleanSession;
    }

    public Set<MqttDevice> getDevices() {
        MqttConnection a;
        return a.devices;
    }

    public Integer getInitialDelayInMs() {
        MqttConnection a;
        return a.initialDelayInMs;
    }

    public void setKeepAliveInMs(Integer n) {
        Object a = n;
        MqttConnection a2 = this;
        a2.keepAliveInMs = a;
    }

    public void setCleanSession(Boolean bl) {
        Object a = bl;
        MqttConnection a2 = this;
        a2.cleanSession = a;
    }

    public Boolean getUseSsl() {
        MqttConnection a;
        return a.useSsl;
    }

    public void setInitialDelayInMs(Integer n) {
        Object a = n;
        MqttConnection a2 = this;
        a2.initialDelayInMs = a;
    }

    public void setIdentifier(String string) {
        Object a = string;
        MqttConnection a2 = this;
        a2.identifier = a;
    }

    public void setDevices(Set<MqttDevice> set) {
        Object a = set;
        MqttConnection a2 = this;
        a2.devices = a;
    }

    public String getUsername() {
        MqttConnection a;
        return a.username;
    }

    public void setMaxDelayInMs(Integer n) {
        Object a = n;
        MqttConnection a2 = this;
        a2.maxDelayInMs = a;
    }
}

