/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.iec61850.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.protocols.iec61850.model.Iec61850Device;
import com.inscada.mono.filesystem.model.FileInfo;
import com.inscada.mono.shared.n.c_fb;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="iec61850_connection")
public class Iec61850Connection
extends Connection<Iec61850Device> {
    @PositiveOrZero
    @Column(name="server_model_index")
    private Integer serverModelIndex;
    @Min(value=0L)
    @Max(value=65535L)
    @Column(name="local_port")
    private Short localPort;
    @Size(max=15)
    @Column(name="local_ip")
    private String localIp;
    @JsonIgnore
    @OneToOne
    @JoinColumn(name="scl_file_id")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private FileInfo sclFile;
    @Column(name="authentication_parameter")
    @Convert(converter=c_fb.class)
    private String authenticationParameter;
    @Min(value=100L)
    @Column(name="response_timeout")
    private Integer responseTimeout;
    @JsonIgnore
    @OneToMany(mappedBy="connection")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<Iec61850Device> devices;
    @Min(value=100L)
    @Column(name="message_fragment_timeout")
    private Integer messageFragmentTimeout;
    @Column(name="scl_file_id", updatable=false, insertable=false)
    private String sclFileId;

    public Iec61850Connection() {
        Iec61850Connection a;
        Iec61850Connection iec61850Connection = a;
        iec61850Connection.devices = new HashSet();
    }

    public FileInfo getSclFile() {
        Iec61850Connection a;
        return a.sclFile;
    }

    public Integer getMessageFragmentTimeout() {
        Iec61850Connection a;
        return a.messageFragmentTimeout;
    }

    public void setLocalIp(String string) {
        Object a = string;
        Iec61850Connection a2 = this;
        a2.localIp = a;
    }

    public String getSclFileId() {
        Iec61850Connection a;
        return a.sclFileId;
    }

    public void setAuthenticationParameter(String string) {
        Object a = string;
        Iec61850Connection a2 = this;
        a2.authenticationParameter = a;
    }

    public void setLocalPort(Short s) {
        Object a = s;
        Iec61850Connection a2 = this;
        a2.localPort = a;
    }

    public void setMessageFragmentTimeout(Integer n) {
        Object a = n;
        Iec61850Connection a2 = this;
        a2.messageFragmentTimeout = a;
    }

    public Set<Iec61850Device> getDevices() {
        Iec61850Connection a;
        return a.devices;
    }

    public void setDevices(Set<Iec61850Device> set) {
        Object a = set;
        Iec61850Connection a2 = this;
        a2.devices = a;
    }

    public Short getLocalPort() {
        Iec61850Connection a;
        return a.localPort;
    }

    public void setSclFile(FileInfo fileInfo) {
        Iec61850Connection a;
        Iec61850Connection a2 = fileInfo;
        Iec61850Connection iec61850Connection = a = this;
        iec61850Connection.sclFile = a2;
        iec61850Connection.sclFileId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setResponseTimeout(Integer n) {
        Object a = n;
        Iec61850Connection a2 = this;
        a2.responseTimeout = a;
    }

    public Integer getResponseTimeout() {
        Iec61850Connection a;
        return a.responseTimeout;
    }

    public Integer getServerModelIndex() {
        Iec61850Connection a;
        return a.serverModelIndex;
    }

    public void setSclFileId(String string) {
        Object a = string;
        Iec61850Connection a2 = this;
        a2.sclFileId = a;
    }

    public String getAuthenticationParameter() {
        Iec61850Connection a;
        return a.authenticationParameter;
    }

    public String getLocalIp() {
        Iec61850Connection a;
        return a.localIp;
    }

    public void setServerModelIndex(Integer n) {
        Object a = n;
        Iec61850Connection a2 = this;
        a2.serverModelIndex = a;
    }
}

