/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.dnp3.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.y.c_pj;
import com.inscada.mono.communication.protocols.dnp3.model.Dnp3Connection;
import com.inscada.mono.communication.protocols.dnp3.model.Dnp3Frame;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="dnp3_device")
public class Dnp3Device
extends Device<Dnp3Connection, Dnp3Frame> {
    @Min(value=1L)
    @Column(name="solicited_confirm_timeout")
    private Integer solConfirmTimeoutInMs;
    @Min(value=1L)
    @Column(name="unsolicited_retry_timeout")
    private Integer unsolRetryTimeout;
    @Min(value=1L)
    @Column(name="event_scan_time")
    private Integer eventScanTime;
    @JsonIgnore
    @OneToMany(mappedBy="device")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<Dnp3Frame> frames;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="conn_id")
    protected Dnp3Connection connection;
    @Min(value=1L)
    @Column(name="integrity_scan_time")
    private Integer integrityScanTime;
    @Column(name="integrity_on_event_overflow_iin_flag")
    private Boolean integrityOnEventOverflowIIN;
    @Column(name="unsolicited_events_flag")
    private Boolean unsolicitedEventsFlag;
    @Min(value=1L)
    @Column(name="select_timeout")
    private Integer selectTimeoutInMs;
    @NotNull
    @Min(value=0L)
    @Column(name="local_address")
    private Integer localAddress;
    @Min(value=1L)
    @Column(name="response_timeout")
    private Integer responseTimeoutInMs;
    @Column(name="disable_unsolicited_on_startup_flag")
    private Boolean disableUnsolicitedOnStartup;
    @NotNull
    @Min(value=0L)
    @Column(name="remote_address")
    private Integer remoteAddress;
    @Column(name="startup_integrity_flag")
    private Boolean startupIntegrityFlag;
    @Min(value=1L)
    @Column(name="max_controls_per_request")
    private Short maxControlsPerRequest;
    @NotNull
    @Column(name="scan_type")
    private c_pj scanType;

    public Dnp3Connection getConnection() {
        Dnp3Device a;
        return a.connection;
    }

    public void setSolConfirmTimeoutInMs(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.solConfirmTimeoutInMs = a;
    }

    public Integer getEventScanTime() {
        Dnp3Device a;
        return a.eventScanTime;
    }

    public void setConnection(Dnp3Connection dnp3Connection) {
        Dnp3Device a;
        Dnp3Device a2 = dnp3Connection;
        Dnp3Device dnp3Device = a = this;
        dnp3Device.connection = a2;
        dnp3Device.connectionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setIntegrityScanTime(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.integrityScanTime = a;
    }

    public void setStartupIntegrityFlag(Boolean bl) {
        Object a = bl;
        Dnp3Device a2 = this;
        a2.startupIntegrityFlag = a;
    }

    public void setIntegrityOnEventOverflowIIN(Boolean bl) {
        Object a = bl;
        Dnp3Device a2 = this;
        a2.integrityOnEventOverflowIIN = a;
    }

    public Integer getSolConfirmTimeoutInMs() {
        Dnp3Device a;
        return a.solConfirmTimeoutInMs;
    }

    public void setSelectTimeoutInMs(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.selectTimeoutInMs = a;
    }

    public Integer getSelectTimeoutInMs() {
        Dnp3Device a;
        return a.selectTimeoutInMs;
    }

    public Set<Dnp3Frame> getFrames() {
        Dnp3Device a;
        return a.frames;
    }

    public Integer getIntegrityScanTime() {
        Dnp3Device a;
        return a.integrityScanTime;
    }

    public void setLocalAddress(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.localAddress = a;
    }

    public void setScanType(c_pj c_pj2) {
        Dnp3Device a = c_pj2;
        Dnp3Device a2 = this;
        a2.scanType = a;
    }

    public Integer getUnsolRetryTimeout() {
        Dnp3Device a;
        return a.unsolRetryTimeout;
    }

    public Boolean getStartupIntegrityFlag() {
        Dnp3Device a;
        return a.startupIntegrityFlag;
    }

    public Boolean getUnsolicitedEventsFlag() {
        Dnp3Device a;
        return a.unsolicitedEventsFlag;
    }

    public void setDisableUnsolicitedOnStartup(Boolean bl) {
        Object a = bl;
        Dnp3Device a2 = this;
        a2.disableUnsolicitedOnStartup = a;
    }

    public Integer getLocalAddress() {
        Dnp3Device a;
        return a.localAddress;
    }

    public Boolean getDisableUnsolicitedOnStartup() {
        Dnp3Device a;
        return a.disableUnsolicitedOnStartup;
    }

    public void setRemoteAddress(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.remoteAddress = a;
    }

    public Integer getResponseTimeoutInMs() {
        Dnp3Device a;
        return a.responseTimeoutInMs;
    }

    public Dnp3Device() {
        Dnp3Device a;
        Dnp3Device dnp3Device = a;
        dnp3Device.frames = new HashSet();
    }

    public void setUnsolRetryTimeout(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.unsolRetryTimeout = a;
    }

    public c_pj getScanType() {
        Dnp3Device a;
        return a.scanType;
    }

    public void setUnsolicitedEventsFlag(Boolean bl) {
        Object a = bl;
        Dnp3Device a2 = this;
        a2.unsolicitedEventsFlag = a;
    }

    public Integer getRemoteAddress() {
        Dnp3Device a;
        return a.remoteAddress;
    }

    public void setResponseTimeoutInMs(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.responseTimeoutInMs = a;
    }

    public Boolean getIntegrityOnEventOverflowIIN() {
        Dnp3Device a;
        return a.integrityOnEventOverflowIIN;
    }

    public Short getMaxControlsPerRequest() {
        Dnp3Device a;
        return a.maxControlsPerRequest;
    }

    public void setFrames(Set<Dnp3Frame> set) {
        Object a = set;
        Dnp3Device a2 = this;
        a2.frames = a;
    }

    public void setMaxControlsPerRequest(Short s) {
        Object a = s;
        Dnp3Device a2 = this;
        a2.maxControlsPerRequest = a;
    }

    public void setEventScanTime(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.eventScanTime = a;
    }
}

