/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.template.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.template.model.DeviceTemplate;
import com.inscada.mono.communication.base.template.model.FrameTemplate;
import com.inscada.mono.communication.base.template.model.HasTemplateFrame;
import com.inscada.mono.communication.base.y.c_Jl;
import com.inscada.mono.communication.base.y.c_SK;
import com.inscada.mono.expression.model.Expression;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@AttributeOverride(name="id", column=@Column(name="variable_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"frameId", "frame"})
public class VariableTemplate<TFrameTemplate extends FrameTemplate<?, ?>, TDeviceTemplate extends DeviceTemplate<?>>
extends SpaceBaseModel
implements HasTemplateFrame<TFrameTemplate> {
    @PositiveOrZero
    @Column(name="pulse_off_duration")
    protected Integer pulseOffDuration;
    @NotNull
    @Column(name="keep_last_values")
    protected Boolean keepLastValues;
    @PositiveOrZero
    @Column(name="pulse_on_duration")
    protected Integer pulseOnDuration;
    @Size(max=4000)
    @Column(name="value_expression")
    protected String valueExpressionCode;
    @Column(name="raw_zero_scale")
    protected Double rawZeroScale;
    @NotNull
    @Column(name="writable_flag")
    protected Boolean isWritable;
    @NotNull
    @Column(name="pulse_off_flag")
    protected Boolean isPulseOff;
    @Column(name="log_expression_id", insertable=false, updatable=false)
    protected String logExpressionId;
    @Column(name="value_expression_type")
    protected c_Jl valueExpressionType;
    @Column(name="set_max_value")
    protected Double setMaxValue;
    @Column(name="eng_zero_scale")
    protected Double engZeroScale;
    @Column(name="log_max_value")
    protected Double logMaxValue;
    @Column(name="set_min_value")
    protected Double setMinValue;
    @NotBlank
    @Size(max=100)
    protected String name;
    @Size(max=4000)
    @Column(name="log_expression")
    protected String logExpressionCode;
    @Size(max=255)
    protected String dsc;
    @Column(name="value_expression_id", insertable=false, updatable=false)
    protected String valueExpressionId;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="log_expression_id")
    protected Expression logExpression;
    @Min(value=1L)
    @Column(name="log_period")
    protected Integer logPeriod;
    @Column(name="log_type")
    protected c_SK logType;
    @NotNull
    @Column(name="pulse_on_flag")
    protected Boolean isPulseOn;
    @Column(name="eng_full_scale")
    protected Double engFullScale;
    @Column(name="raw_full_scale")
    protected Double rawFullScale;
    @Column(name="log_min_value")
    protected Double logMinValue;
    @Column(name="frame_id", insertable=false, updatable=false)
    protected String frameId;
    @Column(name="log_threshold")
    protected Double logThreshold;
    @NotNull
    @Column(name="active_flag")
    protected Boolean isActive;
    @Column(name="fractional_digit_count")
    protected Short fractionalDigitCount;
    @Size(max=20)
    protected String code;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="value_expression_id")
    protected Expression valueExpression;
    protected String unit;

    public String getValueExpressionCode() {
        VariableTemplate a;
        return a.valueExpressionCode;
    }

    public void setIsActive(Boolean bl) {
        Object a = bl;
        VariableTemplate a2 = this;
        a2.isActive = a;
    }

    public void setValueExpressionId(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.valueExpressionId = a;
    }

    public void setLogExpressionCode(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.logExpressionCode = a;
    }

    public Double getLogThreshold() {
        VariableTemplate a;
        return a.logThreshold;
    }

    public void setEngZeroScale(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.engZeroScale = a;
    }

    public void setSetMaxValue(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.setMaxValue = a;
    }

    public String getUnit() {
        VariableTemplate a;
        return a.unit;
    }

    public Integer getPulseOnDuration() {
        VariableTemplate a;
        return a.pulseOnDuration;
    }

    public void setValueExpressionType(c_Jl c_Jl2) {
        VariableTemplate a = c_Jl2;
        VariableTemplate a2 = this;
        a2.valueExpressionType = a;
    }

    public void setPulseOnDuration(Integer n) {
        Object a = n;
        VariableTemplate a2 = this;
        a2.pulseOnDuration = a;
    }

    public String getDeviceId() {
        VariableTemplate a;
        return a.getFrame().getDeviceId();
    }

    public Double getEngFullScale() {
        VariableTemplate a;
        return a.engFullScale;
    }

    public Double getEngZeroScale() {
        VariableTemplate a;
        return a.engZeroScale;
    }

    public String getCode() {
        VariableTemplate a;
        return a.code;
    }

    public void setName(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.name = a;
    }

    public void setLogExpression(Expression expression) {
        VariableTemplate a = expression;
        VariableTemplate a2 = this;
        a2.logExpression = a;
    }

    public Boolean getIsPulseOff() {
        VariableTemplate a;
        return a.isPulseOff;
    }

    public void setRawFullScale(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.rawFullScale = a;
    }

    public Boolean getIsPulseOn() {
        VariableTemplate a;
        return a.isPulseOn;
    }

    public String getFrameId() {
        VariableTemplate a;
        return a.frameId;
    }

    public Double getRawZeroScale() {
        VariableTemplate a;
        return a.rawZeroScale;
    }

    public boolean equals(Object object) {
        VariableTemplate a = this;
        Object a2 = object;
        if (a == a2) {
            return (2 ^ 3) != 0;
        }
        if (!(a2 instanceof VariableTemplate)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 & 4) != 0;
        }
        if (a.getFrameId().equals(object2.getFrameId()) && a.getName().equals(object2.getName())) {
            return --1 != 0;
        }
        return false;
    }

    public Short getFractionalDigitCount() {
        VariableTemplate a;
        return a.fractionalDigitCount;
    }

    public Double getLogMinValue() {
        VariableTemplate a;
        return a.logMinValue;
    }

    public Double getSetMinValue() {
        VariableTemplate a;
        return a.setMinValue;
    }

    public void setKeepLastValues(Boolean bl) {
        Object a = bl;
        VariableTemplate a2 = this;
        a2.keepLastValues = a;
    }

    public void setSetMinValue(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.setMinValue = a;
    }

    public void setValueExpressionCode(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.valueExpressionCode = a;
    }

    public void setLogPeriod(Integer n) {
        Object a = n;
        VariableTemplate a2 = this;
        a2.logPeriod = a;
    }

    public Boolean getIsWritable() {
        VariableTemplate a;
        return a.isWritable;
    }

    public Boolean getIsActive() {
        VariableTemplate a;
        return a.isActive;
    }

    public void setIsWritable(Boolean bl) {
        Object a = bl;
        VariableTemplate a2 = this;
        a2.isWritable = a;
    }

    public String getLogExpressionId() {
        VariableTemplate a;
        return a.logExpressionId;
    }

    public int hashCode() {
        VariableTemplate a;
        Object[] objectArray = new Object[--3];
        objectArray[3 ^ 3] = super.hashCode();
        objectArray[--1] = a.getFrameId();
        objectArray[--2] = a.getName();
        return Objects.hash(objectArray);
    }

    public String getValueExpressionId() {
        VariableTemplate a;
        return a.valueExpressionId;
    }

    public String getName() {
        VariableTemplate a;
        return a.name;
    }

    public void setLogThreshold(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.logThreshold = a;
    }

    public void setRawZeroScale(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.rawZeroScale = a;
    }

    public void setIsPulseOff(Boolean bl) {
        Object a = bl;
        VariableTemplate a2 = this;
        a2.isPulseOff = a;
    }

    public void setPulseOffDuration(Integer n) {
        Object a = n;
        VariableTemplate a2 = this;
        a2.pulseOffDuration = a;
    }

    public Expression getLogExpression() {
        VariableTemplate a;
        return a.logExpression;
    }

    public Double getLogMaxValue() {
        VariableTemplate a;
        return a.logMaxValue;
    }

    public VariableTemplate() {
        VariableTemplate a;
    }

    public void setFrameId(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.frameId = a;
    }

    public Expression getValueExpression() {
        VariableTemplate a;
        return a.valueExpression;
    }

    public void setCode(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.code = a;
    }

    public Double getRawFullScale() {
        VariableTemplate a;
        return a.rawFullScale;
    }

    public void setFractionalDigitCount(Short s) {
        Object a = s;
        VariableTemplate a2 = this;
        a2.fractionalDigitCount = a;
    }

    public Integer getLogPeriod() {
        VariableTemplate a;
        return a.logPeriod;
    }

    public c_SK getLogType() {
        VariableTemplate a;
        return a.logType;
    }

    public String getDsc() {
        VariableTemplate a;
        return a.dsc;
    }

    public void setEngFullScale(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.engFullScale = a;
    }

    public Double getSetMaxValue() {
        VariableTemplate a;
        return a.setMaxValue;
    }

    public void setDsc(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.dsc = a;
    }

    public void setLogExpressionId(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.logExpressionId = a;
    }

    public String getLogExpressionCode() {
        VariableTemplate a;
        return a.logExpressionCode;
    }

    public Integer getPulseOffDuration() {
        VariableTemplate a;
        return a.pulseOffDuration;
    }

    public void setValueExpression(Expression expression) {
        VariableTemplate a = expression;
        VariableTemplate a2 = this;
        a2.valueExpression = a;
    }

    public c_Jl getValueExpressionType() {
        VariableTemplate a;
        return a.valueExpressionType;
    }

    public void setUnit(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.unit = a;
    }

    public Boolean getKeepLastValues() {
        VariableTemplate a;
        return a.keepLastValues;
    }

    public void setIsPulseOn(Boolean bl) {
        Object a = bl;
        VariableTemplate a2 = this;
        a2.isPulseOn = a;
    }

    public void setLogType(c_SK c_SK2) {
        VariableTemplate a = c_SK2;
        VariableTemplate a2 = this;
        a2.logType = a;
    }

    public void setLogMaxValue(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.logMaxValue = a;
    }

    public void setLogMinValue(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.logMinValue = a;
    }

    @JsonIgnore
    public TDeviceTemplate getDevice() {
        VariableTemplate a;
        return (TDeviceTemplate)a.getFrame().getDevice();
    }
}

