/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_yK;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.manager.LeaderFencedManager;
import com.inscada.mono.cluster.services.c_C;
import com.inscada.mono.communication.base.d.c_Hj;
import com.inscada.mono.communication.base.d.c_qj;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.ConnectionSummary;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_D;
import com.inscada.mono.communication.base.services.c_Ki;
import com.inscada.mono.communication.base.services.c_NL;
import com.inscada.mono.communication.base.services.c_Se;
import com.inscada.mono.communication.base.services.c_si;
import com.inscada.mono.communication.base.y.c_NJ;
import com.inscada.mono.license.d.c_ZC;
import com.inscada.mono.log.d.c_dA;
import com.inscada.mono.project.d.c_k;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
extends LeaderFencedManager
implements c_k {
    public static final short f_nu = 203;
    public static final short f_hT = 210;
    private final c_Ki<C, V> f_fu;
    private final Lock f_st;
    public static final short f_ZT = 201;
    public static final short f_ls = 204;
    private static final String f_LT = "activeConnections";
    public static final short f_ET = 208;
    private static final Logger f_bc = LoggerFactory.getLogger(ConnectionManager.class);
    private final c_ZC f_Eu;
    public static final short f_dt = 202;
    public static final short f_gS = 206;
    public static final short f_hs = 209;
    public static final short f_VR = 207;
    private final c_dA f_pu;
    private final c_yK f_Dt;
    private final JedisPooled f_ct;
    private final c_NL f_aS;
    public static final short f_gT = 205;

    /*
     * WARNING - void declaration
     */
    protected Object browseConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        ConnectionManager a2 = connectionManager2.f_aS.m_Wca((String)a);
        return connectionManager2.f_Dt.m_bDa(() -> connectionManager.lambda$browseConnectionInternal$2((String)a), (OwnedSpaceBaseModel)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleConnectionOnLeader$1(String string, Connection connection) {
        void a;
        ConnectionManager a2 = connection;
        ConnectionManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[3 >> 1] = a2.getName();
            objectArray[5 >> 1] = a2.getId();
            f_bc.info(ExceptionDetails.m_EF((Object)"*y\u0007x\fu\u001d\u007f\u0006x$w\u0007w\u000es\u001b6AZ\fw\rs\u001b6\u0012k@,ID\fe\u001dy\u001b\u007f\u0007qIu\u0006x\u0007s\nb\u0000y\u0007,Im\u00146A_-,Im\u0014?"), objectArray);
            ConnectionManager connectionManager = a3;
            Connection connection2 = connectionManager.loadConnectionWithDetails((Connection)a2);
            connectionManager.startConnectionInternal(connection2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a2.getName();
            objectArray[2 ^ 3] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_pu.m_AK(a2.getProject()).m_V("Connection Restore (Leader " + (String)a + ")", c_si.m_fCa((Object)"L\u0010IK 'SCL\u0010@C\u000f\u0002\u0000\u000f\f\u0007I\u0017\u0006C\u001b\u0006\u001a\u0017\u0006\u0011\fMI \b\u0016\u001a\u0006SCL\u0010").formatted(objectArray));
            try {
                f_bc.warn(ExceptionDetails.m_EF((Object)"*y\u0007x\fu\u001d\u007f\u0006x$w\u0007w\u000es\u001b6AZ\fw\rs\u001b6\u0012k@,IW\u001db\f{\u0019b\u0000x\u000e6\u001dyIe\u001dy\u00196\ny\u0007x\fu\u001d\u007f\u0006xIm\u00146\bp\u001ds\u001b6\u001bs\u001ab\u0006d\bb\u0000y\u00076\u000fw\u0000z\u001cd\f8"), (Object)a, (Object)a2.getId());
                a3.stopConnectionInternal((Connection)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 & 4] = a;
                objectArray2[3 & 5] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_bc.error(c_si.m_fCa((Object)" \u0006\r\u0007\u0006\n\u0017\u0000\f\u0007.\b\r\b\u0004\f\u0011IK%\u0006\b\u0007\f\u0011I\u0018\u0014JSC/\u0002\u0000\u000f\f\u0007I\u0017\u0006C\u001a\u0017\u0006\u0013I\u0000\u0006\r\u0007\u0006\n\u0017\u0000\f\u0007C\u0012\u001eI\u0002\u000f\u0017\f\u0011I\u0011\f\u0010\u001d\f\u001b\u0002\u001d\n\u0006\rI\u0005\b\n\u0005\u0016\u001b\u0006SC\u0012\u001e"), objectArray2);
                return;
            }
        }
    }

    private /* synthetic */ void lambda$startConnectionInternal$3(Connection connection) {
        ConnectionManager a;
        ConnectionManager a2 = connection;
        ConnectionManager connectionManager = a = this;
        long l = connectionManager.f_pC.m_Ja();
        String string = connectionManager.f_pC.m_la();
        connectionManager.stopConnectionInternal((Connection)a2);
        if (!Boolean.TRUE.equals(a2.getProject().getIsActive())) {
            throw new NotActiveException("Project should be active to start connection " + a2.getName());
        }
        ConnectionManager connectionManager2 = a;
        connectionManager2.f_Eu.m_wj();
        c_Se c_Se2 = connectionManager2.f_fu.m_pba((Connection)a2);
        c_Se2.m_wx();
        long l2 = connectionManager2.f_pC.m_Ja();
        if (!connectionManager2.f_pC.m_ma() || l2 == -1L || l2 != l) {
            try {
                c_Se2.m_HU();
                a.f_fu.m_Cba(a2.getId(), c_Se2);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[--4];
                objectArray[2 & 5] = string;
                objectArray[2 ^ 3] = a2.getId();
                objectArray[5 >> 1] = exception.getMessage();
                objectArray[--3] = exception;
                f_bc.warn(c_si.m_fCa((Object)"*\f\u0007\r\f\u0000\u001d\n\u0006\r$\u0002\u0007\u0002\u000e\u0006\u001bCA\u0018\u0014JSC/\u0006\u0007\u0000\f\u0007I\u0010\u001d\f\u0019C\u000f\u0002\u0000\u000f\f\u0007I\u0005\u0006\u0011I\u0000\u0006\r\u0007\u0006\n\u0017\u0000\f\u0007C\u0012\u001eI\u0002\u000f\u0017\f\u0011I\u0017\f\u0011\u0004C\n\u000b\b\r\u000e\u0006SC\u0012\u001e"), objectArray);
            }
            Object[] objectArray = new Object[--4];
            objectArray[5 >> 3] = a2.getId();
            objectArray[--1] = string;
            objectArray[1 ^ 3] = l;
            objectArray[--3] = l2;
            f_bc.info(ExceptionDetails.m_EF((Object)":}\u0000f\u0019\u007f\u0007qIw\nb\u0000`\bb\u0000y\u00076\u0006pIu\u0006x\u0007s\nb\u0000y\u00076\u0012kIy\u00076\u0007y\rsIm\u0014,Iz\fw\rs\u001be\u0001\u007f\u00196\u0005y\u001abIy\u001b6\u001ds\u001b{Iu\u0001w\u0007q\frI>\u001au\u0001s\rc\u0005s\r+\u0012kE6\nc\u001bd\fx\u001d+\u0012k@8"), objectArray);
            return;
        }
        String[] stringArray = new String[--1];
        stringArray[3 & 4] = a2.getId();
        a.f_ct.sadd(f_LT, stringArray);
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a22 = collection;
        ConnectionManager a3 = this;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, ExceptionDetails.m_EF((Object)":s\u001d@\bz\u001cs;s\u0018c\fe\u001d6\nw\u0007x\u0006bIt\f6\u0007c\u0005z")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), c_si.m_fCa((Object)"*\f\u0007\r\f\u0000\u001d\n\u0006\r \u0007I\n\u0007C:\u0006\u001d5\b\u000f\u001c\u0006;\u0006\u0018\u0016\f\u0010\u001dC\n\u0002\u0007\r\u0006\u0017I\u0001\fC\u0007\u0016\u0005\u000f")));
        if (a3.f_pC.m_ma()) {
            f_bc.debug(ExceptionDetails.m_EF((Object)"Z,W-S;,IE\fb\u001d\u007f\u0007qIm\u00146\u001fw\u001b\u007f\bt\u0005sI`\bz\u001cs\u001a6\u0005y\nw\u0005z\u00108"), (Object)a22.size());
            a3.setVariableValuesInternal((Collection)a22);
            return;
        }
        f_bc.debug(c_si.m_fCa((Object)"','N%&(',1SC;\u0006\u0018\u0016\f\u0010\u001d\n\u0007\u0004I\u000f\f\u0002\r\u0006\u001bC\u001d\fI\u0010\f\u0017I\u0018\u0014C\u001f\u0002\u001b\n\b\u0001\u0005\u0006I\u0015\b\u000f\u001c\u0006\u001aM"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = new ArrayList(a22);
            a3.f_pC.m_Fa(Short.valueOf((short)(0x47DF & 0x38ED)), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new ClusterRpcException(ExceptionDetails.m_EF((Object)"P\b\u007f\u0005s\r6\u001dyID9UIe\fbI`\bd\u0000w\u000bz\f6\u001fw\u0005c\fe"), (Throwable)a22);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_Hj.class})
    public void handleRestartEvent(c_Hj c_Hj2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_pC.m_ma()) {
            ConnectionManager a2 = a.m_TBa();
            f_bc.info(c_si.m_fCa((Object)"/,\"-&;YI+\b\r\r\u000f\u0000\r\u000eC;\u0006\u001a\u0017\b\u0011\u001d&\u001f\u0006\u0007\u0017I\u0005\u0006\u0011I\u0000\u0006\r\u0007\u0006\n\u0017\u0000\f\u0007YI\u0018\u0014CA*-YI\u0018\u0014J"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.f_st.lock();
            try {
                if (connectionManager.getConnectionStatusInternal(a2.getId()) == c_NJ.f_Ls) {
                    connectionManager.startConnectionInternal(a2.getId());
                }
                return;
            }
            finally {
                connectionManager.f_st.unlock();
            }
        }
        f_bc.debug(ExceptionDetails.m_EF((Object)"'Y';%S(R,DS6 q\u0007y\u001b\u007f\u0007qID\fe\u001dw\u001bb,`\fx\u001d6\u000fy\u001b6\ny\u0007x\fu\u001d\u007f\u0006xS6\u0012k"), (Object)a.m_TBa().getId());
    }

    protected void stopConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_aS.m_gCa((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    protected void stopConnectionInternal(String string) {
        ConnectionManager a;
        Object a2 = string;
        ConnectionManager connectionManager = a = this;
        connectionManager.stopConnectionInternal(connectionManager.f_aS.m_Wca((String)a2));
    }

    private /* synthetic */ Connection<?> loadConnectionWithDetails(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        if (a == null) {
            return null;
        }
        return a2.f_aS.m_bda(a.getId());
    }

    protected void startConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_aS.m_gCa((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            Connection connection = (Connection)a.next();
            ConnectionManager connectionManager = a2;
            connectionManager.startConnectionInternal(connectionManager.loadConnectionWithDetails(connection));
            object = a;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$leader$0(Collection collection, Set set) {
        void a;
        Object a2 = set;
        ConnectionManager a3 = this;
        a.addAll(a3.f_aS.m_eda((Set)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void restoreSingleConnectionOnLeader(Connection<?> connection) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a2 = connectionManager2.f_pC.m_la();
        String[] stringArray = new String[--4];
        stringArray[3 ^ 3] = c_si.m_fCa((Object)":7(1=<*,'-, =*&-");
        stringArray[3 >> 1] = ExceptionDetails.m_EF((Object)"E=Y9I*Y'X,U=_&X");
        stringArray[5 >> 1] = c_si.m_fCa((Object)"?*,46 &-'&*7 ,'< 7,.");
        stringArray[--3] = ExceptionDetails.m_EF((Object)"@ S>I?W;_(T%S");
        connectionManager2.f_Dt.m_aga(() -> connectionManager.lambda$restoreSingleConnectionOnLeader$1((String)a2, (Connection)a), a.getSpace(), stringArray);
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(ExceptionDetails.m_EF((Object)"%S(R,DS6:b\bd\u001d\u007f\u0007qIw\u0005zIu\u0006x\u0007s\nb\u0000y\u0007eIp\u0006dIf\u001by\u0003s\nbIm\u00146\u0005y\nw\u0005z\u00108"), a);
            a2.startConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_bc.debug(c_si.m_fCa((Object)"','N%&(',1SC;\u0006\u0018\u0016\f\u0010\u001d\n\u0007\u0004I\u000f\f\u0002\r\u0006\u001bC\u001d\fI\u0010\u001d\u0002\u001b\u0017I\u0002\u0005\u000fI\u0000\u0006\r\u0007\u0006\n\u0017\u0000\f\u0007\u0010I\u0005\u0006\u0011I\u0013\u001b\f\u0003\u0006\n\u0017I\u0018\u0014M"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x7FDE & 0xEF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connections for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.stopConnection(connectionManager.f_aS.m_PAa((String)a, (String)a3).getId());
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.info(c_si.m_fCa((Object)"%&(',1SC!\u0002\u0007\u0007\u0005\n\u0007\u0004I3\u001b\f\u0003\u0006\n\u0017-\u0006\b\u0000\u001d\n\u001f\u0002\u001d\u0006,\u0015\f\r\u001dC\u000f\f\u001bC\u0019\u0011\u0006\t\f\u0000\u001dC 'SC\u0012\u001e"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_bc.debug(ExceptionDetails.m_EF((Object)"'Y';%S(R,DS6 q\u0007y\u001b\u007f\u0007qIF\u001by\u0003s\nb-s\bu\u001d\u007f\u001fw\u001ds,`\fx\u001d6\u000fy\u001b6\u0019d\u0006|\fu\u001d6 RS6\u0012k"), a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader(long l) {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        String a = connectionManager2.f_pC.m_la();
        f_bc.info(ExceptionDetails.m_EF((Object)"*y\u0007x\fu\u001d\u007f\u0006x$w\u0007w\u000es\u001b,IB\u0001\u007f\u001a6\u0007y\rsI>\u0012k@6\u0001w\u001a6\u000bs\ny\u0004sIb\u0001sIZ,W-S;8ID\fe\u001dy\u001b\u007f\u0007qIw\nb\u0000`\f6\ny\u0007x\fu\u001d\u007f\u0006x\u001a8G8"), (Object)a);
        connectionManager2.f_st.lock();
        try {
            HashSet hashSet = new HashSet(connectionManager.f_ct.smembers(f_LT));
            if (hashSet.isEmpty()) {
                f_bc.info(c_si.m_fCa((Object)" \u0006\r\u0007\u0006\n\u0017\u0000\f\u0007.\b\r\b\u0004\f\u0011IK%\u0006\b\u0007\f\u0011I\u0018\u0014JSC'\fI\u0002\n\u0017\u0000\u0015\fC\n\f\u0007\r\f\u0000\u001d\n\u0006\r\u001aC\u000f\f\u001c\r\rC\u0000\rI1\f\u0007\u0000\u0010I\u0017\u0006C\u001b\u0006\u001a\u0017\u0006\u0011\fM"), (Object)a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[--1] = hashSet.size();
            objectArray[5 >> 1] = hashSet;
            f_bc.info(ExceptionDetails.m_EF((Object)"U\u0006x\u0007s\nb\u0000y\u0007[\bx\bq\fdI>%s\br\fdIm\u0014?S6/y\u001cx\r6\u0012kIw\nb\u0000`\f6\ny\u0007x\fu\u001d\u007f\u0006xI_-eI\u007f\u00076;s\r\u007f\u001a6\u001dyId\fe\u001dy\u001bsS6\u0012k"), objectArray);
            Object a2 = new ArrayList();
            String[] stringArray = new String[3 & 5];
            stringArray[3 ^ 3] = c_si.m_fCa((Object)"?*,46 &-'&*7 ,'< 7,.");
            connectionManager.f_Dt.m_UEa(() -> connectionManager.lambda$leader$0((Collection)a2, hashSet), stringArray);
            f_bc.info(ExceptionDetails.m_EF((Object)"*y\u0007x\fu\u001d\u007f\u0006x$w\u0007w\u000es\u001b6AZ\fw\rs\u001b6\u0012k@,IW\u001db\f{\u0019b\u0000x\u000e6\u001dyId\fe\u001dy\u001bsIm\u00146\ny\u0007x\fu\u001d\u007f\u0006x\u001a8"), (Object)a, (Object)a2.size());
            Object object = a2 = a2.iterator();
            while (object.hasNext()) {
                Connection connection = (Connection)a2.next();
                object = a2;
                connectionManager.restoreSingleConnectionOnLeader(connection);
            }
            f_bc.info(c_si.m_fCa((Object)" \u0006\r\u0007\u0006\n\u0017\u0000\f\u0007.\b\r\b\u0004\f\u0011IK%\u0006\b\u0007\f\u0011I\u0018\u0014JSC/\n\u0007\n\u001a\u000b\f\u0007I\u0000\u0006\r\u0007\u0006\n\u0017\u0000\f\u0007C\u001b\u0006\u001a\u0017\u0006\u0011\b\u0017\u0000\f\u0007C\u0019\u0011\u0006\u0000\f\u0010\u001aM"), (Object)a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_bc.error(ExceptionDetails.m_EF((Object)"*y\u0007x\fu\u001d\u007f\u0006x$w\u0007w\u000es\u001b6AZ\fw\rs\u001b6\u0012k@,IS\u001bd\u0006dIr\u001cd\u0000x\u000e6\ny\u0007x\fu\u001d\u007f\u0006xId\fe\u001dy\u001bw\u001d\u007f\u0006xIf\u001by\ns\u001aeS6\u0012k"), objectArray);
            return;
        }
        finally {
            connectionManager.f_st.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void startConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager = this;
        ConnectionManager a2 = connectionManager.f_aS.m_Fca((String)a);
        if (a2 == null) {
            throw new NotFoundException("Connection not found with id: " + (String)a);
        }
        ConnectionManager connectionManager2 = connectionManager;
        connectionManager2.startConnectionInternal(connectionManager2.loadConnectionWithDetails((Connection)a2));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_NJ> getConnectionStatuses(String[] stringArray) {
        Object[] a = stringArray;
        Object[] a2 = this;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.f_pC.m_ma()) {
            f_bc.debug(ExceptionDetails.m_EF((Object)"Z,W-S;,IQ\fb\u001d\u007f\u0007qIu\u0006x\u0007s\nb\u0000y\u00076\u001ab\bb\u001ce\feIp\u0006dIm\u00146 R\u001a6\u0005y\nw\u0005z\u00108"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal((String[])a);
        }
        f_bc.debug(c_si.m_fCa((Object)"-&-D/,\"-&;YI1\f\u0012\u001c\u0006\u001a\u0017\u0000\r\u000eC\u0005\u0006\b\u0007\f\u0011I\u0005\u0006\u0011I\u0000\u0006\r\u0007\u0006\n\u0017\u0000\f\u0007C\u001a\u0017\b\u0017\u001c\u0010\f\u0010I\u0005\u0006\u0011I\u0018\u0014C '\u001aM"), (Object)a.length);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_pC.m_Fa(Short.valueOf((short)(0x73DB & 0xCF5)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for IDs " + Arrays.toString(a), (Throwable)exception);
        }
    }

    protected void stopConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_Dt.m_mEa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_st.lock();
            try {
                c_Se c_Se2 = a2.f_fu.m_uAa(a.getId());
                if (c_Se2 != null) {
                    c_Se2.m_HU();
                    a2.f_fu.m_Cba(a.getId(), c_Se2);
                }
                String[] stringArray = new String[2 ^ 3];
                stringArray[2 & 5] = a.getId();
                a2.f_ct.srem(f_LT, stringArray);
                return;
            }
            finally {
                a2.f_st.unlock();
            }
        }, a);
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManager(c_NL c_NL2, c_ZC c_ZC2, c_dA c_dA2, c_Ki<C, V> c_Ki2, JedisPooled jedisPooled, c_C c_C2, c_yK c_yK2) {
        ConnectionManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ConnectionManager a8;
        ConnectionManager connectionManager = connectionManager2;
        ConnectionManager connectionManager2 = c_yK2;
        ConnectionManager connectionManager3 = a8 = connectionManager;
        ConnectionManager connectionManager4 = a8;
        ConnectionManager connectionManager5 = a8;
        super((c_C)a7);
        ConnectionManager connectionManager6 = a8;
        connectionManager6.f_st = new ReentrantLock();
        connectionManager5.f_aS = a6;
        connectionManager5.f_Eu = a5;
        connectionManager4.f_pu = a4;
        connectionManager4.f_fu = a3;
        connectionManager3.f_ct = a2;
        connectionManager3.f_Dt = a;
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_qj.class})
    public void handleDeleteEvent(c_qj c_qj2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_pC.m_ma()) {
            ConnectionManager a2 = a.m_lCa();
            f_bc.info(c_si.m_fCa((Object)"%&(',1SC!\u0002\u0007\u0007\u0005\n\u0007\u0004I'\f\u000f\f\u0017\f&\u001f\u0006\u0007\u0017I\u0005\u0006\u0011I\u0000\u0006\r\u0007\u0006\n\u0017\u0000\f\u0007YI\u0018\u0014CA*-YI\u0018\u0014J"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.stopConnectionInternal((Connection)a2);
            return;
        }
        f_bc.debug(ExceptionDetails.m_EF((Object)"X&XDZ,W-S;,I_\u000ex\u0006d\u0000x\u000e6-s\u0005s\u001ds,`\fx\u001d6\u000fy\u001b6\ny\u0007x\fu\u001d\u007f\u0006xS6\u0012k"), (Object)a.m_lCa().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_NJ getConnectionStatus(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(ExceptionDetails.m_EF((Object)"Z,W-S;,IQ\fb\u001d\u007f\u0007qIu\u0006x\u0007s\nb\u0000y\u00076\u001ab\bb\u001ceIp\u0006dIm\u00146\u0005y\nw\u0005z\u00108"), a);
            return a2.getConnectionStatusInternal((String)a);
        }
        f_bc.debug(c_si.m_fCa((Object)"-&-D/,\"-&;YI1\f\u0012\u001c\u0006\u001a\u0017\u0000\r\u000eC\u0005\u0006\b\u0007\f\u0011I\u0005\u0006\u0011I\u0000\u0006\r\u0007\u0006\n\u0017\u0000\f\u0007C\u001a\u0017\b\u0017\u001c\u0010I\u0005\u0006\u0011I\u0018\u0014M"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 & 4] = a;
            return (c_NJ)a2.f_pC.m_Fa(Short.valueOf((short)(0x5CCF & 0x23FB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection status for " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        Objects.requireNonNull(a, ExceptionDetails.m_EF((Object)":s\u001d@\bz\u001cs;s\u0018c\fe\u001d6\nw\u0007x\u0006bIt\f6\u0007c\u0005z"));
        Objects.requireNonNull(a.getConnectionId(), c_si.m_fCa((Object)"*\f\u0007\r\f\u0000\u001d\n\u0006\r \u0007I\n\u0007C:\u0006\u001d5\b\u000f\u001c\u0006;\u0006\u0018\u0016\f\u0010\u001dC\n\u0002\u0007\r\u0006\u0017I\u0001\fC\u0007\u0016\u0005\u000f"));
        if (a2.f_pC.m_ma()) {
            f_bc.debug(ExceptionDetails.m_EF((Object)"%S(R,DS6:s\u001db\u0000x\u000e6\u001fw\u001b\u007f\bt\u0005sI`\bz\u001csIp\u0006dIu\u0006x\u0007s\nb\u0000y\u00076\u0012kIz\u0006u\bz\u0005oS6\u0012k"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        f_bc.debug(c_si.m_fCa((Object)"-&-D/,\"-&;YI1\f\u0012\u001c\u0006\u001a\u0017\u0000\r\u000eC\u0005\u0006\b\u0007\f\u0011I\u0017\u0006C\u001a\u0006\u001dC\u001f\u0002\u001b\n\b\u0001\u0005\u0006I\u0015\b\u000f\u001c\u0006I\u0005\u0006\u0011I\u0000\u0006\r\u0007\u0006\n\u0017\u0000\f\u0007C\u0012\u001eSC\u0012\u001e"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 >> 2] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x59CD & 0x26FE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    protected void setVariableValueInternal(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        c_Se c_Se2 = a2.f_fu.m_uAa(a.getConnectionId());
        if (c_Se2 == null) {
            throw new NotFoundException("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_Se2.m_mw(a);
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ConnectionManager connectionManager = this;
        try {
            Class[] classArray = new Class[4 ^ 5];
            classArray[3 >> 2] = String.class;
            connectionManager.f_pC.m_Da((short)(0x2BDF & 0x54E9), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_si.m_fCa((Object)"\u0010\u001d\u0002\u001b\u0017*\f\u0007\r\f\u0000\u001d\n\u0006\r \r\u001d\u0006\u001b\r\b\u000f"), classArray));
            Class[] classArray2 = new Class[3 >> 1];
            classArray2[3 & 4] = String.class;
            connectionManager.f_pC.m_Da((short)(0x55DA & 0x2AEF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ExceptionDetails.m_EF((Object)"\u001ab\u0006f*y\u0007x\fu\u001d\u007f\u0006x x\u001ds\u001bx\bz"), classArray2));
            Class[] classArray3 = new Class[4 ^ 5];
            classArray3[3 ^ 3] = String.class;
            connectionManager.f_pC.m_Da((short)(0x61EB & 0x1EDF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_si.m_fCa((Object)"\u0004\f\u0017*\f\u0007\r\f\u0000\u001d\n\u0006\r:\u0017\b\u0017\u001c\u0010 \r\u001d\u0006\u001b\r\b\u000f"), classArray3));
            Class[] classArray4 = new Class[3 >> 1];
            classArray4[3 ^ 3] = SetValueRequest.class;
            connectionManager.f_pC.m_Da((short)(0x1EDF & 0x61EC), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ExceptionDetails.m_EF((Object)"\u001as\u001d@\bd\u0000w\u000bz\f@\bz\u001cs x\u001ds\u001bx\bz"), classArray4));
            Class[] classArray5 = new Class[3 >> 1];
            classArray5[3 ^ 3] = Collection.class;
            connectionManager.f_pC.m_Da((short)(0x4CDD & 0x33EF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_si.m_fCa((Object)"\u0010\f\u0017?\u0002\u001b\n\b\u0001\u0005\u0006?\u0002\u0005\u0016\f\u0010 \r\u001d\u0006\u001b\r\b\u000f"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            connectionManager.f_pC.m_Da((short)(0xBEF & 0x74DE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ExceptionDetails.m_EF((Object)"e\u001dw\u001bb*y\u0007x\fu\u001d\u007f\u0006x\u001aT\u0010F\u001by\u0003s\nb r x\u001ds\u001bx\bz"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            connectionManager.f_pC.m_Da((short)(0x43DF & 0x3CEF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_si.m_fCa((Object)"\u001a\u0017\u0006\u0013*\f\u0007\r\f\u0000\u001d\n\u0006\r\u001a!\u00103\u001b\f\u0003\u0006\n\u0017 \u0007 \r\u001d\u0006\u001b\r\b\u000f"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            connectionManager.f_pC.m_Da((short)(0x5DD4 & 0x22FB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ExceptionDetails.m_EF((Object)"\u000es\u001dU\u0006x\u0007s\nb\u0000y\u0007E\u001dw\u001dc\u001as\u001aT\u0010F\u001by\u0003s\nb r x\u001ds\u001bx\bz"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String[].class;
            connectionManager.f_pC.m_Da((short)(0x57F9 & 0x28D7), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_si.m_fCa((Object)"\u000e\u0006\u001d \u0006\r\u0007\u0006\n\u0017\u0000\f\u00070\u001d\u0002\u001d\u0016\u001a\u0006\u001a!\u0010*\r\u0010 \r\u001d\u0006\u001b\r\b\u000f"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = String.class;
            connectionManager.f_pC.m_Da((short)(0x15FF & 0x6AD2), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ExceptionDetails.m_EF((Object)"\u000bd\u0006a\u001as*y\u0007x\fu\u001d\u007f\u0006x x\u001ds\u001bx\bz"), classArray10));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(c_si.m_fCa((Object)"/\u0002\u0000\u000f\f\u0007I\u0017\u0006C\u001b\u0006\u000e\n\u001a\u0017\f\u0011I \u0006\r\u0007\u0006\n\u0017\u0000\f\u0007.\b\r\b\u0004\f\u0011I19 I\u000e\f\u0017\u0001\f\r\u0010"), a);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(ExceptionDetails.m_EF((Object)"%S(R,DS69s\u001bp\u0006d\u0004\u007f\u0007qIt\u001by\u001ee\f6\u0006f\fd\bb\u0000y\u00076\u000fy\u001b6\ny\u0007x\fu\u001d\u007f\u0006xIm\u00146\u0005y\nw\u0005z\u00108"), a);
            return a2.browseConnectionInternal((String)a);
        }
        f_bc.debug(c_si.m_fCa((Object)"','N%&(',1SC;\u0006\u0018\u0016\f\u0010\u001d\n\u0007\u0004I\u000f\f\u0002\r\u0006\u001bC\u001d\fI\u0013\f\u0011\u000f\f\u001b\u000eI\u0001\u001b\f\u001e\u0010\fC\u0006\u0013\f\u0011\b\u0017\u0000\f\u0007C\u000f\f\u001bC\n\f\u0007\r\f\u0000\u001d\n\u0006\rI\u0018\u0014M"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = a;
            return a2.f_pC.m_Fa(Short.valueOf((short)(0x79FF & 0x6D2)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC browse connection " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.startConnection(connectionManager.f_aS.m_PAa((String)a, (String)a3).getId());
    }

    protected void startConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_Dt.m_mEa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_st.lock();
            try {
                Runnable runnable = () -> a2.lambda$startConnectionInternal$3((Connection)a);
                a2.fenced("Start connection " + a.getId(), runnable).run();
                return;
            }
            finally {
                a2.f_st.unlock();
            }
        }, a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_NJ> getConnectionStatuses(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(ExceptionDetails.m_EF((Object)"Z,W-S;,IQ\fb\u001d\u007f\u0007qIw\u0005zIu\u0006x\u0007s\nb\u0000y\u00076\u001ab\bb\u001ce\feIp\u0006dIf\u001by\u0003s\nbIm\u00146\u0005y\nw\u0005z\u00108"), a);
            return a2.getConnectionStatusesByProjectIdInternal((String)a);
        }
        f_bc.debug(c_si.m_fCa((Object)"-&-D/,\"-&;YI1\f\u0012\u001c\u0006\u001a\u0017\u0000\r\u000eC\u0005\u0006\b\u0007\f\u0011I\u0005\u0006\u0011I\u0002\u0005\u000fI\u0000\u0006\r\u0007\u0006\n\u0017\u0000\f\u0007C\u001a\u0017\b\u0017\u001c\u0010\f\u0010I\u0005\u0006\u0011I\u0013\u001b\f\u0003\u0006\n\u0017I\u0018\u0014M"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[2 & 5] = a;
            return (Map)a2.f_pC.m_Fa(Short.valueOf((short)(0x64D5 & 0x1BFA)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for project " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_NJ> getConnectionStatusesByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_aS.m_EAa((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ConnectionSummary::getId, connectionSummary -> {
            ConnectionManager a = connectionSummary;
            ConnectionManager a2 = this;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(ExceptionDetails.m_EF((Object)"%S(R,DS6:b\u0006f\u0019\u007f\u0007qIw\u0005zIu\u0006x\u0007s\nb\u0000y\u0007eIp\u0006dIf\u001by\u0003s\nbIm\u00146\u0005y\nw\u0005z\u00108"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_bc.debug(c_si.m_fCa((Object)"-&-D/,\"-&;YI1\f\u0012\u001c\u0006\u001a\u0017\u0000\r\u000eC\u0005\u0006\b\u0007\f\u0011I\u0017\u0006C\u001a\u0017\u0006\u0013I\u0002\u0005\u000fI\u0000\u0006\r\u0007\u0006\n\u0017\u0000\f\u0007\u0010I\u0005\u0006\u0011I\u0013\u001b\f\u0003\u0006\n\u0017I\u0018\u0014M"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 ^ 3] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x7AEF & 0x5DF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connections for project " + (String)a, (Throwable)exception);
        }
    }

    protected c_NJ getConnectionStatusInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_fu.m_uAa((String)a)) != null && a.m_av()) {
            return c_NJ.f_Ls;
        }
        return c_NJ.f_au;
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a = collection;
        ConnectionManager a2 = this;
        a.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((string, list) -> {
            Object a = string;
            ConnectionManager a2 = this;
            if ((a = a2.f_fu.m_uAa((String)a)) != null) {
                void a3;
                a.m_Zv((List)a3);
            }
        });
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        a.registerRemoteCallsWithClusterNode();
        f_bc.info(ExceptionDetails.m_EF((Object)"*y\u0007x\fu\u001d\u007f\u0006x$w\u0007w\u000es\u001b6\u0000x\u0000b\u0000w\u0005\u007f\u0013s\r6\bx\r6\u001bs\u000e\u007f\u001ab\fd\frIw\u001a6*z\u001ce\u001ds\u001bX\u0006r\fZ\u0000e\u001ds\u0007s\u001b8"));
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(ExceptionDetails.m_EF((Object)"Z,W-S;,IE\u001dy\u0019f\u0000x\u000e6\ny\u0007x\fu\u001d\u007f\u0006xIm\u00146\u0005y\nw\u0005z\u00108"), a);
            a2.stopConnectionInternal((String)a);
            return;
        }
        f_bc.debug(c_si.m_fCa((Object)"','N%&(',1SC;\u0006\u0018\u0016\f\u0010\u001d\n\u0007\u0004I\u000f\f\u0002\r\u0006\u001bC\u001d\fI\u0010\u001d\f\u0019C\n\f\u0007\r\f\u0000\u001d\n\u0006\rI\u0018\u0014M"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 ^ 3] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x4FEB & 0x30DE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connection " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_NJ> getConnectionStatusesByIdsInternal(String[] stringArray) {
        String[] a2 = stringArray;
        String[] a3 = this;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> ((ConnectionManager)a3).getConnectionStatusInternal(arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_NJ getConnectionStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ConnectionManager a3 = this;
        if ((a2 = a3.f_aS.m_lBa((String)a2, (String)a)) == null) {
            return c_NJ.f_au;
        }
        return a3.getConnectionStatus(a2.getId());
    }

    private /* synthetic */ Object lambda$browseConnectionInternal$2(String string) throws Exception {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_fu.m_uAa((String)a)) instanceof c_D) {
            return ((c_D)a).m_Aa();
        }
        throw new BrowseOperationException(c_si.m_fCa((Object)"+\u0011\u0006\u0014\u001a\u0006I\f\u0019\u0006\u001b\u0002\u001d\n\u0006\rI\r\u0006\u0017I\u0010\u001c\u0013\u0019\f\u001b\u0017\f\u0007"));
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(ExceptionDetails.m_EF((Object)"Z,W-S;,IE\u001dw\u001bb\u0000x\u000e6\ny\u0007x\fu\u001d\u007f\u0006xIm\u00146\u0005y\nw\u0005z\u00108"), a);
            a2.startConnectionInternal((String)a);
            return;
        }
        f_bc.debug(c_si.m_fCa((Object)"-&-D/,\"-&;YI1\f\u0012\u001c\u0006\u001a\u0017\u0000\r\u000eC\u0005\u0006\b\u0007\f\u0011I\u0017\u0006C\u001a\u0017\b\u0011\u001dC\n\f\u0007\r\f\u0000\u001d\n\u0006\rI\u0018\u0014M"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[5 >> 3] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x5BDD & 0x24EB)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connection " + (String)a, (Throwable)exception);
        }
    }

    public void notLeader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_pC.m_la();
        f_bc.info(c_si.m_fCa((Object)" \u0006\r\u0007\u0006\n\u0017\u0000\f\u0007.\b\r\b\u0004\f\u0011SC=\u000b\u0000\u0010I\r\u0006\u0007\fCA\u0018\u0014JI\n\u001aC',I/&-.&;C=+,C%&(',1GC:\u0017\u0006\u0013\u0019\n\u0007\u0004I\u0002\u0005\u000fI\u000f\u0006\u0000\b\u000fI\u0000\u0006\r\u0007\u0006\n\u0017\u0006\u0011\u001aMGM"), a);
        connectionManager2.f_st.lock();
        try {
            connectionManager.f_fu.m_jda();
            f_bc.info(ExceptionDetails.m_EF((Object)"*y\u0007x\fu\u001d\u007f\u0006x$w\u0007w\u000es\u001b6AX\u0006bIZ\fw\rs\u001b6\u0012k@,IW\u0005zIz\u0006u\bzIu\u0006x\u0007s\nb\u0006d\u001a6\u0001w\u001fsIt\fs\u00076\u001bs\u0018c\fe\u001ds\r6\u001dyIe\u001dy\u00196\bx\r6\nz\fw\u001bs\r6\u000fd\u0006{Iz\u0006u\bzIb\u001bw\n}\u0000x\u000e8"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_bc.error(c_si.m_fCa((Object)"*\f\u0007\r\f\u0000\u001d\n\u0006\r$\u0002\u0007\u0002\u000e\u0006\u001bCA-\u0006\u0017I/\f\u0002\r\u0006\u001bC\u0012\u001e@YI&\u001b\u0011\u0006\u0011I\u0007\u001c\u0011\u0000\r\u000eC\u0019\u0011\u0006\u0000\f\u0010\u001aC\u0006\u0005I\u0010\u001d\f\u0019\u0013\u0000\r\u000eC\u0005\f\n\u0002\u0005C\n\f\u0007\r\f\u0000\u001d\f\u001b\u0010SC\u0012\u001e"), objectArray);
            return;
        }
        finally {
            connectionManager.f_st.unlock();
        }
    }
}

