/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.HasFrame;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.y.c_Jl;
import com.inscada.mono.communication.base.y.c_SK;
import com.inscada.mono.expression.model.Expression;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@AttributeOverride(name="id", column=@Column(name="variable_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"}), @CheckAtLeastOneNotNull(fieldNames={"frameId", "frame"})})
public class Variable<TFrame extends Frame<?, ?>, TDevice extends Device<?, ?>, TConnection extends Connection<?>>
extends SpaceBaseModel
implements HasFrame<TFrame> {
    @Min(value=1L)
    @Column(name="log_period")
    protected Integer logPeriod;
    @PositiveOrZero
    @Column(name="pulse_off_duration")
    protected Integer pulseOffDuration;
    @Size(max=4000)
    @Column(name="value_expression")
    protected String valueExpressionCode;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="log_expression_id")
    protected Expression logExpression;
    @Column(name="log_expression_id", insertable=false, updatable=false)
    protected String logExpressionId;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    protected Project project;
    @Column(name="eng_full_scale")
    protected Double engFullScale;
    @NotNull
    @Column(name="keep_last_values")
    protected Boolean keepLastValues;
    @Column(name="eng_zero_scale")
    protected Double engZeroScale;
    @Column(name="value_expression_type")
    protected c_Jl valueExpressionType;
    protected String unit;
    @Column(name="frame_id", insertable=false, updatable=false)
    protected String frameId;
    @Column(name="log_min_value")
    protected Double logMinValue;
    @Column(name="project_id", insertable=false, updatable=false)
    protected String projectId;
    @Column(name="set_max_value")
    protected Double setMaxValue;
    @Size(max=20)
    protected String code;
    @NotNull
    @Column(name="active_flag")
    protected Boolean isActive;
    @PositiveOrZero
    @Column(name="pulse_on_duration")
    protected Integer pulseOnDuration;
    @Column(name="raw_zero_scale")
    protected Double rawZeroScale;
    @Column(name="raw_full_scale")
    protected Double rawFullScale;
    @NotNull
    @Column(name="pulse_off_flag")
    protected Boolean isPulseOff;
    @Column(name="set_min_value")
    protected Double setMinValue;
    @NotNull
    @Column(name="writable_flag", nullable=false)
    protected Boolean isWritable;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="value_expression_id")
    protected Expression valueExpression;
    @Size(max=255)
    protected String dsc;
    @Column(name="log_max_value")
    protected Double logMaxValue;
    @Column(name="log_type")
    protected c_SK logType;
    @Column(name="log_threshold")
    protected Double logThreshold;
    @Size(max=4000)
    @Column(name="log_expression")
    protected String logExpressionCode;
    @Column(name="value_expression_id", insertable=false, updatable=false)
    protected String valueExpressionId;
    @NotBlank
    @Size(max=100)
    protected String name;
    @JsonIgnore
    @Transient
    protected VariableValue<?> value;
    @NotNull
    @Column(name="pulse_on_flag")
    protected Boolean isPulseOn;
    @Column(name="fractional_digit_count")
    protected Short fractionalDigitCount;

    public void setFrameId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.frameId = a;
    }

    public Double getEngZeroScale() {
        Variable a;
        return a.engZeroScale;
    }

    public void setLogMaxValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.logMaxValue = a;
    }

    public Boolean getIsPulseOff() {
        Variable a;
        return a.isPulseOff;
    }

    public void setSetMaxValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.setMaxValue = a;
    }

    public void setPulseOnDuration(Integer n) {
        Object a = n;
        Variable a2 = this;
        a2.pulseOnDuration = a;
    }

    public void setValueExpressionCode(String string) {
        Object a = string;
        Variable a2 = this;
        a2.valueExpressionCode = a;
    }

    public void setLogExpressionId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.logExpressionId = a;
    }

    public Expression getLogExpression() {
        Variable a;
        return a.logExpression;
    }

    public void setLogExpression(Expression expression) {
        Variable a;
        Variable a2 = expression;
        Variable variable = a = this;
        variable.logExpression = a2;
        variable.logExpressionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    @JsonIgnore
    public TDevice getDevice() {
        Variable a;
        if (a.getFrame() == null) {
            return null;
        }
        return (TDevice)a.getFrame().getDevice();
    }

    public void setFractionalDigitCount(Short s) {
        Object a = s;
        Variable a2 = this;
        a2.fractionalDigitCount = a;
    }

    public Double getLogThreshold() {
        Variable a;
        return a.logThreshold;
    }

    public Double getEngFullScale() {
        Variable a;
        return a.engFullScale;
    }

    public void setLogPeriod(Integer n) {
        Object a = n;
        Variable a2 = this;
        a2.logPeriod = a;
    }

    public void setLogMinValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.logMinValue = a;
    }

    public void setSetMinValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.setMinValue = a;
    }

    public void setLogType(c_SK c_SK2) {
        Variable a = c_SK2;
        Variable a2 = this;
        a2.logType = a;
    }

    public Boolean getKeepLastValues() {
        Variable a;
        return a.keepLastValues;
    }

    public void setValue(VariableValue<?> variableValue) {
        VariableValue<?> a = variableValue;
        VariableValue<?> a2 = this;
        a2.value = a;
    }

    public Boolean getIsWritable() {
        Variable a;
        return a.isWritable;
    }

    public Boolean getIsPulseOn() {
        Variable a;
        return a.isPulseOn;
    }

    public String getDeviceId() {
        Variable a;
        if (a.getFrame() == null) {
            return null;
        }
        return a.getFrame().getDeviceId();
    }

    public void setPulseOffDuration(Integer n) {
        Object a = n;
        Variable a2 = this;
        a2.pulseOffDuration = a;
    }

    public Boolean getIsActive() {
        Variable a;
        return a.isActive;
    }

    public void setName(String string) {
        Object a = string;
        Variable a2 = this;
        a2.name = a;
    }

    public String getName() {
        Variable a;
        return a.name;
    }

    public Project getProject() {
        Variable a;
        return a.project;
    }

    public c_Jl getValueExpressionType() {
        Variable a;
        return a.valueExpressionType;
    }

    public void setIsPulseOff(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isPulseOff = a;
    }

    public void setRawFullScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.rawFullScale = a;
    }

    public void setIsPulseOn(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isPulseOn = a;
    }

    public void setUnit(String string) {
        Object a = string;
        Variable a2 = this;
        a2.unit = a;
    }

    public String getValueExpressionCode() {
        Variable a;
        return a.valueExpressionCode;
    }

    public void setValueExpression(Expression expression) {
        Variable a;
        Variable a2 = expression;
        Variable variable = a = this;
        variable.valueExpression = a2;
        variable.valueExpressionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setKeepLastValues(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.keepLastValues = a;
    }

    public void setValueExpressionId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.valueExpressionId = a;
    }

    public String getFrameId() {
        Variable a;
        return a.frameId;
    }

    public String getUnit() {
        Variable a;
        return a.unit;
    }

    public Integer getLogPeriod() {
        Variable a;
        return a.logPeriod;
    }

    public Double getRawFullScale() {
        Variable a;
        return a.rawFullScale;
    }

    public void setDsc(String string) {
        Object a = string;
        Variable a2 = this;
        a2.dsc = a;
    }

    public void setLogExpressionCode(String string) {
        Object a = string;
        Variable a2 = this;
        a2.logExpressionCode = a;
    }

    public void setValueExpressionType(c_Jl c_Jl2) {
        Variable a = c_Jl2;
        Variable a2 = this;
        a2.valueExpressionType = a;
    }

    public void setIsWritable(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isWritable = a;
    }

    public Double getLogMinValue() {
        Variable a;
        return a.logMinValue;
    }

    public String getConnectionId() {
        Variable a;
        if (a.getDevice() == null) {
            return null;
        }
        return a.getDevice().getConnectionId();
    }

    public int hashCode() {
        Variable a;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = super.hashCode();
        objectArray[3 & 5] = a.getProjectId();
        objectArray[5 >> 1] = a.getName();
        return Objects.hash(objectArray);
    }

    public Integer getPulseOnDuration() {
        Variable a;
        return a.pulseOnDuration;
    }

    public Variable() {
        Variable a;
    }

    public Expression getValueExpression() {
        Variable a;
        return a.valueExpression;
    }

    public String getCode() {
        Variable a;
        return a.code;
    }

    public String getLogExpressionId() {
        Variable a;
        return a.logExpressionId;
    }

    public void setIsActive(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isActive = a;
    }

    public String getDsc() {
        Variable a;
        return a.dsc;
    }

    public Double getSetMinValue() {
        Variable a;
        return a.setMinValue;
    }

    public void setProjectId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.projectId = a;
    }

    public Double getLogMaxValue() {
        Variable a;
        return a.logMaxValue;
    }

    public void setProject(Project project) {
        Variable a;
        Variable a2 = project;
        Variable variable = a = this;
        variable.project = a2;
        variable.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Double getSetMaxValue() {
        Variable a;
        return a.setMaxValue;
    }

    public Short getFractionalDigitCount() {
        Variable a;
        return a.fractionalDigitCount;
    }

    public void setLogThreshold(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.logThreshold = a;
    }

    public void setEngFullScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.engFullScale = a;
    }

    public Double getRawZeroScale() {
        Variable a;
        return a.rawZeroScale;
    }

    @JsonIgnore
    public TConnection getConnection() {
        Variable a;
        if (a.getDevice() == null) {
            return null;
        }
        return (TConnection)a.getDevice().getConnection();
    }

    public c_SK getLogType() {
        Variable a;
        return a.logType;
    }

    public VariableValue<?> getValue() {
        Variable a;
        return a.value;
    }

    public String getLogExpressionCode() {
        Variable a;
        return a.logExpressionCode;
    }

    public Integer getPulseOffDuration() {
        Variable a;
        return a.pulseOffDuration;
    }

    public String getProjectId() {
        Variable a;
        return a.projectId;
    }

    public boolean equals(Object object) {
        Variable a = this;
        Object a2 = object;
        if (a == a2) {
            return --1 != 0;
        }
        if (!(a2 instanceof Variable)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 & 4) != 0;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return --1 != 0;
        }
        return false;
    }

    public String getValueExpressionId() {
        Variable a;
        return a.valueExpressionId;
    }

    public void setRawZeroScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.rawZeroScale = a;
    }

    public void setCode(String string) {
        Object a = string;
        Variable a2 = this;
        a2.code = a;
    }

    public void setEngZeroScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.engZeroScale = a;
    }
}

